/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.module;

import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IIntArray;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.tools.common.network.InventorySlotSyncPacket;

public class MeltingModule
implements IMeltingInventory,
IIntArray {
    public static final int NO_SPACE = -1;
    private static final String TAG_CURRENT_TIME = "time";
    private static final String TAG_REQUIRED_TIME = "required";
    private static final String TAG_REQUIRED_TEMP = "temp";
    private static final int CURRENT_TIME = 0;
    private static final int REQUIRED_TIME = 1;
    private static final int REQUIRED_TEMP = 2;
    private final MantleTileEntity parent;
    private final Predicate<FluidStack> outputFunction;
    private final IntSupplier nuggetsPerOre;
    private final int slotIndex;
    private int currentTime = 0;
    private int requiredTime = 0;
    private int requiredTemp = 0;
    private IMeltingRecipe lastRecipe;
    private ItemStack stack = ItemStack.field_190927_a;

    @Override
    public int getNuggetsPerOre() {
        return this.nuggetsPerOre.getAsInt();
    }

    private void resetRecipe() {
        this.currentTime = 0;
        this.requiredTime = 0;
        this.requiredTemp = 0;
    }

    public void setStack(ItemStack newStack) {
        IMeltingRecipe recipe;
        World world = this.parent.func_145831_w();
        if (this.slotIndex != -1 && world != null && !world.field_72995_K && !ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)newStack)) {
            TinkerNetwork.getInstance().sendToClientsAround(new InventorySlotSyncPacket(newStack, this.slotIndex, this.parent.func_174877_v()), (IWorld)world, this.parent.func_174877_v());
        }
        if (newStack.func_190926_b()) {
            this.resetRecipe();
        } else if (this.stack.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)newStack)) {
            this.currentTime = 0;
        }
        this.stack = newStack;
        int newTime = 0;
        int newTemp = 0;
        if (!this.stack.func_190926_b() && (recipe = this.findRecipe()) != null) {
            newTime = recipe.getTime(this) * 10;
            newTemp = recipe.getTemperature(this);
        }
        this.requiredTime = newTime;
        this.requiredTemp = newTemp;
        this.parent.markDirtyFast();
    }

    public boolean canHeatItem(int temperature) {
        if (this.requiredTime > 0) {
            if (this.stack.func_190926_b()) {
                this.resetRecipe();
                return false;
            }
            return this.currentTime != -1 && temperature >= this.requiredTemp;
        }
        return false;
    }

    public void heatItem(int temperature) {
        if (this.currentTime == -1 || this.canHeatItem(temperature)) {
            if (this.currentTime == -1 || this.currentTime >= this.requiredTime) {
                if (this.onItemFinishedHeating()) {
                    this.resetRecipe();
                }
            } else {
                this.currentTime += temperature / 100;
            }
        }
    }

    public void coolItem() {
        if (this.currentTime == -1) {
            if (this.onItemFinishedHeating()) {
                this.resetRecipe();
            }
        } else if (this.currentTime > 0 && this.requiredTime > 0) {
            this.currentTime -= 5;
        }
    }

    @Nullable
    private IMeltingRecipe findRecipe() {
        World world = this.parent.func_145831_w();
        if (world == null) {
            return null;
        }
        IMeltingRecipe last = this.lastRecipe;
        if (last != null && last.func_77569_a((IInventory)this, world)) {
            return last;
        }
        Optional newRecipe = world.func_199532_z().func_215371_a(RecipeTypes.MELTING, (IInventory)this, world);
        if (newRecipe.isPresent()) {
            this.lastRecipe = (IMeltingRecipe)newRecipe.get();
            return this.lastRecipe;
        }
        return null;
    }

    private boolean onItemFinishedHeating() {
        IMeltingRecipe recipe = this.findRecipe();
        if (recipe == null) {
            return true;
        }
        FluidStack output = recipe.getOutput(this);
        if (output.isEmpty()) {
            return true;
        }
        if (this.outputFunction.test(output)) {
            this.setStack(ItemStack.field_190927_a);
            return true;
        }
        this.currentTime = -1;
        return false;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.stack.func_190926_b()) {
            this.stack.func_77955_b(nbt);
            nbt.func_74768_a(TAG_CURRENT_TIME, this.currentTime);
            nbt.func_74768_a(TAG_REQUIRED_TIME, this.requiredTime);
            nbt.func_74768_a(TAG_REQUIRED_TEMP, this.requiredTemp);
        }
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.stack = ItemStack.func_199557_a((CompoundNBT)nbt);
        if (!this.stack.func_190926_b()) {
            this.currentTime = nbt.func_74762_e(TAG_CURRENT_TIME);
            this.requiredTime = nbt.func_74762_e(TAG_REQUIRED_TIME);
            this.requiredTemp = nbt.func_74762_e(TAG_REQUIRED_TEMP);
        }
    }

    public int func_221478_a() {
        return 3;
    }

    public int func_221476_a(int index) {
        switch (index) {
            case 0: {
                return this.currentTime;
            }
            case 1: {
                return this.requiredTime;
            }
            case 2: {
                return this.requiredTemp;
            }
        }
        return 0;
    }

    public void func_221477_a(int index, int value) {
        switch (index) {
            case 0: {
                this.currentTime = value;
                break;
            }
            case 1: {
                this.requiredTime = value;
                break;
            }
            case 2: {
                this.requiredTemp = value;
            }
        }
    }

    public MeltingModule(MantleTileEntity parent, Predicate<FluidStack> outputFunction, IntSupplier nuggetsPerOre, int slotIndex) {
        this.parent = parent;
        this.outputFunction = outputFunction;
        this.nuggetsPerOre = nuggetsPerOre;
        this.slotIndex = slotIndex;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public int getRequiredTime() {
        return this.requiredTime;
    }

    public int getRequiredTemp() {
        return this.requiredTemp;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

