/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.module;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.alloying.IAlloyTank;

public class AlloyingModule {
    private final MantleTileEntity parent;
    private final IAlloyTank alloyTank;
    @Nullable
    private List<AlloyRecipe> lastRecipes;
    private final Predicate<AlloyRecipe> canPerform;
    private final Predicate<AlloyRecipe> performRecipe;

    public AlloyingModule(MantleTileEntity parent, IFluidHandler fluidHandler, IAlloyTank alloyTank) {
        this.parent = parent;
        this.alloyTank = alloyTank;
        this.canPerform = recipe -> recipe.canPerform(alloyTank);
        this.performRecipe = recipe -> {
            recipe.performRecipe(alloyTank, fluidHandler);
            return false;
        };
    }

    private World getWorld() {
        return Objects.requireNonNull(this.parent.func_145831_w(), "Parent tile entity has null world");
    }

    private List<AlloyRecipe> getRecipes() {
        if (this.lastRecipes == null) {
            this.lastRecipes = this.getWorld().func_199532_z().func_215370_b(RecipeTypes.ALLOYING, (IInventory)this.alloyTank, this.getWorld());
        }
        return this.lastRecipes;
    }

    private boolean iterateRecipes(Predicate<AlloyRecipe> predicate) {
        List<AlloyRecipe> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return false;
        }
        World world = this.getWorld();
        Iterator<AlloyRecipe> iterator = recipes.iterator();
        while (iterator.hasNext()) {
            AlloyRecipe recipe = iterator.next();
            if (recipe.matches(this.alloyTank, world)) {
                if (!predicate.test(recipe)) continue;
                return true;
            }
            iterator.remove();
        }
        return false;
    }

    public boolean canAlloy() {
        return this.iterateRecipes(this.canPerform);
    }

    public void doAlloy() {
        List<AlloyRecipe> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        Collections.shuffle(recipes);
        this.iterateRecipes(this.performRecipe);
    }

    public void clearCachedRecipes() {
        this.lastRecipes = null;
    }
}

