/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.tileentity.ITankTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.SmelteryComponentTileEntity;

public class TankTileEntity
extends SmelteryComponentTileEntity
implements ITankTileEntity {
    public static final int DEFAULT_CAPACITY = 4000;
    protected final FluidTankAnimated tank;
    private final LazyOptional<IFluidHandler> holder;
    private final IModelData modelData;
    private int lastStrength = -1;

    public static int getCapacity(Block block) {
        if (block instanceof SearedTankBlock) {
            return ((SearedTankBlock)block).getCapacity();
        }
        return 4000;
    }

    public static int getCapacity(Item item) {
        if (item instanceof BlockItem) {
            return TankTileEntity.getCapacity(((BlockItem)item).func_179223_d());
        }
        return 4000;
    }

    public TankTileEntity() {
        this((SearedTankBlock)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.TANK));
    }

    public TankTileEntity(SearedTankBlock block) {
        this((TileEntityType)TinkerSmeltery.tank.get(), block);
    }

    protected TankTileEntity(TileEntityType<?> type, SearedTankBlock block) {
        super(type);
        this.tank = new FluidTankAnimated(block.getCapacity(), this);
        this.holder = LazyOptional.of(() -> this.tank);
        this.modelData = new SinglePropertyData(ModelProperties.FLUID_TANK, (Object)this.tank);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    @Override
    public void onTankContentsChanged() {
        ITankTileEntity.super.onTankContentsChanged();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        ITankTileEntity.super.updateFluidTo(fluid);
        if (this.field_145850_b != null) {
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.tank.setCapacity(TankTileEntity.getCapacity(state.func_177230_c()));
        this.updateTank(tag.func_74775_l("tank"));
        super.func_230337_a_(state, tag);
    }

    public void updateTank(CompoundNBT nbt) {
        if (nbt.isEmpty()) {
            this.tank.setFluid(FluidStack.EMPTY);
        } else {
            this.tank.readFromNBT(nbt);
        }
    }

    public void writeSynced(CompoundNBT tag) {
        if (!this.tank.isEmpty()) {
            tag.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        }
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }
}

