/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.tileentity.NamableTileEntity;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.SmelteryControllerBlock;
import slimeknights.tconstruct.smeltery.inventory.SmelteryContainer;
import slimeknights.tconstruct.smeltery.network.SmelteryStructureUpdatedPacket;
import slimeknights.tconstruct.smeltery.tileentity.module.AlloyingModule;
import slimeknights.tconstruct.smeltery.tileentity.module.EntityMeltingModule;
import slimeknights.tconstruct.smeltery.tileentity.module.FuelModule;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.tileentity.module.SmelteryAlloyTank;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.tank.IDisplayFluidListener;
import slimeknights.tconstruct.smeltery.tileentity.tank.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.tileentity.tank.SmelteryTank;

public class SmelteryTileEntity
extends NamableTileEntity
implements ITickableTileEntity,
IMasterLogic,
ISmelteryTankHandler {
    private static final String TAG_STRUCTURE = "structure";
    private static final String TAG_TANK = "tank";
    private static final String TAG_INVENTORY = "inventory";
    private static final int CAPACITY_PER_BLOCK = 1152;
    private static final int BLOCKS_PER_FUEL = 10;
    private final MultiblockSmeltery multiblock = new MultiblockSmeltery(this);
    @Nullable
    private MultiblockSmeltery.StructureData structure;
    private final SmelteryTank tank = new SmelteryTank(this);
    private LazyOptional<IFluidHandler> fluidCapability = LazyOptional.empty();
    private final MeltingModuleInventory meltingInventory = new MeltingModuleInventory((MantleTileEntity)this, this.tank, () -> Config.COMMON.smelteryNuggetsPerOre.get());
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.meltingInventory);
    private final FuelModule fuelModule = new FuelModule((MantleTileEntity)this, () -> this.structure != null ? this.structure.getTanks() : Collections.emptyList());
    private int fuelRate = 1;
    private int tick = 0;
    private int expandCounter = 0;
    private boolean structureUpdateQueued = false;
    private boolean fluidUpdateQueued = false;
    private AxisAlignedBB defaultBounds;
    private final SmelteryAlloyTank alloyTank = new SmelteryAlloyTank(this.tank);
    private final AlloyingModule alloyingModule = new AlloyingModule((MantleTileEntity)this, this.tank, this.alloyTank);
    private final EntityMeltingModule entityModule = new EntityMeltingModule((MantleTileEntity)this, this.tank, this::canMeltEntities, this::insertIntoInventory, () -> this.structure == null ? null : this.structure.getBounds());
    private final IModelData modelData = new SinglePropertyData(IDisplayFluidListener.PROPERTY);
    private final List<WeakReference<IDisplayFluidListener>> fluidDisplayListeners = new ArrayList<WeakReference<IDisplayFluidListener>>();
    private final Consumer<ItemStack> dropItem = this::dropItem;

    public SmelteryTileEntity() {
        super((TileEntityType)TinkerSmeltery.smeltery.get(), (ITextComponent)new TranslationTextComponent(Util.makeTranslationKey("gui", "smeltery")));
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState state = this.func_195044_w();
        if (!state.func_235901_b_((Property)ControllerBlock.IN_STRUCTURE)) {
            return;
        }
        if (this.structureUpdateQueued) {
            this.checkStructure();
            this.structureUpdateQueued = false;
        }
        if (this.structure != null && ((Boolean)state.func_177229_b((Property)SmelteryControllerBlock.IN_STRUCTURE)).booleanValue()) {
            if (this.tick == 0) {
                ++this.expandCounter;
                if (this.expandCounter >= 10) {
                    this.expandCounter = 0;
                    if (this.multiblock.canExpand(this.structure, this.field_145850_b)) {
                        this.updateStructure();
                    }
                }
            } else if (this.tick % 4 == 0 && !this.multiblock.isInnerBlock(this.field_145850_b, this.structure.getNextInsideCheck())) {
                this.updateStructure();
            }
            if (this.structure.hasTanks()) {
                boolean entityMelted = false;
                if (this.tick == 12) {
                    entityMelted = this.entityModule.interactWithEntities();
                }
                switch (this.tick % 4) {
                    case 0: {
                        if (this.fuelModule.hasFuel()) break;
                        if (entityMelted) {
                            this.fuelModule.findFuel(true);
                            break;
                        }
                        int possibleTemp = this.fuelModule.findFuel(false);
                        this.alloyTank.setTemperature(possibleTemp);
                        if (!this.meltingInventory.canHeat(possibleTemp) && !this.alloyingModule.canAlloy()) break;
                        this.fuelModule.findFuel(true);
                        break;
                    }
                    case 1: {
                        if (this.fuelModule.hasFuel()) {
                            this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                            break;
                        }
                        this.meltingInventory.coolItems();
                        break;
                    }
                    case 2: {
                        if (!this.fuelModule.hasFuel()) break;
                        this.alloyTank.setTemperature(this.fuelModule.getTemperature());
                        this.alloyingModule.doAlloy();
                        break;
                    }
                    case 3: {
                        boolean hasFuel = this.fuelModule.hasFuel();
                        if ((Boolean)state.func_177229_b((Property)ControllerBlock.ACTIVE) != hasFuel) {
                            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                        }
                        this.fuelModule.decreaseFuel(this.fuelRate);
                    }
                }
            }
            if (this.tick % 4 == 3 && this.fluidUpdateQueued) {
                this.fluidUpdateQueued = false;
                this.tank.syncFluids();
            }
        } else if (this.tick == 0) {
            this.updateStructure();
        }
        this.tick = (this.tick + 1) % 20;
    }

    protected void dropItem(ItemStack stack) {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K && !stack.func_190926_b()) {
            double x = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double y = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double z = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25;
            BlockPos pos = this.field_174879_c.func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)ControllerBlock.FACING));
            ItemEntity itementity = new ItemEntity(this.field_145850_b, (double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z, stack);
            itementity.func_174869_p();
            this.field_145850_b.func_217376_c((Entity)itementity);
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void updateStructure() {
        this.structureUpdateQueued = true;
    }

    private void setStructure(@Nullable MultiblockSmeltery.StructureData structure) {
        this.structure = structure;
        if (structure != null) {
            int size = structure.getInternalSize();
            this.tank.setCapacity(1152 * size);
            this.meltingInventory.resize(size, this.dropItem);
            this.fuelRate = 1 + structure.getPerimeterCount() / 10;
        }
    }

    protected void checkStructure() {
        boolean formed;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean wasFormed = (Boolean)this.func_195044_w().func_177229_b((Property)ControllerBlock.IN_STRUCTURE);
        MultiblockSmeltery.StructureData oldStructure = this.structure;
        MultiblockSmeltery.StructureData newStructure = this.multiblock.detectMultiblock(this.field_145850_b, this.field_174879_c, (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J));
        boolean bl = formed = newStructure != null;
        if (formed != wasFormed) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)ControllerBlock.IN_STRUCTURE, (Comparable)Boolean.valueOf(formed)));
        }
        if (formed) {
            TinkerNetwork.getInstance().sendToClientsAround(new SmelteryStructureUpdatedPacket(this.field_174879_c, newStructure.getMinPos(), newStructure.getMaxPos(), newStructure.getTanks()), (IWorld)this.field_145850_b, this.field_174879_c);
            newStructure.assignMaster(this, oldStructure);
            this.setStructure(newStructure);
            if (!this.fluidCapability.isPresent()) {
                this.fluidCapability = LazyOptional.of(() -> this.tank);
            }
        } else {
            if (oldStructure != null) {
                oldStructure.clearMaster(this);
            }
            this.setStructure(null);
            if (this.fluidCapability.isPresent()) {
                this.fluidCapability.invalidate();
                this.fluidCapability = LazyOptional.empty();
            }
        }
        this.expandCounter = 0;
    }

    public void invalidateStructure() {
        if (this.structure != null) {
            this.structure.clearMaster(this);
            this.structure = null;
        }
    }

    @Override
    public void notifyChange(IServantLogic servant, BlockPos pos, BlockState state) {
        if (this.structure == null) {
            return;
        }
        assert (this.field_145850_b != null);
        if (this.multiblock.shouldUpdate(this.field_145850_b, this.structure, pos, state)) {
            this.updateStructure();
        }
    }

    @Override
    public void updateFluidsFromPacket(List<FluidStack> fluids) {
        this.tank.setFluids(fluids);
    }

    private void updateDisplayFluid(Fluid fluid) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.modelData.setData(IDisplayFluidListener.PROPERTY, (Object)fluid);
            this.requestModelDataUpdate();
            BlockState state = this.func_195044_w();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 48);
            Iterator<WeakReference<IDisplayFluidListener>> iterator = this.fluidDisplayListeners.iterator();
            while (iterator.hasNext()) {
                IDisplayFluidListener listener = (IDisplayFluidListener)iterator.next().get();
                if (listener == null) {
                    iterator.remove();
                    continue;
                }
                listener.notifyDisplayFluidUpdated(fluid);
            }
        }
    }

    @Override
    public void addDisplayListener(IDisplayFluidListener listener) {
        this.fluidDisplayListeners.add(new WeakReference<IDisplayFluidListener>(listener));
        listener.notifyDisplayFluidUpdated(this.tank.getFluidInTank(0).getFluid());
    }

    @Override
    public void notifyFluidsChanged(ISmelteryTankHandler.FluidChange type, Fluid fluid) {
        if (type == ISmelteryTankHandler.FluidChange.ORDER_CHANGED) {
            this.updateDisplayFluid(fluid);
        } else {
            if (type == ISmelteryTankHandler.FluidChange.ADDED) {
                this.alloyingModule.clearCachedRecipes();
            }
            this.fluidUpdateQueued = true;
            this.markDirtyFast();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.structure != null) {
            return this.structure.getBounds();
        }
        if (this.defaultBounds == null) {
            this.defaultBounds = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return this.defaultBounds;
    }

    private boolean canMeltEntities() {
        if (this.fuelModule.hasFuel()) {
            return true;
        }
        return this.fuelModule.findFuel(false) > 0;
    }

    private ItemStack insertIntoInventory(ItemStack stack) {
        return ItemHandlerHelper.insertItem((IItemHandler)this.meltingInventory, (ItemStack)stack, (boolean)false);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new SmelteryContainer(id, inv, this);
    }

    public void setStructureSize(BlockPos minPos, BlockPos maxPos, List<BlockPos> tanks) {
        this.setStructure(this.multiblock.createClient(minPos, maxPos, tanks));
        this.fuelModule.clearCachedDisplayListeners();
        if (this.structure == null) {
            this.fluidDisplayListeners.clear();
        } else {
            this.fluidDisplayListeners.removeIf(reference -> {
                IDisplayFluidListener listener = (IDisplayFluidListener)reference.get();
                return listener == null || !this.structure.contains(listener.getListenerPos());
            });
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_150297_b(TAG_TANK, 10)) {
            this.tank.read(nbt.func_74775_l(TAG_TANK));
            Fluid first = this.tank.getFluidInTank(0).getFluid();
            if (first != Fluids.field_204541_a) {
                this.updateDisplayFluid(first);
            }
        }
        if (nbt.func_150297_b(TAG_INVENTORY, 10)) {
            this.meltingInventory.readFromNBT(nbt.func_74775_l(TAG_INVENTORY));
        }
        if (nbt.func_150297_b(TAG_STRUCTURE, 10)) {
            this.setStructure(this.multiblock.readFromNBT(nbt.func_74775_l(TAG_STRUCTURE)));
            if (this.structure != null) {
                this.fluidCapability = LazyOptional.of(() -> this.tank);
            }
        }
        this.fuelModule.readFromNBT(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        if (this.structure != null) {
            compound.func_218657_a(TAG_STRUCTURE, (INBT)this.structure.writeToNBT());
        }
        this.fuelModule.writeToNBT(compound);
        return compound;
    }

    public void writeSynced(CompoundNBT compound) {
        super.writeSynced(compound);
        compound.func_218657_a(TAG_TANK, (INBT)this.tank.write(new CompoundNBT()));
        compound.func_218657_a(TAG_INVENTORY, (INBT)this.meltingInventory.writeToNBT());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.structure != null) {
            nbt.func_218657_a(TAG_STRUCTURE, (INBT)this.structure.writeClientNBT());
        }
        return nbt;
    }

    @Nullable
    public MultiblockSmeltery.StructureData getStructure() {
        return this.structure;
    }

    @Override
    public SmelteryTank getTank() {
        return this.tank;
    }

    @Override
    public LazyOptional<IFluidHandler> getFluidCapability() {
        return this.fluidCapability;
    }

    public MeltingModuleInventory getMeltingInventory() {
        return this.meltingInventory;
    }

    public FuelModule getFuelModule() {
        return this.fuelModule;
    }

    public AlloyingModule getAlloyingModule() {
        return this.alloyingModule;
    }

    public IModelData getModelData() {
        return this.modelData;
    }
}

