/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.block.TankModel;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public interface ITankTileEntity
extends IFluidTankUpdater,
FluidUpdatePacket.IFluidPacketReceiver {
    public FluidTankAnimated getTank();

    default public int comparatorStrength() {
        FluidTankAnimated tank = this.getTank();
        return 15 * tank.getFluidAmount() / tank.getCapacity();
    }

    public int getLastStrength();

    public void setLastStrength(int var1);

    @Override
    default public void onTankContentsChanged() {
        int newStrength = this.comparatorStrength();
        TileEntity te = this.getTE();
        World world = te.func_145831_w();
        if (newStrength != this.getLastStrength() && world != null) {
            world.func_195593_d(te.func_174877_v(), te.func_195044_w().func_177230_c());
            this.setLastStrength(newStrength);
        }
    }

    @Override
    default public void updateFluidTo(FluidStack fluid) {
        FluidTankAnimated tank = this.getTank();
        int oldAmount = tank.getFluidAmount();
        int newAmount = fluid.getAmount();
        tank.setFluid(fluid);
        tank.setRenderOffset(tank.getRenderOffset() + (float)newAmount - (float)oldAmount);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            TileEntity te;
            TankModel.BakedModel model;
            if (((Boolean)Config.CLIENT.tankFluidModel.get()).booleanValue() && (model = (TankModel.BakedModel)ModelHelper.getBakedModel((BlockState)(te = this.getTE()).func_195044_w(), TankModel.BakedModel.class)) != null && (Math.abs(newAmount - oldAmount) >= tank.getCapacity() / model.getFluid().getIncrements() || oldAmount == 0 != (newAmount == 0))) {
                Minecraft.func_71410_x().field_71438_f.func_184376_a(null, te.func_174877_v(), null, null, 3);
            }
        });
    }

    default public TileEntity getTE() {
        return (TileEntity)this;
    }

    public static int getComparatorInputOverride(IWorld world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ITankTileEntity)) {
            return 0;
        }
        return ((ITankTileEntity)te).comparatorStrength();
    }
}

