/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.tileentity.NamableTileEntity;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.inventory.SingleItemContainer;
import slimeknights.tconstruct.smeltery.tileentity.inventory.HeaterItemHandler;

public class HeaterTileEntity
extends NamableTileEntity {
    private static final String TAG_ITEM = "item";
    private static final ITextComponent TITLE = new TranslationTextComponent(Util.makeTranslationKey("gui", "heater"));
    private final HeaterItemHandler itemHandler = new HeaterItemHandler((MantleTileEntity)this);
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);

    protected HeaterTileEntity(TileEntityType<?> type) {
        super(type, TITLE);
    }

    public HeaterTileEntity() {
        this((TileEntityType)TinkerSmeltery.heater.get());
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new SingleItemContainer(id, inventory, (TileEntity)this);
    }

    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        if (tags.func_150297_b(TAG_ITEM, 10)) {
            this.itemHandler.readFromNBT(tags.func_74775_l(TAG_ITEM));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.writeSynced(tags);
        tags.func_218657_a(TAG_ITEM, (INBT)this.itemHandler.writeToNBT());
        return tags;
    }
}

