/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.network.FaucetActivationPacket;

public class FaucetTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final int MB_PER_TICK = 12;
    public static final int PACKET_SIZE = 144;
    private static final String TAG_DRAINED = "drained";
    private static final String TAG_RENDER_FLUID = "render_fluid";
    private static final String TAG_STOP = "stop";
    private static final String TAG_STATE = "state";
    private static final String TAG_LAST_REDSTONE = "lastRedstone";
    private FaucetState faucetState = FaucetState.OFF;
    private boolean stopPouring = false;
    private FluidStack drained = FluidStack.EMPTY;
    private FluidStack renderFluid = FluidStack.EMPTY;
    private boolean lastRedstoneState = false;
    private LazyOptional<IFluidHandler> inputHandler;
    private LazyOptional<IFluidHandler> outputHandler;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> inputListener = new WeakConsumerWrapper((Object)this, (self, handler) -> {
        self.inputHandler = null;
    });
    private final NonNullConsumer<LazyOptional<IFluidHandler>> outputListener = new WeakConsumerWrapper((Object)this, (self, handler) -> {
        self.outputHandler = null;
    });

    public FaucetTileEntity() {
        this((TileEntityType)TinkerSmeltery.faucet.get());
    }

    protected FaucetTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    private LazyOptional<IFluidHandler> findFluidHandler(Direction side) {
        LazyOptional handler;
        assert (this.field_145850_b != null);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (te != null && (handler = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())).isPresent()) {
            return handler;
        }
        return LazyOptional.empty();
    }

    private LazyOptional<IFluidHandler> getInputHandler() {
        if (this.inputHandler == null) {
            this.inputHandler = this.findFluidHandler(((Direction)this.func_195044_w().func_177229_b((Property)FaucetBlock.FACING)).func_176734_d());
            if (this.inputHandler.isPresent()) {
                this.inputHandler.addListener(this.inputListener);
            }
        }
        return this.inputHandler;
    }

    private LazyOptional<IFluidHandler> getOutputHandler() {
        if (this.outputHandler == null) {
            this.outputHandler = this.findFluidHandler(Direction.DOWN);
            if (this.outputHandler.isPresent()) {
                this.outputHandler.addListener(this.outputListener);
            }
        }
        return this.outputHandler;
    }

    public void neighborChanged(BlockPos neighbor) {
        if (this.field_174879_c.equals((Object)neighbor.func_177984_a())) {
            this.outputHandler = null;
        } else if (this.field_174879_c.equals((Object)neighbor.func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)FaucetBlock.FACING)))) {
            this.inputHandler = null;
        }
    }

    public boolean isPouring() {
        return this.faucetState != FaucetState.OFF;
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    public void activate() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        switch (this.faucetState) {
            case OFF: {
                this.stopPouring = false;
                this.doTransfer(true);
                break;
            }
            case POWERED: {
                this.faucetState = FaucetState.OFF;
                this.syncToClient(FluidStack.EMPTY, false);
                break;
            }
            case POURING: {
                this.stopPouring = true;
            }
        }
    }

    public void handleRedstone(boolean hasSignal) {
        if (hasSignal != this.lastRedstoneState) {
            this.lastRedstoneState = hasSignal;
            if (hasSignal) {
                if (this.field_145850_b != null) {
                    this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)this.func_195044_w().func_177230_c(), 2);
                }
            } else if (this.faucetState == FaucetState.POWERED) {
                this.faucetState = FaucetState.OFF;
                this.syncToClient(FluidStack.EMPTY, false);
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.faucetState == FaucetState.OFF) {
            return;
        }
        if (this.faucetState == FaucetState.POWERED && this.doTransfer(false)) {
            this.faucetState = FaucetState.POURING;
            return;
        }
        if (!this.drained.isEmpty()) {
            this.pour();
        } else if (this.stopPouring) {
            this.reset();
        } else {
            this.doTransfer(true);
        }
    }

    private boolean doTransfer(boolean execute) {
        LazyOptional<IFluidHandler> inputOptional = this.getInputHandler();
        LazyOptional<IFluidHandler> outputOptional = this.getOutputHandler();
        if (inputOptional.isPresent() && outputOptional.isPresent()) {
            IFluidHandler output;
            int filled;
            IFluidHandler input = (IFluidHandler)inputOptional.orElse((Object)EmptyFluidHandler.INSTANCE);
            FluidStack drained = input.drain(144, IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && !drained.getFluid().getAttributes().isGaseous(drained) && (filled = (output = (IFluidHandler)outputOptional.orElse((Object)EmptyFluidHandler.INSTANCE)).fill(drained, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                if (execute) {
                    this.drained = input.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    if (this.faucetState == FaucetState.OFF || !this.renderFluid.isFluidEqual(drained)) {
                        this.syncToClient(this.drained, true);
                    }
                    this.faucetState = FaucetState.POURING;
                    this.pour();
                }
                return true;
            }
            if (this.lastRedstoneState) {
                if (execute && (this.faucetState == FaucetState.OFF || !this.renderFluid.isFluidEqual(FluidStack.EMPTY))) {
                    this.syncToClient(FluidStack.EMPTY, true);
                }
                this.faucetState = FaucetState.POWERED;
                return false;
            }
        }
        if (execute) {
            this.reset();
        }
        return false;
    }

    private void pour() {
        if (this.drained.isEmpty()) {
            return;
        }
        LazyOptional<IFluidHandler> outputOptional = this.getOutputHandler();
        if (outputOptional.isPresent()) {
            FluidStack fillStack = this.drained.copy();
            fillStack.setAmount(Math.min(this.drained.getAmount(), 12));
            IFluidHandler output = (IFluidHandler)outputOptional.orElse((Object)EmptyFluidHandler.INSTANCE);
            int filled = output.fill(fillStack, IFluidHandler.FluidAction.SIMULATE);
            if (filled > 0) {
                if (!this.renderFluid.isFluidEqual(this.drained)) {
                    this.syncToClient(this.drained, true);
                }
                this.drained.shrink(filled);
                fillStack.setAmount(filled);
                output.fill(fillStack, IFluidHandler.FluidAction.EXECUTE);
            }
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.stopPouring = false;
        this.drained = FluidStack.EMPTY;
        if (this.faucetState != FaucetState.OFF || !this.renderFluid.isFluidEqual(this.drained)) {
            this.faucetState = FaucetState.OFF;
            this.syncToClient(FluidStack.EMPTY, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    private void syncToClient(FluidStack fluid, boolean isPouring) {
        this.renderFluid = fluid.copy();
        if (this.field_145850_b instanceof ServerWorld) {
            TinkerNetwork.getInstance().sendToClientsAround(new FaucetActivationPacket(this.field_174879_c, fluid, isPouring), (ServerWorld)this.field_145850_b, this.func_174877_v());
        }
    }

    public void onActivationPacket(FluidStack fluid, boolean isPouring) {
        this.faucetState = isPouring ? FaucetState.POURING : FaucetState.OFF;
        this.renderFluid = fluid;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74774_a(TAG_STATE, (byte)this.faucetState.ordinal());
        compound.func_74757_a(TAG_STOP, this.stopPouring);
        compound.func_74757_a(TAG_LAST_REDSTONE, this.lastRedstoneState);
        if (!this.drained.isEmpty()) {
            compound.func_218657_a(TAG_DRAINED, (INBT)this.drained.writeToNBT(new CompoundNBT()));
        }
        if (!this.renderFluid.isEmpty()) {
            compound.func_218657_a(TAG_RENDER_FLUID, (INBT)this.renderFluid.writeToNBT(new CompoundNBT()));
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.faucetState = FaucetState.fromIndex(compound.func_74771_c(TAG_STATE));
        this.stopPouring = compound.func_74767_n(TAG_STOP);
        this.lastRedstoneState = compound.func_74767_n(TAG_LAST_REDSTONE);
        this.drained = compound.func_150297_b(TAG_DRAINED, 10) ? FluidStack.loadFluidStackFromNBT((CompoundNBT)compound.func_74775_l(TAG_DRAINED)) : FluidStack.EMPTY;
        this.renderFluid = compound.func_150297_b(TAG_RENDER_FLUID, 10) ? FluidStack.loadFluidStackFromNBT((CompoundNBT)compound.func_74775_l(TAG_RENDER_FLUID)) : FluidStack.EMPTY;
    }

    private static enum FaucetState {
        OFF,
        POURING,
        POWERED;


        public static FaucetState fromIndex(int index) {
            switch (index) {
                case 1: {
                    return POURING;
                }
                case 2: {
                    return POWERED;
                }
            }
            return OFF;
        }
    }
}

