/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.library.fluid.FillOnlyFluidHandler;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.ChannelBlock;
import slimeknights.tconstruct.smeltery.network.ChannelFlowPacket;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.tank.ChannelSideTank;
import slimeknights.tconstruct.smeltery.tileentity.tank.ChannelTank;

public class ChannelTileEntity
extends TileEntity
implements ITickableTileEntity,
FluidUpdatePacket.IFluidPacketReceiver {
    public static final int LIQUID_TRANSFER = 16;
    private final ChannelTank tank = new ChannelTank(36, this);
    private final LazyOptional<IFluidHandler> topHandler = LazyOptional.of(() -> new FillOnlyFluidHandler((IFluidHandler)this.tank));
    private final Map<Direction, LazyOptional<IFluidHandler>> sideTanks = (Map)Util.func_200696_a(new EnumMap(Direction.class), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, LazyOptional.of(() -> new ChannelSideTank(this, this.tank, direction)));
        }
    });
    private final Map<Direction, LazyOptional<IFluidHandler>> neighborTanks = new EnumMap<Direction, LazyOptional<IFluidHandler>>(Direction.class);
    private final Map<Direction, NonNullConsumer<LazyOptional<IFluidHandler>>> neighborConsumers = new EnumMap<Direction, NonNullConsumer<LazyOptional<IFluidHandler>>>(Direction.class);
    private final byte[] isFlowing = new byte[5];
    private static final String TAG_IS_FLOWING = "is_flowing";
    private static final String TAG_TANK = "tank";

    public ChannelTileEntity() {
        this((TileEntityType)TinkerSmeltery.channel.get());
    }

    protected ChannelTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null || side == Direction.UP) {
                return this.topHandler.cast();
            }
            if (side != Direction.DOWN && this.func_195044_w().func_177229_b((Property)ChannelBlock.DIRECTION_MAP.get(side)) == ChannelBlock.ChannelConnection.IN) {
                return this.sideTanks.get(side).cast();
            }
        }
        return super.getCapability(capability, side);
    }

    private LazyOptional<IFluidHandler> getNeighborHandlerUncached(Direction side) {
        LazyOptional handler;
        assert (this.field_145850_b != null);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (te != null && (handler = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())).isPresent()) {
            handler.addListener(this.neighborConsumers.computeIfAbsent(side, s -> new WeakConsumerWrapper((Object)this, (self, lazy) -> self.neighborTanks.remove(s))));
            return handler;
        }
        return LazyOptional.empty();
    }

    protected LazyOptional<IFluidHandler> getNeighborHandler(Direction side) {
        return this.neighborTanks.computeIfAbsent(side, this::getNeighborHandlerUncached);
    }

    public void removeCachedNeighbor(Direction side) {
        this.neighborTanks.remove(side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.topHandler.invalidate();
        for (LazyOptional<IFluidHandler> handler : this.sideTanks.values()) {
            handler.invalidate();
        }
    }

    private int getFlowIndex(Direction side) {
        if (side.func_176740_k().func_200128_b()) {
            return 0;
        }
        return side.func_176745_a() - 1;
    }

    public void setFlow(Direction side, boolean flowing) {
        if (side == Direction.UP) {
            return;
        }
        int index = this.getFlowIndex(side);
        boolean wasFlowing = this.isFlowing[index] > 0;
        this.isFlowing[index] = (byte)(flowing ? 2 : 0);
        if (wasFlowing != flowing && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.syncFlowToClient(side, flowing);
        }
    }

    public boolean isFlowing(Direction side) {
        if (side == Direction.UP) {
            return false;
        }
        return this.isFlowing[this.getFlowIndex(side)] > 0;
    }

    protected boolean isOutput(Direction side) {
        if (side == Direction.UP) {
            return false;
        }
        if (side == Direction.DOWN) {
            return (Boolean)this.func_195044_w().func_177229_b((Property)ChannelBlock.DOWN);
        }
        return this.func_195044_w().func_177229_b((Property)ChannelBlock.DIRECTION_MAP.get(side)) == ChannelBlock.ChannelConnection.OUT;
    }

    private static int countOutputs(BlockState state) {
        int count = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (state.func_177229_b((Property)ChannelBlock.DIRECTION_MAP.get(direction)) != ChannelBlock.ChannelConnection.OUT) continue;
            ++count;
        }
        return count;
    }

    private void syncFlowToClient(Direction side, boolean flowing) {
        TinkerNetwork.getInstance().sendToClientsAround(new ChannelFlowPacket(this.field_174879_c, side, flowing), (IWorld)this.field_145850_b, this.field_174879_c);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        FluidStack fluid = this.tank.getFluid();
        if (!fluid.isEmpty()) {
            boolean hasFlown = false;
            BlockState state = this.func_195044_w();
            if (((Boolean)state.func_177229_b((Property)ChannelBlock.DOWN)).booleanValue()) {
                hasFlown = this.trySide(Direction.DOWN, 12);
            }
            int outputs = ChannelTileEntity.countOutputs(state);
            if (!hasFlown && outputs > 0) {
                int flowRate = MathHelper.func_76125_a((int)(this.tank.getMaxUsable() / outputs), (int)1, (int)12);
                for (Direction side : Direction.Plane.HORIZONTAL) {
                    this.trySide(side, flowRate);
                }
            }
        }
        for (int i = 0; i < 5; ++i) {
            if (this.isFlowing[i] <= 0) continue;
            int n = i;
            this.isFlowing[n] = (byte)(this.isFlowing[n] - 1);
            if (this.isFlowing[i] != 0) continue;
            Direction direction = i == 0 ? Direction.DOWN : Direction.func_82600_a((int)(i + 1));
            this.syncFlowToClient(direction, false);
        }
        this.tank.freeFluid();
    }

    protected boolean trySide(Direction side, int flowRate) {
        if (this.tank.isEmpty() || !this.isOutput(side)) {
            return false;
        }
        return this.getNeighborHandler(side).filter(handler -> this.fill(side, (IFluidHandler)handler, flowRate)).isPresent();
    }

    protected boolean fill(Direction side, IFluidHandler handler, int amount) {
        FluidStack fluid;
        int filled;
        int usable = Math.min(this.tank.getMaxUsable(), amount);
        if (usable > 0 && (filled = handler.fill(fluid = this.tank.drain(usable, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE)) > 0) {
            fluid = this.tank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            this.setFlow(side, true);
            return true;
        }
        this.setFlow(side, false);
        return false;
    }

    public void sendFluidUpdate() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TinkerNetwork.getInstance().sendToClientsAround(new FluidUpdatePacket(this.field_174879_c, this.getFluid()), (IWorld)this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74773_a(TAG_IS_FLOWING, this.isFlowing);
        nbt.func_218657_a(TAG_TANK, (INBT)this.tank.writeToNBT(new CompoundNBT()));
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b(TAG_IS_FLOWING)) {
            byte[] nbtFlowing = nbt.func_74770_j(TAG_IS_FLOWING);
            int max = Math.min(5, nbtFlowing.length);
            for (int i = 0; i < max; ++i) {
                int b = nbtFlowing[i];
                this.isFlowing[i] = b > 2 ? 2 : (b < 0 ? 0 : b);
            }
        }
        CompoundNBT tankTag = nbt.func_74775_l(TAG_TANK);
        this.tank.readFromNBT(tankTag);
    }
}

