/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.smeltery.tileentity.SmelteryTileEntity;

public class SmelteryStructureUpdatedPacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final BlockPos minPos;
    private final BlockPos maxPos;
    private final List<BlockPos> tanks;

    public SmelteryStructureUpdatedPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.minPos = buffer.func_179259_c();
        this.maxPos = buffer.func_179259_c();
        int count = buffer.func_150792_a();
        this.tanks = new ArrayList<BlockPos>(count);
        for (int i = 0; i < count; ++i) {
            this.tanks.add(buffer.func_179259_c());
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_179255_a(this.minPos);
        buffer.func_179255_a(this.maxPos);
        buffer.func_150787_b(this.tanks.size());
        for (BlockPos tank : this.tanks) {
            buffer.func_179255_a(tank);
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    public SmelteryStructureUpdatedPacket(BlockPos pos, BlockPos minPos, BlockPos maxPos, List<BlockPos> tanks) {
        this.pos = pos;
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.tanks = tanks;
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(SmelteryStructureUpdatedPacket packet) {
            TileEntityHelper.getTile(SmelteryTileEntity.class, (IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)packet.pos).ifPresent(te -> te.setStructureSize(packet.minPos, packet.maxPos, packet.tanks));
        }
    }
}

