/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.util.FluidTooltipHandler;
import slimeknights.tconstruct.smeltery.tileentity.TankTileEntity;

public class TankItem
extends BlockTooltipItem {
    private static final String KEY_FLUID = Util.makeTranslationKey("block", "tank.fluid");
    private static final String KEY_MB = Util.makeTranslationKey("block", "tank.mb");
    private static final String KEY_INGOTS = Util.makeTranslationKey("block", "tank.ingots");
    private static final String KEY_MIXED = Util.makeTranslationKey("block", "tank.mixed");

    public TankItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public int getItemStackLimit(ItemStack stack) {
        FluidTank tank = TankItem.getFluidTank(stack);
        return tank.isEmpty() ? 64 : 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            FluidTank tank = TankItem.getFluidTank(stack);
            if (tank.getFluidAmount() > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent(KEY_FLUID, new Object[]{tank.getFluid().getDisplayName()}).func_240699_a_(TextFormatting.GRAY));
                int amount = tank.getFluidAmount();
                if (tank.getCapacity() % 1000 == 0 || Screen.func_231173_s_()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(KEY_MB, new Object[]{amount}).func_240699_a_(TextFormatting.GRAY));
                } else {
                    int ingots = amount / 144;
                    int mb = amount % 144;
                    if (mb == 0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent(KEY_INGOTS, new Object[]{ingots}).func_240699_a_(TextFormatting.GRAY));
                    } else {
                        tooltip.add((ITextComponent)new TranslationTextComponent(KEY_MIXED, new Object[]{ingots, mb}).func_240699_a_(TextFormatting.GRAY));
                    }
                    tooltip.add(FluidTooltipHandler.HOLD_SHIFT);
                }
            }
        } else {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }

    public static FluidTank getFluidTank(ItemStack stack) {
        FluidTank tank = new FluidTank(TankTileEntity.getCapacity(stack.func_77973_b()));
        if (stack.func_77942_o()) {
            assert (stack.func_77978_p() != null);
            tank.readFromNBT(stack.func_77978_p().func_74775_l("tank"));
        }
        return tank;
    }
}

