/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.inventory;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import slimeknights.mantle.inventory.MultiModuleContainer;
import slimeknights.tconstruct.library.utils.ValidZeroIntReference;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.SmelteryTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;
import slimeknights.tconstruct.tables.inventory.SideInventoryContainer;

public class SmelteryContainer
extends MultiModuleContainer<SmelteryTileEntity> {
    private final SideInventoryContainer<SmelteryTileEntity> sideInventory;

    public SmelteryContainer(int id, @Nullable PlayerInventory inv, @Nullable SmelteryTileEntity smeltery) {
        super((ContainerType)TinkerSmeltery.smelteryContainer.get(), id, inv, (TileEntity)smeltery);
        if (inv != null && smeltery != null) {
            MeltingModuleInventory inventory = smeltery.getMeltingInventory();
            this.sideInventory = new SideInventoryContainer<SmelteryTileEntity>((ContainerType)TinkerSmeltery.smelteryContainer.get(), id, inv, smeltery, 0, 0, SmelteryContainer.calcColumns(inventory.getSlots()));
            this.addSubContainer((Container)this.sideInventory, true);
            Consumer<IntReferenceHolder> referenceConsumer = arg_0 -> ((SmelteryContainer)this).func_216958_a(arg_0);
            ValidZeroIntReference.trackIntArray(referenceConsumer, smeltery.getFuelModule());
            inventory.trackInts(array -> ValidZeroIntReference.trackIntArray(referenceConsumer, array));
        } else {
            this.sideInventory = null;
        }
        this.addInventorySlots();
    }

    public SmelteryContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, (SmelteryTileEntity)SmelteryContainer.getTileEntityFromBuf((PacketBuffer)buf, SmelteryTileEntity.class));
    }

    public static int calcColumns(int slots) {
        return Math.min(4, (slots + 6) / 7);
    }

    public SideInventoryContainer<SmelteryTileEntity> getSideInventory() {
        return this.sideInventory;
    }
}

