/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.inventory;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.inventory.ItemHandlerSlot;
import slimeknights.tconstruct.library.utils.ValidZeroIntReference;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.MelterTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;

public class MelterContainer
extends BaseContainer<MelterTileEntity> {
    private final Slot[] inputs;
    private boolean hasFuelSlot = false;

    public MelterContainer(int id, @Nullable PlayerInventory inv, @Nullable MelterTileEntity melter) {
        super((ContainerType)TinkerSmeltery.melterContainer.get(), id, inv, (TileEntity)melter);
        if (melter != null) {
            TileEntity te;
            MeltingModuleInventory inventory = melter.getMeltingInventory();
            this.inputs = new Slot[inventory.getSlots()];
            for (int i = 0; i < this.inputs.length; ++i) {
                this.inputs[i] = this.func_75146_a((Slot)new ItemHandlerSlot((IItemHandler)inventory, i, 22, 16 + i * 18));
            }
            World world = melter.func_145831_w();
            BlockPos down = melter.func_174877_v().func_177977_b();
            if (world != null && world.func_180495_p(down).func_203425_a((Block)TinkerSmeltery.searedHeater.get()) && (te = world.func_175625_s(down)) != null) {
                this.hasFuelSlot = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(handler -> {
                    this.func_75146_a((Slot)new ItemHandlerSlot(handler, 0, 151, 32));
                    return true;
                }).isPresent();
            }
            this.addInventorySlots();
            Consumer<IntReferenceHolder> referenceConsumer = arg_0 -> ((MelterContainer)this).func_216958_a(arg_0);
            ValidZeroIntReference.trackIntArray(referenceConsumer, melter.getFuelModule());
            inventory.trackInts(array -> ValidZeroIntReference.trackIntArray(referenceConsumer, array));
        } else {
            this.inputs = new Slot[0];
        }
    }

    public MelterContainer(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, (MelterTileEntity)MelterContainer.getTileEntityFromBuf((PacketBuffer)buf, MelterTileEntity.class));
    }

    public Slot[] getInputs() {
        return this.inputs;
    }

    public boolean isHasFuelSlot() {
        return this.hasFuelSlot;
    }
}

