/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.EntityIngredient;
import slimeknights.mantle.recipe.ingredient.IngredientIntersection;
import slimeknights.mantle.recipe.ingredient.IngredientWithout;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.conditions.ConfigEnabledCondition;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.common.registration.MetalItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.tools.data.MaterialIds;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

public class SmelteryRecipeProvider
extends BaseRecipeProvider {
    public SmelteryRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public String func_200397_b() {
        return "Tinkers' Construct Smeltery Recipes";
    }

    @Override
    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.addBaseRecipes(consumer);
        this.addMeltingRecipes(consumer);
        this.addCastingRecipes(consumer);
        this.addAlloyRecipes(consumer);
        this.addEntityMeltingRecipes(consumer);
    }

    private void addBaseRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "smeltery/seared_block/";
        ShapelessRecipeBuilder.func_200488_a(TinkerSmeltery.grout, (int)2).func_200487_b((IItemProvider)Items.field_151119_aD).func_203221_a((ITag)ItemTags.field_203440_u).func_200487_b((IItemProvider)Blocks.field_150351_n).func_200483_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a((IItemProvider)Items.field_151119_aD)).func_200485_a(consumer, SmelteryRecipeProvider.prefix(TinkerSmeltery.grout, folder));
        ShapelessRecipeBuilder.func_200488_a(TinkerSmeltery.grout, (int)8).func_200487_b((IItemProvider)Blocks.field_150435_aG).func_203221_a((ITag)ItemTags.field_203440_u).func_203221_a((ITag)ItemTags.field_203440_u).func_203221_a((ITag)ItemTags.field_203440_u).func_203221_a((ITag)ItemTags.field_203440_u).func_200487_b((IItemProvider)Blocks.field_150351_n).func_200487_b((IItemProvider)Blocks.field_150351_n).func_200487_b((IItemProvider)Blocks.field_150351_n).func_200487_b((IItemProvider)Blocks.field_150351_n).func_200483_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a((IItemProvider)Blocks.field_150435_aG)).func_200485_a(consumer, SmelteryRecipeProvider.wrap(TinkerSmeltery.grout, folder, "_multiple"));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.grout}), TinkerSmeltery.searedBrick, (float)0.3f, (int)200).func_218628_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.grout)).func_218635_a(consumer, SmelteryRecipeProvider.prefix((IItemProvider)TinkerSmeltery.searedBricks, folder));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)TinkerSmeltery.searedBricks).func_200462_a(Character.valueOf('b'), TinkerSmeltery.searedBrick).func_200472_a("bb").func_200472_a("bb").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.wrap((IItemProvider)TinkerSmeltery.searedBricks, folder, "_from_brick"));
        ShapedRecipeBuilder.func_200468_a(TinkerSmeltery.searedLadder, (int)4).func_200462_a(Character.valueOf('b'), TinkerSmeltery.searedBrick).func_200469_a(Character.valueOf('B'), TinkerTags.Items.SEARED_BRICKS).func_200472_a("b b").func_200472_a("b b").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.prefix(TinkerSmeltery.searedLadder, folder));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerSmeltery.searedCobble.get()}), (IItemProvider)TinkerSmeltery.searedStone, (float)0.1f, (int)200).func_218628_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TinkerSmeltery.searedCobble.get()))).func_218635_a(consumer, SmelteryRecipeProvider.wrap((IItemProvider)TinkerSmeltery.searedStone, folder, "_smelting"));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerSmeltery.searedStone.get()}), (IItemProvider)TinkerSmeltery.searedPaver, (float)0.1f, (int)200).func_218628_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TinkerSmeltery.searedStone.get()))).func_218635_a(consumer, SmelteryRecipeProvider.wrap((IItemProvider)TinkerSmeltery.searedPaver, folder, "_smelting"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)TinkerSmeltery.searedBricks, (int)4).func_200462_a(Character.valueOf('b'), (IItemProvider)TinkerSmeltery.searedStone).func_200472_a("bb").func_200472_a("bb").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a((IItemProvider)TinkerSmeltery.searedStone)).func_200467_a(consumer, SmelteryRecipeProvider.wrap((IItemProvider)TinkerSmeltery.searedBricks, folder, "_crafting"));
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedBricks}), TinkerSmeltery.searedCrackedBricks, (float)0.1f, (int)200).func_218628_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a((IItemProvider)TinkerSmeltery.searedBricks)).func_218635_a(consumer, SmelteryRecipeProvider.wrap(TinkerSmeltery.searedCrackedBricks, folder, "_smelting"));
        ShapedRecipeBuilder.func_200470_a(TinkerSmeltery.searedFancyBricks).func_200462_a(Character.valueOf('s'), (IItemProvider)TinkerSmeltery.searedBricks.getSlab()).func_200472_a("s").func_200472_a("s").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a((IItemProvider)TinkerSmeltery.searedBricks.getSlab())).func_200467_a(consumer, SmelteryRecipeProvider.wrap(TinkerSmeltery.searedFancyBricks, folder, "_crafting"));
        this.addSearedStonecutter(consumer, (IItemProvider)TinkerSmeltery.searedBricks, folder);
        this.addSearedStonecutter(consumer, (IItemProvider)TinkerSmeltery.searedFancyBricks, folder);
        this.addSearedStonecutter(consumer, (IItemProvider)TinkerSmeltery.searedTriangleBricks, folder);
        ShapedRecipeBuilder.func_200470_a(TinkerSmeltery.searedGlass).func_200462_a(Character.valueOf('b'), TinkerSmeltery.searedBrick).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_COLORLESS).func_200472_a(" b ").func_200472_a("bGb").func_200472_a(" b ").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.prefix(TinkerSmeltery.searedGlass, folder));
        ShapedRecipeBuilder.func_200468_a(TinkerSmeltery.searedGlassPane, (int)16).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedGlass).func_200472_a("###").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedGlass)).func_200467_a(consumer, SmelteryRecipeProvider.prefix(TinkerSmeltery.searedGlassPane, folder));
        this.registerSlabStair(consumer, TinkerSmeltery.searedStone, folder, true);
        this.registerSlabStairWall(consumer, TinkerSmeltery.searedCobble, folder, true);
        this.registerSlabStair(consumer, TinkerSmeltery.searedPaver, folder, true);
        this.registerSlabStairWall(consumer, TinkerSmeltery.searedBricks, folder, true);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.TANK))).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200469_a(Character.valueOf('B'), (ITag)Tags.Items.GLASS).func_200472_a("###").func_200472_a("#B#").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/seared/tank"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.GAUGE))).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200469_a(Character.valueOf('B'), (ITag)Tags.Items.GLASS).func_200472_a("#B#").func_200472_a("BBB").func_200472_a("#B#").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/seared/gauge"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.WINDOW))).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200469_a(Character.valueOf('B'), (ITag)Tags.Items.GLASS).func_200472_a("#B#").func_200472_a("#B#").func_200472_a("#B#").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/seared/window"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)TinkerSmeltery.searedFaucet.get()), (int)2).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/faucet"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)TinkerSmeltery.searedChannel.get()), (int)3).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200472_a("# #").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/channel"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TinkerSmeltery.castingBasin.get())).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200472_a("# #").func_200472_a("# #").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/casting/basin"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TinkerSmeltery.castingTable.get())).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200472_a("###").func_200472_a("# #").func_200472_a("# #").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/casting/table"));
        ShapedRecipeBuilder.func_200470_a(TinkerSmeltery.searedDrain).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200469_a(Character.valueOf('C'), TinkerMaterials.copper.getIngotTag()).func_200472_a("# #").func_200472_a("C C").func_200472_a("# #").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/drain"));
        ShapedRecipeBuilder.func_200470_a(TinkerSmeltery.searedChute).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200469_a(Character.valueOf('C'), TinkerMaterials.copper.getIngotTag()).func_200472_a("#C#").func_200472_a("   ").func_200472_a("#C#").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/chute"));
        ShapedRecipeBuilder.func_200470_a(TinkerSmeltery.searedDuct).func_200462_a(Character.valueOf('#'), TinkerSmeltery.searedBrick).func_200469_a(Character.valueOf('C'), TinkerMaterials.cobalt.getIngotTag()).func_200472_a("# #").func_200472_a("C C").func_200472_a("# #").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200409_a(TinkerMaterials.cobalt.getIngotTag())).func_200467_a(consumer, SmelteryRecipeProvider.location("smeltery/duct"));
        ShapedRecipeBuilder.func_200470_a(TinkerSmeltery.searedMelter).func_200462_a(Character.valueOf('G'), (IItemProvider)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.GAUGE)).func_200462_a(Character.valueOf('B'), TinkerSmeltery.searedBrick).func_200472_a("BGB").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.prefix(TinkerSmeltery.searedMelter, "smeltery/"));
        ShapedRecipeBuilder.func_200470_a(TinkerSmeltery.searedHeater).func_200462_a(Character.valueOf('B'), TinkerSmeltery.searedBrick).func_200472_a("BBB").func_200472_a("B B").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.searedBrick)).func_200467_a(consumer, SmelteryRecipeProvider.prefix(TinkerSmeltery.searedHeater, "smeltery/"));
        ShapedRecipeBuilder.func_200468_a(TinkerSmeltery.copperCan, (int)3).func_200469_a(Character.valueOf('c'), TinkerMaterials.copper.getIngotTag()).func_200472_a("c c").func_200472_a(" c ").func_200465_a("has_item", (ICriterionInstance)SmelteryRecipeProvider.func_200409_a(TinkerMaterials.copper.getIngotTag())).func_200467_a(consumer, SmelteryRecipeProvider.prefix(TinkerSmeltery.copperCan, "smeltery/"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)TinkerSmeltery.blankCast.getSand(), (int)4).func_203221_a((ITag)Tags.Items.SAND_COLORLESS).func_200483_a("has_casting", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.castingTable)).func_200485_a(consumer, SmelteryRecipeProvider.location("smeltery/sand_cast"));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)TinkerSmeltery.blankCast.getRedSand(), (int)4).func_203221_a((ITag)Tags.Items.SAND_RED).func_200483_a("has_casting", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a(TinkerSmeltery.castingTable)).func_200485_a(consumer, SmelteryRecipeProvider.location("smeltery/red_sand_cast"));
        MoldingRecipeBuilder.moldingTable((IItemProvider)TinkerSmeltery.blankCast.getSand()).setMaterial((ITag<Item>)TinkerTags.Items.SAND_CASTS).build(consumer, SmelteryRecipeProvider.location("smeltery/sand_cast_pickup"));
        MoldingRecipeBuilder.moldingTable((IItemProvider)TinkerSmeltery.blankCast.getRedSand()).setMaterial((ITag<Item>)TinkerTags.Items.RED_SAND_CASTS).build(consumer, SmelteryRecipeProvider.location("smeltery/red_sand_cast_pickup"));
    }

    private void addCastingRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "smeltery/casting/";
        ContainerFillingRecipeBuilder.tableRecipe((IItemProvider)Items.field_151133_ar, 1000).build(consumer, SmelteryRecipeProvider.location(folder + "filling/bucket"));
        ContainerFillingRecipeBuilder.tableRecipe(TinkerSmeltery.copperCan, 144).build(consumer, SmelteryRecipeProvider.location(folder + "filling/copper_can"));
        String slimeFolder = folder + "slime/";
        this.addSlimeCastingRecipe(consumer, (ITag<Fluid>)TinkerFluids.blood.getLocalTag(), this.getTemperature((Supplier<? extends Fluid>)TinkerFluids.blood), SlimeType.BLOOD, slimeFolder);
        this.addSlimeCastingRecipe(consumer, (ITag<Fluid>)TinkerFluids.earthSlime.getForgeTag(), this.getTemperature((Supplier<? extends Fluid>)TinkerFluids.earthSlime), SlimeType.EARTH, slimeFolder);
        this.addSlimeCastingRecipe(consumer, (ITag<Fluid>)TinkerFluids.skySlime.getLocalTag(), this.getTemperature((Supplier<? extends Fluid>)TinkerFluids.skySlime), SlimeType.SKY, slimeFolder);
        this.addSlimeCastingRecipe(consumer, (ITag<Fluid>)TinkerFluids.enderSlime.getLocalTag(), this.getTemperature((Supplier<? extends Fluid>)TinkerFluids.enderSlime), SlimeType.ENDER, slimeFolder);
        this.addBlockCastingRecipe(consumer, (ITag<Fluid>)TinkerFluids.magmaCream.getForgeTag(), this.getTemperature((Supplier<? extends Fluid>)TinkerFluids.magmaCream), 1000, (IItemProvider)Blocks.field_196814_hQ, slimeFolder + "magma_cream/block");
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)Items.field_151064_bs).setFluidAndTime(this.getTemperature((Supplier<? extends Fluid>)TinkerFluids.magmaCream), (ITag<Fluid>)TinkerFluids.magmaCream.getForgeTag(), 250).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "magma_cream/ball"));
        this.addBlockCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenGlass, 1000, (IItemProvider)TinkerCommons.clearGlass, folder + "glass/block");
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.clearGlassPane).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenGlass.get(), 250)).build(consumer, SmelteryRecipeProvider.location(folder + "glass/pane"));
        this.addBlockCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.liquidSoul, 1000, (IItemProvider)TinkerCommons.soulGlass, folder + "soul/glass");
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.soulGlassPane).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.liquidSoul.get(), 250)).build(consumer, SmelteryRecipeProvider.location(folder + "soul/pane"));
        this.addBlockCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenClay, 1000, (IItemProvider)Blocks.field_150405_ch, folder + "clay/block");
        this.addIngotCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenClay, 250, (IItemProvider)Items.field_151118_aC, folder + "clay/brick");
        this.addGemCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenEmerald, (IItemProvider)Items.field_151166_bC, folder + "emerald/gem");
        this.addBlockCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenEmerald, 2250, (IItemProvider)Items.field_221739_dF, folder + "emerald/block");
        this.addGemCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenEnder, (IItemProvider)Items.field_151079_bi, folder + "ender_pearl");
        this.addBlockCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenObsidian, 1000, (IItemProvider)Items.field_221655_bP, folder + "obsidian");
        String metalFolder = folder + "metal/";
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenIron, (IItemProvider)Items.field_221698_bk, (IItemProvider)Items.field_151042_j, (IItemProvider)Items.field_191525_da, metalFolder, "iron");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenGold, (IItemProvider)Items.field_221696_bj, (IItemProvider)Items.field_151043_k, (IItemProvider)Items.field_151074_bl, metalFolder, "gold");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenNetherite, (IItemProvider)Blocks.field_235397_ng_, (IItemProvider)Items.field_234759_km_, (IItemProvider)TinkerMaterials.netheriteNugget, metalFolder, "netherite");
        this.addIngotCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenDebris, (IItemProvider)Items.field_234760_kn_, metalFolder + "netherite/scrap");
        this.addNuggetCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenDebris, (IItemProvider)TinkerMaterials.debrisNugget, metalFolder + "netherite/debris_nugget");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenCopper, TinkerMaterials.copper, metalFolder, "copper");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenCobalt, TinkerMaterials.cobalt, metalFolder, "cobalt");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenSlimesteel, TinkerMaterials.slimesteel, metalFolder, "slimesteel");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenTinkersBronze, TinkerMaterials.tinkersBronze, metalFolder, "tinkers_bronze");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenRoseGold, TinkerMaterials.roseGold, metalFolder, "rose_gold");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenPigIron, TinkerMaterials.pigIron, metalFolder, "pig_iron");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenManyullyn, TinkerMaterials.manyullyn, metalFolder, "manyullyn");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenHepatizon, TinkerMaterials.hepatizon, metalFolder, "hepatizon");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenQueensSlime, TinkerMaterials.queensSlime, metalFolder, "queens_slime");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenSoulsteel, TinkerMaterials.soulsteel, metalFolder, "soulsteel");
        this.addMetalCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenKnightslime, TinkerMaterials.knightslime, metalFolder, "knightslime");
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            this.addMetalOptionalCasting(consumer, (Fluid)compat.getFluid(), compat.getName(), metalFolder);
        }
        String searedFolder = folder + "seared/";
        this.addBlockCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.searedStone, 576, (IItemProvider)TinkerSmeltery.searedStone, searedFolder + "stone/block_from_seared");
        this.addIngotCastingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.searedStone, (IItemProvider)TinkerSmeltery.searedBrick, searedFolder + "brick");
        ItemCastingRecipeBuilder.basinRecipe(TinkerSmeltery.searedGlass).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.searedStone.get(), 576)).setCast((ITag<Item>)Tags.Items.GLASS_COLORLESS, true).build(consumer, SmelteryRecipeProvider.location(searedFolder + "glass"));
        ItemCastingRecipeBuilder.tableRecipe(TinkerSmeltery.searedGlassPane).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.searedStone.get(), 144)).setCast((ITag<Item>)Tags.Items.GLASS_PANES_COLORLESS, true).build(consumer, SmelteryRecipeProvider.location(searedFolder + "glass_pane"));
        ItemCastingRecipeBuilder.basinRecipe(TinkerSmeltery.smelteryController).setCast((IItemProvider)TinkerSmeltery.searedHeater, true).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenCopper.get(), 576)).build(consumer, SmelteryRecipeProvider.prefix(TinkerSmeltery.smelteryController, searedFolder));
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedCobble, (Ingredient)new BaseRecipeProvider.CompoundIngredient(Ingredient.func_199805_a((ITag)Tags.Items.COBBLESTONE), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})), searedFolder + "cobble/block");
        SmelteryRecipeProvider.addSearedSlabCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedCobble.getSlab(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196646_bz}), searedFolder + "cobble/slab");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedCobble.getStairs(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196659_cl}), searedFolder + "cobble/stairs");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedCobble.getWall(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150463_bK}), searedFolder + "cobble/wall");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedStone, Ingredient.func_199805_a((ITag)Tags.Items.STONE), searedFolder + "stone/block_from_clay");
        SmelteryRecipeProvider.addSearedSlabCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedStone.getSlab(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150333_U}), searedFolder + "stone/slab");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedStone.getStairs(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_222438_lb}), searedFolder + "stone/stairs");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedBricks, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196696_di}), searedFolder + "bricks/block");
        SmelteryRecipeProvider.addSearedSlabCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedBricks.getSlab(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196573_bB}), searedFolder + "bricks/slab");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedBricks.getStairs(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150390_bg}), searedFolder + "bricks/stairs");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedBricks.getWall(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_222413_lB}), searedFolder + "bricks/wall");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, TinkerSmeltery.searedCrackedBricks, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196700_dk}), searedFolder + "cracked");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, TinkerSmeltery.searedFancyBricks, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196702_dl}), searedFolder + "chiseled");
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, (IItemProvider)TinkerSmeltery.searedPaver, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196579_bG}), searedFolder + "paver");
        ItemCastingRecipeBuilder.basinRecipe((IItemProvider)TinkerCommons.lavawood).setFluidAndTime(new FluidStack((Fluid)Fluids.field_204547_b, 100)).setCast((ITag<Item>)ItemTags.field_199905_b, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)TinkerCommons.lavawood, folder));
        ItemCastingRecipeBuilder.basinRecipe((IItemProvider)TinkerCommons.blazewood).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenBlaze.get(), 100)).setCast((Ingredient)new IngredientIntersection(new Ingredient[]{Ingredient.func_199805_a((ITag)ItemTags.field_199905_b), Ingredient.func_199805_a((ITag)ItemTags.field_232905_P_)}), true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)TinkerCommons.blazewood, folder));
        ItemCastingRecipeBuilder.basinRecipe((IItemProvider)TinkerCommons.mudBricks).setFluidAndTime(new FluidStack((Fluid)Fluids.field_204546_a, 100)).setCast((IItemProvider)Items.field_221582_j, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)TinkerCommons.mudBricks, folder));
        this.addCastingWithCastRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.moltenBlaze, 100, TinkerSmeltery.rodCast, (IItemProvider)Items.field_151072_bj, folder + "blaze_rod");
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)TinkerSmeltery.blankCast).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenGold.get(), 144)).setSwitchSlots().build(consumer, SmelteryRecipeProvider.location(folder + "casts/blank"));
        this.addCastCastingRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.INGOTS, TinkerSmeltery.ingotCast, folder);
        this.addCastCastingRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.NUGGETS, TinkerSmeltery.nuggetCast, folder);
        this.addCastCastingRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.GEMS, TinkerSmeltery.gemCast, folder);
        this.addCastCastingRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.RODS, TinkerSmeltery.rodCast, folder);
        this.addCastCastingRecipe(SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("plates")), SmelteryRecipeProvider.getTag("forge", "plates"), TinkerSmeltery.plateCast, folder);
        this.addCastCastingRecipe(SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("gears")), SmelteryRecipeProvider.getTag("forge", "gears"), TinkerSmeltery.gearCast, folder);
        this.addCastCastingRecipe(SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("coins")), SmelteryRecipeProvider.getTag("forge", "coins"), TinkerSmeltery.coinCast, folder);
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)Items.field_151153_ao).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenGold.get(), 1152)).setCast((IItemProvider)Items.field_151034_e, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)Items.field_151153_ao, folder));
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)Items.field_151060_bw).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenGold.get(), 128)).setCast((IItemProvider)Items.field_151127_ba, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)Items.field_151060_bw, folder));
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)Items.field_151150_bK).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenGold.get(), 128)).setCast((IItemProvider)Items.field_151172_bF, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)Items.field_151150_bK, folder));
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)Items.field_151113_aN).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenGold.get(), 576)).setCast((IItemProvider)Items.field_151137_ax, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)Items.field_151113_aN, folder));
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)Items.field_222111_pQ).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 128)).setCast((IItemProvider)Blocks.field_150478_aa, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)Items.field_222111_pQ, folder));
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)Items.field_234790_rk_).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 128)).setCast((IItemProvider)Blocks.field_235339_cQ_, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)Items.field_234790_rk_, folder));
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)Items.field_151111_aL).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 576)).setCast((IItemProvider)Items.field_151137_ax, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)Items.field_151111_aL, folder));
        ItemCastingRecipeBuilder.basinRecipe((IItemProvider)Blocks.field_150477_bB).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenObsidian.get(), 8000)).setCast((IItemProvider)Items.field_151061_bv, true).build(consumer, SmelteryRecipeProvider.prefix((IItemProvider)Items.field_221735_dD, folder));
        String compositeFolder = "tools/parts/composite/";
        CompositeCastingRecipeBuilder.table(MaterialIds.stone, MaterialIds.searedStone).setFluid(new FluidStack((Fluid)TinkerFluids.moltenClay.get(), 125)).build(consumer, SmelteryRecipeProvider.location(compositeFolder + "seared_stone"));
        CompositeCastingRecipeBuilder.table(MaterialIds.wood, MaterialIds.slimewood).setFluid((ITag<Fluid>)TinkerFluids.earthSlime.getForgeTag(), 250).setTemperature(this.getTemperature((Supplier<? extends Fluid>)TinkerFluids.earthSlime)).build(consumer, SmelteryRecipeProvider.location(compositeFolder + "slimewood"));
        CompositeCastingRecipeBuilder.table(MaterialIds.wood, MaterialIds.nahuatl).setFluid(new FluidStack((Fluid)TinkerFluids.moltenObsidian.get(), 1000)).build(consumer, SmelteryRecipeProvider.location(compositeFolder + "nahuatl"));
    }

    private void addMeltingRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "smeltery/melting/";
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221770_cu}), (Fluid)Fluids.field_204546_a, 1000, 1.0f).build(consumer, SmelteryRecipeProvider.location(folder + "water/ice"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221898_fg}), (Fluid)Fluids.field_204546_a, 9000, 3.0f).build(consumer, SmelteryRecipeProvider.location(folder + "water/packed_ice"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222047_ii}), (Fluid)Fluids.field_204546_a, 81000, 9.0f).build(consumer, SmelteryRecipeProvider.location(folder + "water/blue_ice"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151126_ay}), (Fluid)Fluids.field_204546_a, 125, 0.5f).build(consumer, SmelteryRecipeProvider.location(folder + "water/snowball"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221772_cv}), (Fluid)Fluids.field_204546_a, 500, 0.75f).build(consumer, SmelteryRecipeProvider.location(folder + "water/snow_block"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221768_ct}), (Fluid)Fluids.field_204546_a, 125, 0.5f).build(consumer, SmelteryRecipeProvider.location(folder + "water/snow_layer"));
        String metalFolder = folder + "metal/";
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenIron.get(), "iron", true, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenGold.get(), "gold", true, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenCopper.get(), "copper", true, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenCobalt.get(), "cobalt", true, metalFolder, false);
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a((ITag)Tags.Items.ORES_NETHERITE_SCRAP), (Fluid)TinkerFluids.moltenDebris.get(), 144, 2.0f).setOre().build(consumer, SmelteryRecipeProvider.location(metalFolder + "molten_debris/ore"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a(TinkerTags.Items.INGOTS_NETHERITE_SCRAP), (Fluid)TinkerFluids.moltenDebris.get(), 144, 1.0f).build(consumer, SmelteryRecipeProvider.location(metalFolder + "molten_debris/scrap"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a(TinkerTags.Items.NUGGETS_NETHERITE_SCRAP), (Fluid)TinkerFluids.moltenDebris.get(), 16, 0.33333334f).build(consumer, SmelteryRecipeProvider.location(metalFolder + "molten_debris/debris_nugget"));
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenSlimesteel.get(), "slimesteel", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenTinkersBronze.get(), "silicon_bronze", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenRoseGold.get(), "rose_gold", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenPigIron.get(), "pig_iron", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenManyullyn.get(), "manyullyn", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenHepatizon.get(), "hepatizon", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenQueensSlime.get(), "queens_slime", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenSoulsteel.get(), "soulsteel", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenNetherite.get(), "netherite", false, metalFolder, false);
        this.addMetalMelting(consumer, (Fluid)TinkerFluids.moltenKnightslime.get(), "knightslime", false, metalFolder, false);
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            this.addMetalMelting(consumer, (Fluid)compat.getFluid(), compat.getName(), compat.isOre(), metalFolder, true);
        }
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), (Fluid)TinkerFluids.blood.get(), 50, 1.0f).build(consumer, SmelteryRecipeProvider.location("blood_from_flesh"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a((ITag)Tags.Items.SAND), (Fluid)TinkerFluids.moltenGlass.get(), 1000, 1.5f).build(consumer, SmelteryRecipeProvider.location(folder + "glass/sand"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a((ITag)Tags.Items.GLASS), (Fluid)TinkerFluids.moltenGlass.get(), 1000, 1.0f).build(consumer, SmelteryRecipeProvider.location(folder + "glass/block"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a((ITag)Tags.Items.GLASS_PANES), (Fluid)TinkerFluids.moltenGlass.get(), 250, 0.5f).build(consumer, SmelteryRecipeProvider.location(folder + "glass/pane"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151069_bo}), (Fluid)TinkerFluids.moltenGlass.get(), 1000, 1.25f).build(consumer, SmelteryRecipeProvider.location(folder + "glass/bottle"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.blankCast.getSand(), TinkerSmeltery.blankCast.getRedSand()}), (Fluid)TinkerFluids.moltenGlass.get(), 250, 0.75f).build(consumer, SmelteryRecipeProvider.location(folder + "glass/sand_cast"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150425_aM, Blocks.field_235336_cN_}), (Fluid)TinkerFluids.liquidSoul.get(), 1000, 1.5f).build(consumer, SmelteryRecipeProvider.location(folder + "soul/sand"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerCommons.soulGlass}), (Fluid)TinkerFluids.liquidSoul.get(), 1000, 1.0f).build(consumer, SmelteryRecipeProvider.location(folder + "soul/glass"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerCommons.soulGlassPane}), (Fluid)TinkerFluids.liquidSoul.get(), 250, 0.5f).build(consumer, SmelteryRecipeProvider.location(folder + "soul/pane"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150435_aG}), (Fluid)TinkerFluids.moltenClay.get(), 1000, 1.0f).build(consumer, SmelteryRecipeProvider.location(folder + "clay/block"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151119_aD}), (Fluid)TinkerFluids.moltenClay.get(), 250, 0.5f).build(consumer, SmelteryRecipeProvider.location(folder + "clay/ball"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222087_nH}), (Fluid)TinkerFluids.moltenClay.get(), 750, 2.0f).build(consumer, SmelteryRecipeProvider.location(folder + "clay/pot"));
        Ingredient terracottaBlock = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150405_ch, Blocks.field_196584_bK, Blocks.field_222459_lw, Blocks.field_150389_bf, Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD, Blocks.field_192427_dB, Blocks.field_192428_dC, Blocks.field_192429_dD, Blocks.field_192430_dE, Blocks.field_192431_dF, Blocks.field_192432_dG, Blocks.field_192433_dH, Blocks.field_192434_dI, Blocks.field_196876_iu, Blocks.field_192436_dK, Blocks.field_192437_dL, Blocks.field_192438_dM, Blocks.field_192439_dN, Blocks.field_192440_dO, Blocks.field_192441_dP, Blocks.field_192442_dQ});
        MeltingRecipeBuilder.melting(terracottaBlock, (Fluid)TinkerFluids.moltenClay.get(), 1000, 2.0f).build(consumer, SmelteryRecipeProvider.location(folder + "clay/terracotta"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151118_aC}), (Fluid)TinkerFluids.moltenClay.get(), 250, 1.0f).build(consumer, SmelteryRecipeProvider.location(folder + "clay/brick"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196571_bA}), (Fluid)TinkerFluids.moltenClay.get(), 500, 1.5f).build(consumer, SmelteryRecipeProvider.location(folder + "clay/brick_slab"));
        MeltingRecipeBuilder.melting((Ingredient)new BaseRecipeProvider.CompoundIngredient(Ingredient.func_199805_a(TinkerTags.Items.SEARED_BLOCKS), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedLadder, TinkerSmeltery.searedCobble.getWall(), TinkerSmeltery.searedBricks.getWall(), TinkerSmeltery.searedCobble.getStairs(), TinkerSmeltery.searedStone.getStairs(), TinkerSmeltery.searedBricks.getStairs(), TinkerSmeltery.searedPaver.getStairs()})), (Fluid)TinkerFluids.searedStone.get(), 576, 2.0f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/block"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedCobble.getSlab(), TinkerSmeltery.searedStone.getSlab(), TinkerSmeltery.searedBricks.getSlab(), TinkerSmeltery.searedPaver.getSlab()}), (Fluid)TinkerFluids.searedStone.get(), 288, 1.5f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/slab"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedBrick}), (Fluid)TinkerFluids.searedStone.get(), 144, 1.0f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/brick"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedFaucet}), (Fluid)TinkerFluids.searedStone.get(), 216, 1.5f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/faucet"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedChannel}), (Fluid)TinkerFluids.searedStone.get(), 240, 1.5f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/channel"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.castingBasin, TinkerSmeltery.castingTable}), (Fluid)TinkerFluids.searedStone.get(), 1008, 2.5f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/casting"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.TANK)}), (Fluid)TinkerFluids.searedStone.get(), 1152, 3.0f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/tank"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.WINDOW)}), (Fluid)TinkerFluids.searedStone.get(), 864, 2.5f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/window"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.GAUGE)}), (Fluid)TinkerFluids.searedStone.get(), 576, 2.0f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/gauge"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedGlass}), (Fluid)TinkerFluids.searedStone.get(), 576, 2.0f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/glass"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedGlassPane}), (Fluid)TinkerFluids.searedStone.get(), 144, 1.0f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/pane"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedMelter}), (Fluid)TinkerFluids.searedStone.get(), 1296, 3.5f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/melter"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedHeater}), (Fluid)TinkerFluids.searedStone.get(), 1152, 3.0f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/heater"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.grout}), (Fluid)TinkerFluids.searedStone.get(), 288, 1.5f).build(consumer, SmelteryRecipeProvider.location(folder + "seared_stone/grout"));
        String slimeFolder = folder + "slime/";
        this.addSlimeMeltingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.earthSlime, SlimeType.EARTH, (ITag<Item>)TinkerTags.Items.EARTH_SLIMEBALL, slimeFolder);
        this.addSlimeMeltingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.skySlime, SlimeType.SKY, (ITag<Item>)TinkerTags.Items.SKY_SLIMEBALL, slimeFolder);
        this.addSlimeMeltingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.enderSlime, SlimeType.ENDER, (ITag<Item>)TinkerTags.Items.ENDER_SLIMEBALL, slimeFolder);
        this.addSlimeMeltingRecipe(consumer, (Supplier<? extends Fluid>)TinkerFluids.blood, SlimeType.BLOOD, (ITag<Item>)TinkerTags.Items.BLOOD_SLIMEBALL, slimeFolder);
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151064_bs}), (Fluid)TinkerFluids.magmaCream.get(), 250, 1.0f).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "magma_cream/ball"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196814_hQ}), (Fluid)TinkerFluids.magmaCream.get(), 1000, 3.0f).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "magma_cream/block"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a((ITag)Tags.Items.OBSIDIAN), (Fluid)TinkerFluids.moltenObsidian.get(), 1000, 2.0f).build(consumer, SmelteryRecipeProvider.location(folder + "obsidian"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150477_bB}), (Fluid)TinkerFluids.moltenObsidian.get(), 8000, 5.0f).build(consumer, SmelteryRecipeProvider.location(folder + "obsidian_from_chest"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a((ITag)Tags.Items.ORES_EMERALD), (Fluid)TinkerFluids.moltenEmerald.get(), 250, 1.5f).build(consumer, SmelteryRecipeProvider.location(folder + "emerald/ore"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a((ITag)Tags.Items.GEMS_EMERALD), (Fluid)TinkerFluids.moltenEmerald.get(), 250, 1.0f).build(consumer, SmelteryRecipeProvider.location(folder + "emerald/gem"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a((ITag)Tags.Items.STORAGE_BLOCKS_EMERALD), (Fluid)TinkerFluids.moltenEmerald.get(), 2250, 3.0f).build(consumer, SmelteryRecipeProvider.location(folder + "emerald/block"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221872_et, Items.field_221668_av, Blocks.field_222430_lS, Blocks.field_150331_J, Blocks.field_150320_F}), (Fluid)TinkerFluids.moltenIron.get(), 144).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/ingot_1"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221854_ek, Items.field_222013_iM, Blocks.field_222429_lR}), (Fluid)TinkerFluids.moltenIron.get(), 288).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/ingot_2"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151133_ar}), (Fluid)TinkerFluids.moltenIron.get(), 432).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/bucket"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151111_aL, Blocks.field_180400_cw}), (Fluid)TinkerFluids.moltenIron.get(), 576).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/ingot_4"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_222424_lM, Blocks.field_150438_bZ, Items.field_151143_au}), (Fluid)TinkerFluids.moltenIron.get(), 720).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/ingot_5"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150383_bp}), (Fluid)TinkerFluids.moltenIron.get(), 1008).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/cauldron"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_235341_dI_}), (Fluid)TinkerFluids.moltenIron.get(), 176).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/chain"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150467_bQ}), (Fluid)TinkerFluids.moltenIron.get(), 4464).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/anvil"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150411_aY, Blocks.field_150448_aq}), (Fluid)TinkerFluids.moltenIron.get(), 54).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/ingot_6_16"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221737_dE}), (Fluid)TinkerFluids.moltenIron.get(), 72).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/tripwire"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_222432_lU, Blocks.field_235366_md_}), (Fluid)TinkerFluids.moltenIron.get(), 128).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/lantern"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151028_Y}), (Fluid)TinkerFluids.moltenIron.get(), 720).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/helmet"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151030_Z}), (Fluid)TinkerFluids.moltenIron.get(), 1152).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/chestplate"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151165_aa}), (Fluid)TinkerFluids.moltenIron.get(), 1008).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/leggings"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151167_ab}), (Fluid)TinkerFluids.moltenIron.get(), 576).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/boots"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151036_c, Items.field_151035_b}), (Fluid)TinkerFluids.moltenIron.get(), 432).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/axes"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151040_l, Items.field_151019_K, Items.field_151097_aZ}), (Fluid)TinkerFluids.moltenIron.get(), 288).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/weapon"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151037_a, Items.field_151033_d, Items.field_185159_cQ}), (Fluid)TinkerFluids.moltenIron.get(), 144).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/small"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222114_py}), (Fluid)TinkerFluids.moltenIron.get(), 216).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/crossbow"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151138_bX}), (Fluid)TinkerFluids.moltenIron.get(), 1008).build(consumer, SmelteryRecipeProvider.location(metalFolder + "iron/horse_armor"));
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a(TinkerTags.Items.GOLD_CASTS), (Fluid)TinkerFluids.moltenGold.get(), 144).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/cast"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_196552_aC}), (Fluid)TinkerFluids.moltenGold.get(), 144).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/powered_rail"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150445_bS}), (Fluid)TinkerFluids.moltenGold.get(), 288).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/plate"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151113_aN}), (Fluid)TinkerFluids.moltenGold.get(), 576).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/clock"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao}), (Fluid)TinkerFluids.moltenGold.get(), 1152).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/apple"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151060_bw, Items.field_151150_bK}), (Fluid)TinkerFluids.moltenGold.get(), 128).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/produce"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151169_ag}), (Fluid)TinkerFluids.moltenGold.get(), 720).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/helmet"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151171_ah}), (Fluid)TinkerFluids.moltenGold.get(), 1152).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/chestplate"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151149_ai}), (Fluid)TinkerFluids.moltenGold.get(), 1008).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/leggings"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151151_aj}), (Fluid)TinkerFluids.moltenGold.get(), 576).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/boots"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151006_E, Items.field_151005_D}), (Fluid)TinkerFluids.moltenGold.get(), 432).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/axes"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151010_B, Items.field_151013_M}), (Fluid)TinkerFluids.moltenGold.get(), 288).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/weapon"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151011_C}), (Fluid)TinkerFluids.moltenGold.get(), 144).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/shovel"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151136_bY}), (Fluid)TinkerFluids.moltenGold.get(), 1008).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/horse_armor"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196100_at}), (Fluid)TinkerFluids.moltenGold.get(), 10368).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/enchanted_apple"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_235387_nA_}), (Fluid)TinkerFluids.moltenGold.get(), 96).setOre().build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/gilded_blackstone"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_222431_lT}), (Fluid)TinkerFluids.moltenGold.get(), 576).build(consumer, SmelteryRecipeProvider.location(metalFolder + "gold/bell"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_235405_no_}), (Fluid)TinkerFluids.moltenNetherite.get(), 144).build(consumer, SmelteryRecipeProvider.location(metalFolder + "netherite/lodestone"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_234763_ls_, Items.field_234764_lt_, Items.field_234765_lu_, Items.field_234766_lv_, Items.field_234758_kU_, Items.field_234757_kL_, Items.field_234756_kK_, Items.field_234755_kJ_, Items.field_234754_kI_}), (Fluid)TinkerFluids.moltenNetherite.get(), 144, 1.0f).setDamagable().build(consumer, SmelteryRecipeProvider.location(metalFolder + "netherite/tools_and_armor"));
        TinkerGadgets.slimeBoots.forEach((type, boots) -> {
            if (type != SlimeType.ICHOR) {
                MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{boots}), (Fluid)TinkerFluids.slime.get(type).get(), 2500).build(consumer, SmelteryRecipeProvider.location(slimeFolder + type.func_176610_l() + "/boots"));
            }
        });
        TinkerGadgets.slimeSling.forEach((type, sling) -> {
            if (type != SlimeType.ICHOR) {
                MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{sling}), (Fluid)TinkerFluids.slime.get(type).get(), 1750).setDamagable().build(consumer, SmelteryRecipeProvider.location(slimeFolder + type.func_176610_l() + "/sling"));
            }
        });
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerWorld.slimeSapling.get((Enum)SlimeGrassBlock.FoliageType.SKY)}), (Fluid)TinkerFluids.skySlime.get(), 250).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "sky/sapling"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerWorld.slimeSapling.get((Enum)SlimeGrassBlock.FoliageType.ENDER)}), (Fluid)TinkerFluids.enderSlime.get(), 250).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "ender/sapling"));
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TinkerWorld.slimeSapling.get((Enum)SlimeGrassBlock.FoliageType.BLOOD)}), (Fluid)TinkerFluids.blood.get(), 250).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "blood/sapling"));
        MeltingFuelBuilder.fuel(new FluidStack((Fluid)Fluids.field_204547_b, 50), 100).build(consumer, SmelteryRecipeProvider.location(folder + "fuel/lava"));
        MeltingFuelBuilder.fuel(new FluidStack((Fluid)TinkerFluids.moltenBlaze.get(), 50), 150).build(consumer, SmelteryRecipeProvider.location(folder + "fuel/blaze"));
    }

    private void addAlloyRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "smeltery/alloys/";
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenSlimesteel.get(), 288).addInput((Fluid)TinkerFluids.moltenIron.get(), 144).addInput((Fluid)TinkerFluids.skySlime.get(), 250).addInput((Fluid)TinkerFluids.searedStone.get(), 144).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenSlimesteel, folder));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenTinkersBronze.get(), 576).addInput((Fluid)TinkerFluids.moltenCopper.get(), 432).addInput((Fluid)TinkerFluids.moltenGlass.get(), 1000).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenTinkersBronze, folder));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenRoseGold.get(), 576).addInput((Fluid)TinkerFluids.moltenCopper.get(), 432).addInput((Fluid)TinkerFluids.moltenGold.get(), 144).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenRoseGold, folder));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenPigIron.get(), 288).addInput((Fluid)TinkerFluids.moltenIron.get(), 144).addInput((Fluid)TinkerFluids.blood.get(), 250).addInput((Fluid)TinkerFluids.moltenClay.get(), 250).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenPigIron, folder));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenObsidian.get(), 100).addInput((Fluid)Fluids.field_204546_a, 100).addInput((Fluid)Fluids.field_204547_b, 100).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenObsidian, folder));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenQueensSlime.get(), 288).addInput((Fluid)TinkerFluids.moltenCobalt.get(), 144).addInput((Fluid)TinkerFluids.moltenGold.get(), 144).addInput((ITag<Fluid>)TinkerFluids.magmaCream.getForgeTag(), 250).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenQueensSlime, folder));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenManyullyn.get(), 576).addInput((Fluid)TinkerFluids.moltenCobalt.get(), 432).addInput((Fluid)TinkerFluids.moltenDebris.get(), 144).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenManyullyn, folder));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenHepatizon.get(), 288).addInput((Fluid)TinkerFluids.moltenCopper.get(), 288).addInput((Fluid)TinkerFluids.moltenCobalt.get(), 144).addInput((Fluid)TinkerFluids.moltenObsidian.get(), 1000).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenHepatizon, folder));
        ConditionalRecipe.builder().addCondition((ICondition)ConfigEnabledCondition.CHEAPER_NETHERITE_ALLOY).addRecipe(AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenNetherite.get(), 16).addInput((Fluid)TinkerFluids.moltenDebris.get(), 64).addInput((Fluid)TinkerFluids.moltenGold.get(), 32)::build).addCondition((ICondition)TrueCondition.INSTANCE).addRecipe(AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenNetherite.get(), 16).addInput((Fluid)TinkerFluids.moltenDebris.get(), 64).addInput((Fluid)TinkerFluids.moltenGold.get(), 64)::build).build(consumer, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenNetherite, folder));
        Consumer<IFinishedRecipe> wrapped = SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("ingots/bronze"), SmelteryRecipeProvider.tagCondition("ingots/tin"));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenBronze.get(), 576).addInput((Fluid)TinkerFluids.moltenCopper.get(), 432).addInput((Fluid)TinkerFluids.moltenTin.get(), 144).build(wrapped, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenBronze, folder));
        wrapped = SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("ingots/brass"), SmelteryRecipeProvider.tagCondition("ingots/zinc"));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenBrass.get(), 576).addInput((Fluid)TinkerFluids.moltenCopper.get(), 432).addInput((Fluid)TinkerFluids.moltenZinc.get(), 144).build(wrapped, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenBrass, folder));
        wrapped = SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("ingots/electrum"), SmelteryRecipeProvider.tagCondition("ingots/silver"));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenElectrum.get(), 288).addInput((Fluid)TinkerFluids.moltenGold.get(), 144).addInput((Fluid)TinkerFluids.moltenSilver.get(), 144).build(wrapped, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenElectrum, folder));
        wrapped = SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("ingots/invar"), SmelteryRecipeProvider.tagCondition("ingots/nickel"));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenInvar.get(), 432).addInput((Fluid)TinkerFluids.moltenIron.get(), 288).addInput((Fluid)TinkerFluids.moltenNickel.get(), 144).build(wrapped, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenInvar, folder));
        wrapped = SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("ingots/constantan"), SmelteryRecipeProvider.tagCondition("ingots/nickel"));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenConstantan.get(), 288).addInput((Fluid)TinkerFluids.moltenCopper.get(), 144).addInput((Fluid)TinkerFluids.moltenNickel.get(), 144).build(wrapped, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenConstantan, folder));
        wrapped = SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("ingots/pewter"), SmelteryRecipeProvider.tagCondition("ingots/lead"));
        AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenPewter.get(), 288).addInput((Fluid)TinkerFluids.moltenIron.get(), 144).addInput((Fluid)TinkerFluids.moltenLead.get(), 144).build(wrapped, SmelteryRecipeProvider.prefixR(TinkerFluids.moltenPewter, folder));
    }

    private void addEntityMeltingRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "smeltery/entity_melting/";
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.field_200725_aD, EntityType.field_200763_C, EntityType.field_204724_o, EntityType.field_233592_ba_, EntityType.field_233590_aW_, EntityType.field_200726_aE}), new FluidStack((Fluid)TinkerFluids.blood.get(), 25), 2).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200725_aD, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)EntityType.field_200797_k), new FluidStack((Fluid)TinkerFluids.moltenGlass.get(), 50), 2).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200797_k, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityIngredient[])new EntityIngredient[]{EntityIngredient.of((ITag)EntityTypeTags.field_219764_a), EntityIngredient.of((EntityType)EntityType.field_200742_ah)}), new FluidStack((Fluid)ForgeMod.MILK.get(), 100)).build(consumer, SmelteryRecipeProvider.location(folder + "skeletons"));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)EntityType.field_200743_ai), new FluidStack((Fluid)TinkerFluids.earthSlime.get(), 25)).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200743_ai, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)((EntityType)TinkerWorld.skySlimeEntity.get())), new FluidStack((Fluid)TinkerFluids.skySlime.get(), 25)).build(consumer, SmelteryRecipeProvider.prefixR(TinkerWorld.skySlimeEntity, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)EntityType.field_200771_K), new FluidStack((Fluid)TinkerFluids.magmaCream.get(), 25)).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200771_K, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)EntityType.field_200757_aw), new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 16), 4).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200757_aw, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)EntityType.field_200745_ak), new FluidStack((Fluid)Fluids.field_204546_a, 100)).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200745_ak, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)EntityType.field_200792_f), new FluidStack((Fluid)TinkerFluids.moltenBlaze.get(), 20), 2).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200792_f, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.field_200761_A, EntityType.field_200800_n}), new FluidStack((Fluid)TinkerFluids.searedStone.get(), 16), 4).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200761_A, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)EntityType.field_200740_af), new FluidStack((Fluid)TinkerFluids.searedStone.get(), 16), 2).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200740_af, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.field_200756_av, EntityType.field_220351_aK}), new FluidStack((Fluid)TinkerFluids.moltenEmerald.get(), 25), 5).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200756_av, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.field_200806_t, EntityType.field_200764_D, EntityType.field_220350_aJ, EntityType.field_200758_ax}), new FluidStack((Fluid)TinkerFluids.moltenEmerald.get(), 25), 2).build(consumer, SmelteryRecipeProvider.location(folder + "illager"));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.field_200727_aF, EntityType.field_200759_ay}), new FluidStack((Fluid)TinkerFluids.moltenEmerald.get(), 10), 3).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200727_aF, folder));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType[])new EntityType[]{EntityType.field_200803_q, EntityType.field_200804_r, EntityType.field_200802_p}), new FluidStack((Fluid)TinkerFluids.moltenEnder.get(), 10), 2).build(consumer, SmelteryRecipeProvider.location(folder + "ender"));
        EntityMeltingRecipeBuilder.melting(EntityIngredient.of((EntityType)EntityType.field_200760_az), new FluidStack((Fluid)TinkerFluids.liquidSoul.get(), 50), 2).build(consumer, SmelteryRecipeProvider.prefixR(EntityType.field_200760_az, folder));
    }

    private void addSearedStonecutter(@Nonnull Consumer<IFinishedRecipe> consumer, IItemProvider output, String folder) {
        SingleItemRecipeBuilder.func_218644_a((Ingredient)new BaseRecipeProvider.CompoundIngredient(Arrays.asList(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedStone}), new IngredientWithout(Ingredient.func_199805_a(TinkerTags.Items.SEARED_BRICKS), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{output})))), (IItemProvider)output, (int)1).func_218643_a("has_stone", (ICriterionInstance)SmelteryRecipeProvider.func_200403_a((IItemProvider)TinkerSmeltery.searedStone)).func_218643_a("has_bricks", (ICriterionInstance)SmelteryRecipeProvider.func_200409_a(TinkerTags.Items.SEARED_BRICKS)).func_218647_a(consumer, SmelteryRecipeProvider.wrap(output, folder, "_stonecutting"));
    }

    private static void addMetalBase(Consumer<IFinishedRecipe> consumer, Fluid fluid, int amount, boolean isOre, String tagName, float factor, String recipePath, boolean isOptional) {
        Consumer<IFinishedRecipe> wrapped = isOptional ? SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition(tagName)) : consumer;
        MeltingRecipeBuilder builder = MeltingRecipeBuilder.melting(Ingredient.func_199805_a(SmelteryRecipeProvider.getTag("forge", tagName)), fluid, amount, factor);
        if (isOre) {
            builder.setOre();
        }
        builder.build(wrapped, SmelteryRecipeProvider.location(recipePath));
    }

    private void addMetalMelting(Consumer<IFinishedRecipe> consumer, Fluid fluid, String name, boolean hasOre, String folder, boolean isOptional) {
        String prefix = folder + "/" + name + "/";
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 1296, false, "storage_blocks/" + name, 3.0f, prefix + "block", isOptional);
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 144, false, "ingots/" + name, 1.0f, prefix + "ingot", isOptional);
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 16, false, "nuggets/" + name, 0.33333334f, prefix + "nugget", isOptional);
        if (hasOre) {
            SmelteryRecipeProvider.addMetalBase(consumer, fluid, 144, true, "ores/" + name, 1.5f, prefix + "ore", isOptional);
        }
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 144, false, "dusts/" + name, 0.75f, prefix + "dust", true);
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 144, false, "plates/" + name, 1.0f, prefix + "plates", true);
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 576, false, "gears/" + name, 2.0f, prefix + "gear", true);
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 48, false, "coins/" + name, 0.6666667f, prefix + "coin", true);
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 72, false, "rods/" + name, 0.2f, prefix + "rod", true);
        SmelteryRecipeProvider.addMetalBase(consumer, fluid, 144, false, "sheetmetals/" + name, 1.0f, prefix + "sheetmetal", true);
    }

    private int getTemperature(Supplier<? extends Fluid> supplier) {
        return supplier.get().getAttributes().getTemperature() - 300;
    }

    private void addBlockCastingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluid, int amount, IItemProvider block, String location) {
        ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(new FluidStack(fluid.get(), amount)).build(consumer, SmelteryRecipeProvider.location(location));
    }

    private void addBlockCastingRecipe(Consumer<IFinishedRecipe> consumer, ITag<Fluid> fluid, int temperature, int amount, IItemProvider block, String location) {
        ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(temperature, fluid, amount).build(consumer, SmelteryRecipeProvider.location(location));
    }

    private static void addSearedCastingRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider block, Ingredient cast, String location) {
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, block, cast, 500, location);
    }

    private static void addSearedSlabCastingRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider block, Ingredient cast, String location) {
        SmelteryRecipeProvider.addSearedCastingRecipe(consumer, block, cast, 250, location);
    }

    private static void addSearedCastingRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider block, Ingredient cast, int amount, String location) {
        ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenClay.get(), amount)).setCast(cast, true).build(consumer, SmelteryRecipeProvider.location(location));
    }

    private void addCastingWithCastRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluid, int amount, CastItemObject cast, IItemProvider output, String location) {
        FluidStack fluidStack = new FluidStack(fluid.get(), amount);
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluidStack).setCast((ITag<Item>)cast.getMultiUseTag(), false).build(consumer, SmelteryRecipeProvider.location(location + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluidStack).setCast((ITag<Item>)cast.getSingleUseTag(), true).build(consumer, SmelteryRecipeProvider.location(location + "_sand_cast"));
    }

    private void addIngotCastingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluid, int amount, IItemProvider ingot, String location) {
        this.addCastingWithCastRecipe(consumer, fluid, amount, TinkerSmeltery.ingotCast, ingot, location);
    }

    private void addIngotCastingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluid, IItemProvider ingot, String location) {
        this.addIngotCastingRecipe(consumer, fluid, 144, ingot, location);
    }

    private void addGemCastingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluid, IItemProvider gem, String location) {
        this.addCastingWithCastRecipe(consumer, fluid, 250, TinkerSmeltery.gemCast, gem, location);
    }

    private void addNuggetCastingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluid, IItemProvider nugget, String location) {
        this.addCastingWithCastRecipe(consumer, fluid, 16, TinkerSmeltery.nuggetCast, nugget, location);
    }

    private void addSlimeMeltingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluidSupplier, SlimeType type, ITag<Item> tag, String folder) {
        String slimeFolder = folder + type.func_176610_l() + "/";
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a(tag), fluidSupplier.get(), 250, 1.0f).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "ball"));
        IItemProvider item = (IItemProvider)TinkerWorld.congealedSlime.get((Enum)type);
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), fluidSupplier.get(), 1000, 2.0f).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "congealed"));
        item = (IItemProvider)TinkerWorld.slime.get((Enum)type);
        MeltingRecipeBuilder.melting(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), fluidSupplier.get(), 2250, 3.0f).build(consumer, SmelteryRecipeProvider.location(slimeFolder + "block"));
    }

    private void addSlimeCastingRecipe(Consumer<IFinishedRecipe> consumer, ITag<Fluid> fluid, int temperature, SlimeType slimeType, String folder) {
        String colorFolder = folder + slimeType.func_176610_l() + "/";
        this.addBlockCastingRecipe(consumer, fluid, temperature, 1000, (IItemProvider)TinkerWorld.congealedSlime.get((Enum)slimeType), colorFolder + "congealed");
        ItemCastingRecipeBuilder.basinRecipe((IItemProvider)TinkerWorld.slime.get((Enum)slimeType)).setFluidAndTime(temperature, fluid, 1250).setCast((IItemProvider)TinkerWorld.congealedSlime.get((Enum)slimeType), true).build(consumer, SmelteryRecipeProvider.location(colorFolder + "block"));
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)TinkerCommons.slimeball.get((Enum)slimeType)).setFluidAndTime(temperature, fluid, 250).build(consumer, SmelteryRecipeProvider.location(colorFolder + "slimeball"));
    }

    private void addMetalCastingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluid, @Nullable IItemProvider block, @Nullable IItemProvider ingot, @Nullable IItemProvider nugget, String folder, String metal) {
        String metalFolder = folder + metal + "/";
        if (block != null) {
            this.addBlockCastingRecipe(consumer, fluid, 1296, block, metalFolder + "block");
        }
        if (ingot != null) {
            this.addIngotCastingRecipe(consumer, fluid, ingot, metalFolder + "ingot");
        }
        if (nugget != null) {
            this.addNuggetCastingRecipe(consumer, fluid, nugget, metalFolder + "nugget");
        }
        this.addOptionalCastingWithCast(consumer, fluid.get(), 144, TinkerSmeltery.plateCast, "plates", "plate", metal, folder);
        this.addOptionalCastingWithCast(consumer, fluid.get(), 576, TinkerSmeltery.gearCast, "gears", "gear", metal, folder);
        this.addOptionalCastingWithCast(consumer, fluid.get(), 48, TinkerSmeltery.coinCast, "coins", "coin", metal, folder);
        this.addOptionalCastingWithCast(consumer, fluid.get(), 72, TinkerSmeltery.rodCast, "rods", "rod", metal, folder);
    }

    private void addMetalCastingRecipe(Consumer<IFinishedRecipe> consumer, Supplier<? extends Fluid> fluid, MetalItemObject metal, String folder, String name) {
        this.addMetalCastingRecipe(consumer, fluid, (IItemProvider)metal.get(), (IItemProvider)metal.getIngot(), (IItemProvider)metal.getNugget(), folder, name);
    }

    private void addOptionalCastingWithCast(Consumer<IFinishedRecipe> consumer, Fluid fluid, int amount, CastItemObject cast, String tagPrefix, String recipeName, String name, String folder) {
        String tagName = tagPrefix + "/" + name;
        ITag.INamedTag<Item> tag = SmelteryRecipeProvider.getTag("forge", tagName);
        Consumer<IFinishedRecipe> wrapped = SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition(tagName));
        ItemCastingRecipeBuilder.tableRecipe(tag).setFluidAndTime(new FluidStack(fluid, amount)).setCast((ITag<Item>)cast.getMultiUseTag(), false).build(wrapped, SmelteryRecipeProvider.location(folder + name + "/" + recipeName + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe(tag).setFluidAndTime(new FluidStack(fluid, amount)).setCast((ITag<Item>)cast.getSingleUseTag(), true).build(wrapped, SmelteryRecipeProvider.location(folder + name + "/" + recipeName + "_sand_cast"));
    }

    private void addMetalOptionalCasting(Consumer<IFinishedRecipe> consumer, Fluid fluid, String name, String folder) {
        this.addOptionalCastingWithCast(consumer, fluid, 16, TinkerSmeltery.nuggetCast, "nuggets", "nugget", name, folder);
        this.addOptionalCastingWithCast(consumer, fluid, 144, TinkerSmeltery.ingotCast, "ingots", "ingot", name, folder);
        this.addOptionalCastingWithCast(consumer, fluid, 144, TinkerSmeltery.plateCast, "plates", "plate", name, folder);
        this.addOptionalCastingWithCast(consumer, fluid, 576, TinkerSmeltery.gearCast, "gears", "gear", name, folder);
        this.addOptionalCastingWithCast(consumer, fluid, 48, TinkerSmeltery.coinCast, "coins", "coin", name, folder);
        this.addOptionalCastingWithCast(consumer, fluid, 72, TinkerSmeltery.rodCast, "rods", "rod", name, folder);
        ITag.INamedTag<Item> block = SmelteryRecipeProvider.getTag("forge", "storage_blocks/" + name);
        Consumer<IFinishedRecipe> wrapped = SmelteryRecipeProvider.withCondition(consumer, SmelteryRecipeProvider.tagCondition("storage_blocks/" + name));
        ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(new FluidStack(fluid, 1296)).build(wrapped, SmelteryRecipeProvider.location(folder + name + "/block"));
    }

    private void addCastCastingRecipe(Consumer<IFinishedRecipe> consumer, ITag.INamedTag<Item> input, CastItemObject cast, String folder) {
        String path = input.func_230234_a_().func_110623_a();
        ItemCastingRecipeBuilder.tableRecipe((IItemProvider)cast).setFluidAndTime(new FluidStack((Fluid)TinkerFluids.moltenGold.get(), 144)).setCast((ITag<Item>)input, true).setSwitchSlots().build(consumer, SmelteryRecipeProvider.location(folder + "casts/" + path));
        MoldingRecipeBuilder.moldingTable((IItemProvider)cast.getSand()).setMaterial((IItemProvider)TinkerSmeltery.blankCast.getSand()).setPattern((ITag<Item>)input, false).build(consumer, SmelteryRecipeProvider.location(folder + "sand_casts/" + path));
        MoldingRecipeBuilder.moldingTable((IItemProvider)cast.getRedSand()).setMaterial((IItemProvider)TinkerSmeltery.blankCast.getRedSand()).setPattern((ITag<Item>)input, false).build(consumer, SmelteryRecipeProvider.location(folder + "red_sand_casts/" + path));
    }
}

