/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import slimeknights.tconstruct.smeltery.block.ControllerBlock;
import slimeknights.tconstruct.smeltery.client.render.SmelteryTankRenderer;
import slimeknights.tconstruct.smeltery.tileentity.SmelteryTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.MultiblockSmeltery;

public class SmelteryTileEntityRenderer
extends TileEntityRenderer<SmelteryTileEntity> {
    private static final float ITEM_SCALE = 0.9375f;

    public SmelteryTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(SmelteryTileEntity smeltery, float partialTicks, MatrixStack matrices, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = smeltery.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = smeltery.func_195044_w();
        if (!((Boolean)state.func_177229_b((Property)ControllerBlock.IN_STRUCTURE)).booleanValue()) {
            return;
        }
        MultiblockSmeltery.StructureData structure = smeltery.getStructure();
        if (structure == null) {
            return;
        }
        BlockPos pos = smeltery.func_174877_v();
        BlockPos minPos = structure.getMinInside();
        BlockPos maxPos = structure.getMaxInside();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)(minPos.func_177958_n() - pos.func_177958_n()), (double)(minPos.func_177956_o() - pos.func_177956_o()), (double)(minPos.func_177952_p() - pos.func_177952_p()));
        SmelteryTankRenderer.renderFluids(matrices, buffer, smeltery.getTank(), minPos, maxPos, WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)minPos));
        int xd = 1 + maxPos.func_177958_n() - minPos.func_177958_n();
        int zd = 1 + maxPos.func_177952_p() - minPos.func_177952_p();
        int layer = xd * zd;
        Direction facing = (Direction)state.func_177229_b((Property)ControllerBlock.FACING);
        Quaternion itemRotation = Vector3f.field_229181_d_.func_229187_a_(-90.0f * (float)facing.func_176736_b());
        MeltingModuleInventory inventory = smeltery.getMeltingInventory();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            int height = i / layer;
            int layerIndex = i % layer;
            int offsetX = layerIndex % xd;
            int offsetZ = layerIndex / xd;
            BlockPos itemPos = minPos.func_177982_a(offsetX, height, offsetZ);
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)((float)offsetX + 0.5f), (double)((float)height + 0.5f), (double)((float)offsetZ + 0.5f));
            matrices.func_227863_a_(itemRotation);
            matrices.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.NONE, WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)itemPos), OverlayTexture.field_229196_a_, matrices, buffer);
            matrices.func_227865_b_();
        }
        matrices.func_227865_b_();
    }

    public boolean isGlobalRenderer(SmelteryTileEntity tile) {
        return (Boolean)tile.func_195044_w().func_177229_b((Property)ControllerBlock.IN_STRUCTURE) != false && tile.getStructure() != null;
    }
}

