/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiSmelteryTank;
import slimeknights.tconstruct.smeltery.tileentity.tank.SmelteryTank;

public class SmelteryTankRenderer {
    private static final RenderType RENDER_TYPE = RenderType.func_228633_a_((String)Util.resource("smeltery_fluid"), (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(PlayerContainer.field_226615_c_, false, false)).func_228723_a_(RenderType.field_228520_l_).func_228719_a_(RenderType.field_228528_t_).func_228724_a_(RenderType.field_228521_m_).func_228726_a_(RenderType.field_228515_g_).func_228714_a_(RenderType.field_228491_A_).func_228728_a_(false));
    private static final float FLUID_OFFSET = 0.005f;
    private static final int HEIGHT_OFFSET = 9;

    private static float[] getBlockBounds(int delta) {
        return SmelteryTankRenderer.getBlockBounds(delta, 0.005f, (float)delta + 1.0f - 0.005f);
    }

    private static float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    public static void renderFluids(MatrixStack matrices, IRenderTypeBuffer buffer, SmelteryTank tank, BlockPos tankMinPos, BlockPos tankMaxPos, int brightness) {
        List<FluidStack> fluids = tank.getFluids();
        if (!fluids.isEmpty()) {
            int xd = tankMaxPos.func_177958_n() - tankMinPos.func_177958_n();
            int zd = tankMaxPos.func_177952_p() - tankMinPos.func_177952_p();
            float[] xBounds = SmelteryTankRenderer.getBlockBounds(xd);
            float[] zBounds = SmelteryTankRenderer.getBlockBounds(zd);
            int yd = 1 + Math.max(0, tankMaxPos.func_177956_o() - tankMinPos.func_177956_o());
            int[] heights = GuiSmelteryTank.calcLiquidHeights(fluids, tank.getCapacity(), yd * 1000 - 9, 100);
            IVertexBuilder builder = buffer.getBuffer(RENDER_TYPE);
            float curY = 0.005f;
            for (int i = 0; i < fluids.size(); ++i) {
                float h = (float)heights[i] / 1000.0f;
                SmelteryTankRenderer.renderLargeFluidCuboid(matrices, builder, fluids.get(i), brightness, xd, xBounds, zd, zBounds, curY, curY + h);
                curY += h;
            }
        }
    }

    private static void renderLargeFluidCuboid(MatrixStack matrices, IVertexBuilder builder, FluidStack fluid, int brightness, int xd, float[] xBounds, int zd, float[] zBounds, float yMin, float yMax) {
        if (yMin >= yMax || fluid.isEmpty()) {
            return;
        }
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        TextureAtlasSprite still = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getStillTexture(fluid));
        int color = attributes.getColor(fluid);
        brightness = FluidRenderer.withBlockLight((int)brightness, (int)attributes.getLuminosity(fluid));
        boolean upsideDown = attributes.isGaseous(fluid);
        int yd = (int)(yMax - (float)((int)yMin));
        if ((double)yMax % 1.0 == 0.0) {
            --yd;
        }
        float[] yBounds = SmelteryTankRenderer.getBlockBounds(yd, yMin, yMax);
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        int rotation = upsideDown ? 180 : 0;
        for (int y = 0; y <= yd; ++y) {
            for (int z = 0; z <= zd; ++z) {
                for (int x = 0; x <= xd; ++x) {
                    from.func_195905_a(xBounds[x], yBounds[y], zBounds[z]);
                    to.func_195905_a(xBounds[x + 1], yBounds[y + 1], zBounds[z + 1]);
                    if (x == 0) {
                        FluidRenderer.putTexturedQuad((IVertexBuilder)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.WEST, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (x == xd) {
                        FluidRenderer.putTexturedQuad((IVertexBuilder)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.EAST, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (z == 0) {
                        FluidRenderer.putTexturedQuad((IVertexBuilder)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.NORTH, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (z == zd) {
                        FluidRenderer.putTexturedQuad((IVertexBuilder)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.SOUTH, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (y == yd) {
                        FluidRenderer.putTexturedQuad((IVertexBuilder)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.UP, (int)color, (int)brightness, (int)rotation, (boolean)false);
                    }
                    if (y != 0) continue;
                    from.setY(from.func_195900_b() + 0.001f);
                    FluidRenderer.putTexturedQuad((IVertexBuilder)builder, (Matrix4f)matrix, (TextureAtlasSprite)still, (Vector3f)from, (Vector3f)to, (Direction)Direction.DOWN, (int)color, (int)brightness, (int)rotation, (boolean)false);
                }
            }
        }
    }
}

