/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.FaucetFluidLoader;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.RenderingHelper;
import slimeknights.tconstruct.library.client.model.block.ChannelModel;
import slimeknights.tconstruct.smeltery.block.ChannelBlock;
import slimeknights.tconstruct.smeltery.tileentity.ChannelTileEntity;

public class ChannelTileEntityRenderer
extends TileEntityRenderer<ChannelTileEntity> {
    public ChannelTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(ChannelTileEntity te, float partialTicks, MatrixStack matrices, IRenderTypeBuffer buffer, int light, int combinedOverlayIn) {
        FluidCuboid cube;
        boolean isRotated;
        FluidStack fluid = te.getFluid();
        if (fluid.isEmpty()) {
            return;
        }
        World world = te.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = te.func_174877_v();
        BlockState state = te.func_195044_w();
        ChannelModel.BakedModel model = (ChannelModel.BakedModel)ModelHelper.getBakedModel((BlockState)state, ChannelModel.BakedModel.class);
        if (model == null) {
            return;
        }
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        TextureAtlasSprite still = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getStillTexture(fluid));
        TextureAtlasSprite flowing = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getFlowingTexture(fluid));
        IVertexBuilder builder = buffer.getBuffer(FluidRenderer.RENDER_TYPE);
        int color = attributes.getColor(fluid);
        light = FluidRenderer.withBlockLight((int)light, (int)attributes.getLuminosity(fluid));
        Direction centerFlow = Direction.UP;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            ChannelBlock.ChannelConnection connection = (ChannelBlock.ChannelConnection)((Object)state.func_177229_b((Property)ChannelBlock.DIRECTION_MAP.get(direction)));
            if (!connection.canFlow()) continue;
            isRotated = RenderingHelper.applyRotation((MatrixStack)matrices, (Direction)direction);
            if (te.isFlowing(direction)) {
                cube = model.getSideFlow(connection == ChannelBlock.ChannelConnection.OUT);
                if (connection == ChannelBlock.ChannelConnection.OUT) {
                    if (centerFlow == Direction.UP) {
                        centerFlow = direction;
                    } else if (centerFlow != direction) {
                        centerFlow = Direction.DOWN;
                    }
                }
            } else {
                cube = model.getSideStill();
            }
            FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)builder, (FluidCuboid)cube, (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light, (boolean)false);
            if (!world.func_180495_p(pos.func_177972_a(direction)).func_203425_a(state.func_177230_c())) {
                FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)builder, (FluidCuboid)model.getSideEdge(), (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light, (boolean)false);
            }
            if (!isRotated) continue;
            matrices.func_227865_b_();
        }
        isRotated = false;
        if (centerFlow.func_176740_k().func_200128_b()) {
            cube = model.getCenterFluid(false);
        } else {
            cube = model.getCenterFluid(true);
            isRotated = RenderingHelper.applyRotation((MatrixStack)matrices, (Direction)centerFlow);
        }
        FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)builder, (FluidCuboid)cube, (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light, (boolean)false);
        if (isRotated) {
            matrices.func_227865_b_();
        }
        if (((Boolean)state.func_177229_b((Property)ChannelBlock.DOWN)).booleanValue() && te.isFlowing(Direction.DOWN)) {
            cube = model.getDownFluid();
            FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)builder, (FluidCuboid)cube, (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light, (boolean)false);
            FaucetFluidLoader.renderFaucetFluids((IWorld)world, (BlockPos)pos, (Direction)Direction.DOWN, (MatrixStack)matrices, (IVertexBuilder)builder, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)light);
        }
    }
}

