/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.inventory.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.util.FluidTooltipHandler;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiSmelteryTank;

public class GuiTankModule {
    private final ContainerScreen<?> screen;
    private final IFluidTank tank;
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    private boolean isHovered(int checkX, int checkY) {
        return GuiUtil.isHovered(checkX, checkY, this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }

    private int getFluidHeight() {
        return this.height * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    public void draw(MatrixStack matrices) {
        GuiUtil.renderFluidTank(matrices, this.screen, this.tank.getFluid(), this.tank.getCapacity(), this.x, this.y, this.width, this.height, 100);
    }

    public void highlightHoveredFluid(MatrixStack matrices, int checkX, int checkY) {
        if (this.isHovered(checkX, checkY)) {
            int fluidHeight = this.getFluidHeight();
            int middle = this.y + this.height - fluidHeight;
            if (checkY > middle) {
                GuiUtil.renderHighlight(matrices, this.x, middle, this.width, fluidHeight);
            } else {
                GuiUtil.renderHighlight(matrices, this.x, this.y, this.width, this.height - fluidHeight);
            }
        }
    }

    public void renderTooltip(MatrixStack matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.screen.field_147003_i;
        int checkY = mouseY - this.screen.field_147009_r;
        if (this.isHovered(checkX, checkY)) {
            List<ITextComponent> tooltip;
            int amount = this.tank.getFluidAmount();
            int capacity = this.tank.getCapacity();
            if (checkY > this.y + this.height - this.getFluidHeight()) {
                tooltip = FluidTooltipHandler.getFluidTooltip(this.tank.getFluid());
            } else {
                BiConsumer<Integer, List> formatter = Util.isShiftKeyDown() ? FluidTooltipHandler::appendBuckets : FluidTooltipHandler::appendIngots;
                tooltip = new ArrayList<ITextComponent>();
                tooltip.add((ITextComponent)new TranslationTextComponent(GuiSmelteryTank.TOOLTIP_CAPACITY));
                formatter.accept(capacity, tooltip);
                if (capacity != amount) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(GuiSmelteryTank.TOOLTIP_AVAILABLE));
                    formatter.accept(capacity - amount, tooltip);
                }
                FluidTooltipHandler.appendShift(tooltip);
            }
            this.screen.func_243308_b(matrices, tooltip, mouseX, mouseY);
        }
    }

    @Nullable
    public FluidStack getIngreientUnderMouse(int checkX, int checkY) {
        if (this.isHovered(checkX, checkY) && checkY > this.y + this.height - this.getFluidHeight()) {
            return this.tank.getFluid();
        }
        return null;
    }

    public GuiTankModule(ContainerScreen<?> screen, IFluidTank tank, int x, int y, int width, int height) {
        this.screen = screen;
        this.tank = tank;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
}

