/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.inventory.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;

public class GuiMeltingModule {
    private static final ScalableElementScreen PROGRESS_BAR = new ScalableElementScreen(176, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen NO_HEAT_BAR = new ScalableElementScreen(179, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen NO_SPACE_BAR = new ScalableElementScreen(182, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen UNMELTABLE_BAR = new ScalableElementScreen(185, 150, 3, 16, 256, 256);
    private static final ITextComponent TOOLTIP_NO_HEAT = new TranslationTextComponent(Util.makeTranslationKey("gui", "melting.no_heat"));
    private static final ITextComponent TOOLTIP_NO_SPACE = new TranslationTextComponent(Util.makeTranslationKey("gui", "melting.no_space"));
    private static final ITextComponent TOOLTIP_UNMELTABLE = new TranslationTextComponent(Util.makeTranslationKey("gui", "melting.no_recipe"));
    private final ContainerScreen<?> screen;
    private final MeltingModuleInventory inventory;
    private final IntSupplier temperature;
    private final Predicate<Slot> slotPredicate;

    public void drawHeatBars(MatrixStack matrices) {
        int temperature = this.temperature.getAsInt();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            Slot slot = (Slot)this.screen.func_212873_a_().field_75151_b.get(i);
            if (!slot.func_75216_d() || !this.slotPredicate.test(slot)) continue;
            ScalableElementScreen bar = PROGRESS_BAR;
            int index = slot.getSlotIndex();
            int currentTemp = this.inventory.getCurrentTime(index);
            int requiredTime = this.inventory.getRequiredTime(index);
            float progress = 1.0f;
            if (requiredTime == 0) {
                bar = UNMELTABLE_BAR;
            } else if (this.inventory.getRequiredTemp(index) > temperature) {
                bar = NO_HEAT_BAR;
            } else if (currentTemp < 0) {
                bar = NO_SPACE_BAR;
                progress = 1.0f;
            } else if (currentTemp <= requiredTime) {
                progress = (float)currentTemp / (float)requiredTime;
            }
            GuiUtil.drawProgressUp(matrices, (ElementScreen)bar, slot.field_75223_e - 4, slot.field_75221_f, progress);
        }
    }

    public void drawHeatTooltips(MatrixStack matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.screen.field_147003_i;
        int checkY = mouseY - this.screen.field_147009_r;
        int temperature = this.temperature.getAsInt();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            Slot slot = (Slot)this.screen.func_212873_a_().field_75151_b.get(i);
            if (!slot.func_75216_d() || !this.slotPredicate.test(slot) || !GuiUtil.isHovered(checkX, checkY, slot.field_75223_e - 5, slot.field_75221_f - 1, GuiMeltingModule.PROGRESS_BAR.w + 1, GuiMeltingModule.PROGRESS_BAR.h + 2)) continue;
            int index = slot.getSlotIndex();
            ITextComponent tooltip = null;
            if (this.inventory.getRequiredTime(index) == 0) {
                tooltip = TOOLTIP_UNMELTABLE;
            } else if (this.inventory.getRequiredTemp(slot.getSlotIndex()) > temperature) {
                tooltip = TOOLTIP_NO_HEAT;
            } else if (this.inventory.getCurrentTime(index) < 0) {
                tooltip = TOOLTIP_NO_SPACE;
            }
            if (tooltip == null) break;
            this.screen.func_238652_a_(matrices, tooltip, mouseX, mouseY);
            break;
        }
    }

    public GuiMeltingModule(ContainerScreen<?> screen, MeltingModuleInventory inventory, IntSupplier temperature, Predicate<Slot> slotPredicate) {
        this.screen = screen;
        this.inventory = inventory;
        this.temperature = temperature;
        this.slotPredicate = slotPredicate;
    }
}

