/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.inventory.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.util.FluidTooltipHandler;
import slimeknights.tconstruct.smeltery.tileentity.module.FuelModule;

public class GuiFuelModule {
    private static final ScalableElementScreen FIRE = new ScalableElementScreen(176, 136, 14, 14, 256, 256);
    private static final String TOOLTIP_TEMPERATURE = Util.makeTranslationKey("gui", "melting.fuel.temperature");
    private static final List<ITextComponent> TOOLTIP_NO_TANK = Collections.singletonList(new TranslationTextComponent(Util.makeTranslationKey("gui", "melting.fuel.no_tank")));
    private static final List<ITextComponent> TOOLTIP_NO_FUEL = Collections.singletonList(new TranslationTextComponent(Util.makeTranslationKey("gui", "melting.fuel.empty")));
    private static final ITextComponent TOOLTIP_INVALID_FUEL = new TranslationTextComponent(Util.makeTranslationKey("gui", "melting.fuel.invalid")).func_240699_a_(TextFormatting.RED);
    private static final ITextComponent TOOLTIP_SOLID_FUEL = new TranslationTextComponent(Util.makeTranslationKey("gui", "melting.fuel.solid"));
    private final ContainerScreen<?> screen;
    private final FuelModule fuelModule;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int fireX;
    private final int fireY;
    private final boolean hasFuelSlot;
    private FuelModule.FuelInfo fuelInfo = FuelModule.FuelInfo.EMPTY;

    private boolean isHovered(int checkX, int checkY) {
        return GuiUtil.isHovered(checkX, checkY, this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }

    public void draw(MatrixStack matrices) {
        int fuel = this.fuelModule.getFuel();
        int fuelQuality = this.fuelModule.getFuelQuality();
        if (fuel > 0 && fuelQuality > 0) {
            FIRE.drawScaledYUp(matrices, this.fireX + this.screen.field_147003_i, this.fireY + this.screen.field_147009_r, 14 * fuel / fuelQuality);
        }
        if (!this.hasFuelSlot) {
            this.fuelInfo = this.fuelModule.getFuelInfo();
            if (!this.fuelInfo.isEmpty()) {
                GuiUtil.renderFluidTank(matrices, this.screen, this.fuelInfo.getFluid(), this.fuelInfo.getTotalAmount(), this.fuelInfo.getCapacity(), this.x, this.y, this.width, this.height, 100);
            }
        }
    }

    public void renderHighlight(MatrixStack matrices, int checkX, int checkY) {
        if (this.isHovered(checkX, checkY)) {
            if (this.hasFuelSlot) {
                if (checkY > this.y + 18) {
                    GuiUtil.renderHighlight(matrices, this.x, this.y + 18, this.width, this.height - 18);
                }
            } else {
                GuiUtil.renderHighlight(matrices, this.x, this.y, this.width, this.height);
            }
        }
    }

    public void addTooltip(MatrixStack matrices, int mouseX, int mouseY, boolean hasTank) {
        int checkX = mouseX - this.screen.field_147003_i;
        int checkY = mouseY - this.screen.field_147009_r;
        if (this.isHovered(checkX, checkY)) {
            List<Object> tooltip;
            if (this.hasFuelSlot || this.fuelInfo.isItem()) {
                int temperature;
                tooltip = !this.hasFuelSlot || checkY > this.y + 18 ? (hasTank ? ((temperature = this.fuelModule.getTemperature()) > 0 ? Arrays.asList(TOOLTIP_SOLID_FUEL, new TranslationTextComponent(TOOLTIP_TEMPERATURE, new Object[]{temperature}).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC})) : TOOLTIP_NO_FUEL) : TOOLTIP_NO_TANK) : Collections.emptyList();
            } else if (!this.fuelInfo.isEmpty()) {
                FluidStack fluid = this.fuelInfo.getFluid();
                tooltip = FluidTooltipHandler.getFluidTooltip(fluid, this.fuelInfo.getTotalAmount());
                int temperature = this.fuelInfo.getTemperature();
                if (temperature > 0) {
                    tooltip.add(1, new TranslationTextComponent(TOOLTIP_TEMPERATURE, new Object[]{temperature}).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                } else {
                    tooltip.add(1, TOOLTIP_INVALID_FUEL);
                }
            } else {
                tooltip = hasTank ? TOOLTIP_NO_FUEL : TOOLTIP_NO_TANK;
            }
            this.screen.func_243308_b(matrices, tooltip, mouseX, mouseY);
        }
    }

    @Nullable
    public FluidStack getIngredient(int checkX, int checkY) {
        if (!this.hasFuelSlot && this.isHovered(checkX, checkY) && !this.fuelInfo.isEmpty()) {
            return this.fuelInfo.getFluid();
        }
        return null;
    }

    public GuiFuelModule(ContainerScreen<?> screen, FuelModule fuelModule, int x, int y, int width, int height, int fireX, int fireY, boolean hasFuelSlot) {
        this.screen = screen;
        this.fuelModule = fuelModule;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fireX = fireX;
        this.fireY = fireY;
        this.hasFuelSlot = hasFuelSlot;
    }
}

