/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.fluid.FluidTransferUtil;
import slimeknights.tconstruct.smeltery.block.ControllerBlock;
import slimeknights.tconstruct.smeltery.tileentity.ITankTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.MelterTileEntity;

public class MelterBlock
extends ControllerBlock {
    public MelterBlock(AbstractBlock.Properties props) {
        super(props);
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + (double)(rand.nextFloat() * 6.0f / 16.0f);
            double z = (double)pos.func_177952_p() + 0.5;
            double frontOffset = 0.52;
            double sideOffset = rand.nextDouble() * 0.6 - 0.3;
            this.spawnFireParticles((IWorld)world, state, x, y, z, frontOffset, sideOffset);
        }
    }

    protected boolean isValidFuelSource(BlockState state) {
        return TinkerTags.Blocks.MELTER_TANKS.func_230235_a_((Object)state.func_177230_c());
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (state != null) {
            return (BlockState)state.func_206870_a((Property)IN_STRUCTURE, (Comparable)Boolean.valueOf(this.isValidFuelSource(context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()))));
        }
        return null;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbor, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            return (BlockState)state.func_206870_a((Property)IN_STRUCTURE, (Comparable)Boolean.valueOf(this.isValidFuelSource(neighbor)));
        }
        return state;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(BlockState blockState, IBlockReader iBlockReader) {
        return new MelterTileEntity();
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (FluidTransferUtil.interactWithTank(world, pos, player, hand, hit)) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return ITankTileEntity.getComparatorInputOverride((IWorld)worldIn, pos);
    }
}

