/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.smeltery.tileentity.FaucetTileEntity;

public class FaucetBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208156_I;
    private static final EnumMap<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.DOWN, (Object)VoxelShapes.func_197878_a((VoxelShape)FaucetBlock.func_208617_a((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape)FaucetBlock.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (IBooleanFunction)IBooleanFunction.field_223234_e_), (Object)Direction.NORTH, (Object)VoxelShapes.func_197878_a((VoxelShape)FaucetBlock.func_208617_a((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)10.0, (double)16.0), (VoxelShape)FaucetBlock.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223234_e_), (Object)Direction.SOUTH, (Object)VoxelShapes.func_197878_a((VoxelShape)FaucetBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)10.0, (double)6.0), (VoxelShape)FaucetBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), (IBooleanFunction)IBooleanFunction.field_223234_e_), (Object)Direction.WEST, (Object)VoxelShapes.func_197878_a((VoxelShape)FaucetBlock.func_208617_a((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)10.0, (double)12.0), (VoxelShape)FaucetBlock.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), (IBooleanFunction)IBooleanFunction.field_223234_e_), (Object)Direction.EAST, (Object)VoxelShapes.func_197878_a((VoxelShape)FaucetBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)10.0, (double)12.0), (VoxelShape)FaucetBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)));

    public FaucetBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction dir = context.func_196000_l();
        if (dir == Direction.UP) {
            dir = Direction.DOWN;
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)dir);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FaucetTileEntity();
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        this.getFaucet(worldIn, pos).ifPresent(FaucetTileEntity::activate);
        return ActionResultType.SUCCESS;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.func_201670_d()) {
            return;
        }
        this.getFaucet(worldIn, pos).ifPresent(faucet -> {
            faucet.neighborChanged(fromPos);
            faucet.handleRedstone(worldIn.func_175640_z(pos));
        });
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.getFaucet((World)worldIn, pos).ifPresent(FaucetTileEntity::activate);
    }

    private Optional<FaucetTileEntity> getFaucet(World world, BlockPos pos) {
        return TileEntityHelper.getTile(FaucetTileEntity.class, (IBlockReader)world, (BlockPos)pos);
    }

    private static void addParticles(BlockState state, IWorld worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        double x = (double)pos.func_177958_n() + 0.5 - 0.3 * (double)direction.func_82601_c();
        double y = (double)pos.func_177956_o() + 0.5 - 0.3 * (double)direction.func_96559_d();
        double z = (double)pos.func_177952_p() + 0.5 - 0.3 * (double)direction.func_82599_e();
        worldIn.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 0.0f, 0.0f, 0.5f), x, y, z, 0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.getFaucet(worldIn, pos).ifPresent(faucet -> {
            if (faucet.isPouring() && faucet.getRenderFluid().isEmpty() && rand.nextFloat() < 0.25f) {
                FaucetBlock.addParticles(stateIn, (IWorld)worldIn, pos);
            }
        });
    }
}

