/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.smeltery.tileentity.ChannelTileEntity;

public class ChannelBlock
extends Block {
    private static final ITextComponent SIDE_IN;
    private static final ITextComponent SIDE_OUT;
    private static final ITextComponent SIDE_NONE;
    private static final ITextComponent DOWN_OUT;
    private static final ITextComponent DOWN_NONE;
    private static final Map<ChannelConnection, ITextComponent> SIDE_CONNECTION;
    public static final BooleanProperty DOWN;
    public static final BooleanProperty POWERED;
    public static final EnumProperty<ChannelConnection> NORTH;
    public static final EnumProperty<ChannelConnection> SOUTH;
    public static final EnumProperty<ChannelConnection> WEST;
    public static final EnumProperty<ChannelConnection> EAST;
    public static final Map<Direction, EnumProperty<ChannelConnection>> DIRECTION_MAP;
    private static final Map<Direction, VoxelShape> SIDE_BOUNDS;
    private static final VoxelShape[] BOUNDS;

    private static int makeKey(boolean down, boolean north, boolean south, boolean west, boolean east) {
        return (down ? 1 : 0) | (north ? 2 : 0) | (south ? 4 : 0) | (west ? 8 : 0) | (east ? 16 : 0);
    }

    public ChannelBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a(NORTH, (Comparable)((Object)ChannelConnection.NONE))).func_206870_a(SOUTH, (Comparable)((Object)ChannelConnection.NONE))).func_206870_a(WEST, (Comparable)((Object)ChannelConnection.NONE))).func_206870_a(EAST, (Comparable)((Object)ChannelConnection.NONE)));
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOUNDS[ChannelBlock.makeKey((Boolean)state.func_177229_b((Property)DOWN), ((ChannelConnection)((Object)state.func_177229_b(NORTH))).canFlow(), ((ChannelConnection)((Object)state.func_177229_b(SOUTH))).canFlow(), ((ChannelConnection)((Object)state.func_177229_b(WEST))).canFlow(), ((ChannelConnection)((Object)state.func_177229_b(EAST))).canFlow())];
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DOWN, POWERED});
        DIRECTION_MAP.values().forEach(xva$0 -> builder.func_206894_a(new Property[]{xva$0}));
    }

    private static boolean isFluidHandler(IWorld world, Direction side, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).isPresent();
    }

    private boolean canConnect(IWorld world, Direction side, BlockState facingState, BlockPos facingPos) {
        if (facingState.func_177230_c() == this) {
            return true;
        }
        return ChannelBlock.isFluidHandler(world, side.func_176734_d(), facingPos);
    }

    private boolean canConnect(IWorld world, BlockPos pos, Direction side) {
        BlockPos facingPos = pos.func_177972_a(side);
        return this.canConnect(world, side, world.func_180495_p(facingPos), facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(world.func_175640_z(pos)));
        Direction side = context.func_196000_l();
        if (side == Direction.DOWN) {
            return state;
        }
        if (side == Direction.UP) {
            return (BlockState)state.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnect((IWorld)world, pos, Direction.DOWN)));
        }
        ChannelConnection connection = ChannelConnection.NONE;
        BlockPos placedOn = pos.func_177972_a(side.func_176734_d());
        if (world.func_180495_p(placedOn).func_203425_a((Block)this)) {
            PlayerEntity player = context.func_195999_j();
            connection = player != null && player.func_225608_bj_() ? ChannelConnection.IN : ChannelConnection.OUT;
        } else if (ChannelBlock.isFluidHandler((IWorld)world, side, placedOn)) {
            connection = ChannelConnection.OUT;
        }
        return (BlockState)state.func_206870_a((Property)DIRECTION_MAP.get(side.func_176734_d()), (Comparable)((Object)connection));
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            if (((Boolean)state.func_177229_b((Property)DOWN)).booleanValue() && !this.canConnect(world, facing, facingState, facingPos)) {
                state = (BlockState)state.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false));
            }
            return state;
        }
        if (facing != Direction.UP) {
            EnumProperty<ChannelConnection> prop = DIRECTION_MAP.get(facing);
            if (facingState.func_177230_c() == this) {
                state = (BlockState)state.func_206870_a(prop, (Comparable)((Object)((ChannelConnection)((Object)facingState.func_177229_b((Property)DIRECTION_MAP.get(facing.func_176734_d())))).getOpposite()));
            } else {
                ChannelConnection connection = (ChannelConnection)((Object)state.func_177229_b(prop));
                if (connection == ChannelConnection.IN || connection == ChannelConnection.OUT && !ChannelBlock.isFluidHandler(world, facing.func_176734_d(), facingPos)) {
                    state = (BlockState)state.func_206870_a(prop, (Comparable)((Object)ChannelConnection.NONE));
                }
            }
        }
        return state;
    }

    @Nullable
    private BlockState interactWithSide(BlockState state, World world, BlockPos pos, PlayerEntity player, Direction side) {
        if (side == Direction.DOWN) {
            if (!((Boolean)state.func_177229_b((Property)DOWN)).booleanValue() && this.canConnect((IWorld)world, pos, side)) {
                player.func_146105_b(DOWN_OUT, true);
                return (BlockState)state.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(true));
            }
            if (((Boolean)state.func_177229_b((Property)DOWN)).booleanValue()) {
                player.func_146105_b(DOWN_NONE, true);
                return (BlockState)state.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false));
            }
        } else {
            EnumProperty<ChannelConnection> prop = DIRECTION_MAP.get(side);
            ChannelConnection connection = (ChannelConnection)((Object)state.func_177229_b(prop));
            BlockPos facingPos = pos.func_177972_a(side);
            BlockState facingState = world.func_180495_p(facingPos);
            if (facingState.func_177230_c() == this) {
                ChannelConnection newConnect = connection.getNext(player.func_225608_bj_());
                player.func_146105_b(SIDE_CONNECTION.get((Object)newConnect), true);
                return (BlockState)state.func_206870_a(prop, (Comparable)((Object)newConnect));
            }
            if (connection != ChannelConnection.OUT && ChannelBlock.isFluidHandler((IWorld)world, side.func_176734_d(), facingPos)) {
                player.func_146105_b(SIDE_OUT, true);
                return (BlockState)state.func_206870_a(prop, (Comparable)((Object)ChannelConnection.OUT));
            }
            if (connection != ChannelConnection.NONE) {
                player.func_146105_b(SIDE_NONE, true);
                return (BlockState)state.func_206870_a(prop, (Comparable)((Object)ChannelConnection.NONE));
            }
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Direction hitFace = hit.func_216354_b();
        if (player.func_184586_b(hand).func_77973_b() == this.func_199767_j() && world.func_175623_d(pos.func_177972_a(hitFace))) {
            return ActionResultType.PASS;
        }
        Direction side = hitFace == Direction.UP ? Direction.DOWN : hitFace;
        Vector3d hitVec = hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (hitVec.func_82616_c() < 0.25) {
            side = Direction.NORTH;
        } else if (hitVec.func_82616_c() > 0.75) {
            side = Direction.SOUTH;
        } else if (hitVec.func_82615_a() < 0.25) {
            side = Direction.WEST;
        } else if (hitVec.func_82615_a() > 0.75) {
            side = Direction.EAST;
        }
        BlockState newState = this.interactWithSide(state, world, pos, player, side);
        if (newState == null && side != Direction.DOWN) {
            newState = this.interactWithSide(state, world, pos, player, Direction.DOWN);
        }
        if (newState != null) {
            world.func_175656_a(pos, newState);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.field_72995_K) {
            boolean isPowered = worldIn.func_175640_z(pos);
            if (isPowered != (Boolean)state.func_177229_b((Property)POWERED)) {
                state = (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(isPowered && this.canConnect((IWorld)worldIn, pos, Direction.DOWN)));
                worldIn.func_180501_a(pos, state, 2);
            }
            TileEntityHelper.getTile(ChannelTileEntity.class, (IBlockReader)worldIn, (BlockPos)pos).ifPresent(te -> te.removeCachedNeighbor(ChannelBlock.fromOffset(pos, fromPos)));
        }
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return side.func_176740_k().func_176722_c() && adjacentBlockState.func_203425_a((Block)this) && ((ChannelConnection)((Object)state.func_177229_b((Property)DIRECTION_MAP.get(side)))).canFlow() && ((ChannelConnection)((Object)adjacentBlockState.func_177229_b((Property)DIRECTION_MAP.get(side.func_176734_d())))).canFlow();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ChannelTileEntity();
    }

    private static Direction fromOffset(BlockPos pos, BlockPos neighbor) {
        BlockPos offset = neighbor.func_177973_b((Vector3i)pos);
        for (Direction direction : Direction.values()) {
            if (!direction.func_176730_m().equals((Object)offset)) continue;
            return direction;
        }
        TConstruct.log.error("Channel found no offset for position pair {} and {} on neighbor changed", (Object)pos, (Object)neighbor);
        return Direction.DOWN;
    }

    static {
        boolean[] bools;
        SIDE_IN = new TranslationTextComponent(Util.makeTranslationKey("block", "channel.side.in"));
        SIDE_OUT = new TranslationTextComponent(Util.makeTranslationKey("block", "channel.side.out"));
        SIDE_NONE = new TranslationTextComponent(Util.makeTranslationKey("block", "channel.side.none"));
        DOWN_OUT = new TranslationTextComponent(Util.makeTranslationKey("block", "channel.down.out"));
        DOWN_NONE = new TranslationTextComponent(Util.makeTranslationKey("block", "channel.down.none"));
        SIDE_CONNECTION = Util.make(new EnumMap(ChannelConnection.class), map -> {
            map.put(ChannelConnection.IN, SIDE_IN);
            map.put(ChannelConnection.OUT, SIDE_OUT);
            map.put(ChannelConnection.NONE, SIDE_NONE);
        });
        DOWN = BlockStateProperties.field_208150_C;
        POWERED = BlockStateProperties.field_208194_u;
        NORTH = EnumProperty.func_177709_a((String)"north", ChannelConnection.class);
        SOUTH = EnumProperty.func_177709_a((String)"south", ChannelConnection.class);
        WEST = EnumProperty.func_177709_a((String)"west", ChannelConnection.class);
        EAST = EnumProperty.func_177709_a((String)"east", ChannelConnection.class);
        DIRECTION_MAP = Util.make(new EnumMap(Direction.class), map -> {
            map.put(Direction.NORTH, NORTH);
            map.put(Direction.SOUTH, SOUTH);
            map.put(Direction.WEST, WEST);
            map.put(Direction.EAST, EAST);
        });
        SIDE_BOUNDS = Util.make(new EnumMap(Direction.class), map -> {
            map.put(Direction.NORTH, VoxelShapes.func_197878_a((VoxelShape)ChannelBlock.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)9.0, (double)4.0), (VoxelShape)ChannelBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)9.0, (double)4.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
            map.put(Direction.SOUTH, VoxelShapes.func_197878_a((VoxelShape)ChannelBlock.func_208617_a((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)9.0, (double)16.0), (VoxelShape)ChannelBlock.func_208617_a((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)9.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
            map.put(Direction.WEST, VoxelShapes.func_197878_a((VoxelShape)ChannelBlock.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)9.0, (double)12.0), (VoxelShape)ChannelBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)9.0, (double)10.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
            map.put(Direction.EAST, VoxelShapes.func_197878_a((VoxelShape)ChannelBlock.func_208617_a((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)9.0, (double)12.0), (VoxelShape)ChannelBlock.func_208617_a((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0, (double)10.0), (IBooleanFunction)IBooleanFunction.field_223234_e_));
        });
        VoxelShape centerUnconnected = VoxelShapes.func_197882_b((VoxelShape)ChannelBlock.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)ChannelBlock.func_208617_a((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0), (VoxelShape)ChannelBlock.func_208617_a((double)4.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0)), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        VoxelShape centerConnected = VoxelShapes.func_197882_b((VoxelShape)ChannelBlock.func_208617_a((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)ChannelBlock.func_208617_a((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{ChannelBlock.func_208617_a((double)4.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0), ChannelBlock.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)}), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        VoxelShape northWall = ChannelBlock.func_208617_a((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)9.0, (double)6.0);
        VoxelShape southWall = ChannelBlock.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)9.0, (double)12.0);
        VoxelShape westWall = ChannelBlock.func_208617_a((double)4.0, (double)6.0, (double)6.0, (double)6.0, (double)9.0, (double)10.0);
        VoxelShape eastWall = ChannelBlock.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)12.0, (double)9.0, (double)10.0);
        BOUNDS = new VoxelShape[32];
        for (boolean down : bools = new boolean[]{false, true}) {
            VoxelShape center = down ? centerConnected : centerUnconnected;
            for (boolean north : bools) {
                VoxelShape northBounds = north ? SIDE_BOUNDS.get(Direction.NORTH) : northWall;
                for (boolean south : bools) {
                    VoxelShape southBounds = south ? SIDE_BOUNDS.get(Direction.SOUTH) : southWall;
                    for (boolean west : bools) {
                        VoxelShape westBounds = west ? SIDE_BOUNDS.get(Direction.WEST) : westWall;
                        for (boolean east : bools) {
                            VoxelShape eastBounds = east ? SIDE_BOUNDS.get(Direction.EAST) : eastWall;
                            ChannelBlock.BOUNDS[ChannelBlock.makeKey((boolean)down, (boolean)north, (boolean)south, (boolean)west, (boolean)east)] = VoxelShapes.func_216384_a((VoxelShape)center, (VoxelShape[])new VoxelShape[]{northBounds, southBounds, westBounds, eastBounds});
                        }
                    }
                }
            }
        }
    }

    public static enum ChannelConnection implements IStringSerializable
    {
        NONE,
        IN,
        OUT;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public boolean canFlow() {
            return this == IN || this == OUT;
        }

        public ChannelConnection getOpposite() {
            switch (this) {
                case IN: {
                    return OUT;
                }
                case OUT: {
                    return IN;
                }
            }
            return NONE;
        }

        public ChannelConnection getNext(boolean reverse) {
            if (reverse) {
                switch (this) {
                    case NONE: {
                        return OUT;
                    }
                    case OUT: {
                        return IN;
                    }
                    case IN: {
                        return NONE;
                    }
                }
            } else {
                switch (this) {
                    case NONE: {
                        return IN;
                    }
                    case IN: {
                        return OUT;
                    }
                    case OUT: {
                        return NONE;
                    }
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

