/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery;

import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.mantle.client.model.FaucetFluidLoader;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.model.block.CastingModel;
import slimeknights.tconstruct.library.client.model.block.ChannelModel;
import slimeknights.tconstruct.library.client.model.block.FluidTextureModel;
import slimeknights.tconstruct.library.client.model.block.MelterModel;
import slimeknights.tconstruct.library.client.model.block.TankModel;
import slimeknights.tconstruct.library.client.util.FluidTooltipHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.client.SingleItemScreenFactory;
import slimeknights.tconstruct.smeltery.client.inventory.MelterScreen;
import slimeknights.tconstruct.smeltery.client.inventory.SmelteryScreen;
import slimeknights.tconstruct.smeltery.client.render.CastingTileEntityRenderer;
import slimeknights.tconstruct.smeltery.client.render.ChannelTileEntityRenderer;
import slimeknights.tconstruct.smeltery.client.render.FaucetTileEntityRenderer;
import slimeknights.tconstruct.smeltery.client.render.MelterTileEntityRenderer;
import slimeknights.tconstruct.smeltery.client.render.SmelteryTileEntityRenderer;
import slimeknights.tconstruct.smeltery.client.render.TankTileEntityRenderer;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.smeltery.tileentity.DrainTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.DuctTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.ITankTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.tank.ISmelteryTankHandler;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class SmelteryClientEvents
extends ClientEventBase {
    public static void addResourceListener(IReloadableResourceManager manager) {
        FaucetFluidLoader.initialize();
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.searedFaucet.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.castingBasin.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.castingTable.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.searedMelter.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.smelteryController.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.searedDrain.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.searedDuct.get()), (RenderType)cutout);
        TinkerSmeltery.searedTank.forEach(tank -> RenderTypeLookup.setRenderLayer((Block)tank, (RenderType)cutout));
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.searedGlass.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)TinkerSmeltery.searedGlassPane.get()), (RenderType)cutout);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TinkerSmeltery.tank.get()), TankTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TinkerSmeltery.faucet.get()), FaucetTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TinkerSmeltery.channel.get()), ChannelTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TinkerSmeltery.table.get()), CastingTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TinkerSmeltery.basin.get()), CastingTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TinkerSmeltery.melter.get()), MelterTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TinkerSmeltery.smeltery.get()), SmelteryTileEntityRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)TinkerSmeltery.melterContainer.get()), MelterScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)TinkerSmeltery.smelteryContainer.get()), SmelteryScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)TinkerSmeltery.singleItemContainer.get()), (ScreenManager.IScreenFactory)new SingleItemScreenFactory());
        FluidTooltipHandler.init();
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Util.getResource("tank"), (IModelLoader)TankModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Util.getResource("casting"), (IModelLoader)CastingModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Util.getResource("melter"), (IModelLoader)MelterModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Util.getResource("channel"), (IModelLoader)ChannelModel.LOADER);
        ModelLoaderRegistry.registerLoader((ResourceLocation)Util.getResource("fluid_texture"), (IModelLoader)FluidTextureModel.LOADER);
    }

    @SubscribeEvent
    static void blockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        IBlockColor handler = (state, world, pos, index) -> {
            TileEntity te;
            if (pos != null && world != null && (te = world.func_175625_s(pos)) instanceof ITankTileEntity) {
                FluidStack fluid = ((ITankTileEntity)te).getTank().getFluid();
                return fluid.getFluid().getAttributes().getColor(fluid);
            }
            return -1;
        };
        TinkerSmeltery.searedTank.forEach(tank -> colors.func_186722_a(handler, new Block[]{tank}));
        colors.func_186722_a(handler, new Block[]{(Block)TinkerSmeltery.searedMelter.get()});
        colors.func_186722_a((state, world, pos, index) -> {
            FluidStack bottom;
            TileEntity te;
            if (index == 1 && world != null && pos != null && (te = world.func_175625_s(pos)) instanceof ISmelteryTankHandler && !(bottom = ((ISmelteryTankHandler)te).getTank().getFluidInTank(0)).isEmpty()) {
                return bottom.getFluid().getAttributes().getColor(bottom);
            }
            return -1;
        }, new Block[]{(Block)TinkerSmeltery.smelteryController.get()});
        colors.func_186722_a((state, world, pos, index) -> {
            TileEntity te;
            if (index == 1 && world != null && pos != null && (te = world.func_175625_s(pos)) instanceof DrainTileEntity) {
                return ((DrainTileEntity)te).getDisplayFluid().getAttributes().getColor();
            }
            return -1;
        }, new Block[]{(Block)TinkerSmeltery.searedDrain.get()});
        colors.func_186722_a((state, world, pos, index) -> {
            TileEntity te;
            if (index == 1 && world != null && pos != null && (te = world.func_175625_s(pos)) instanceof DuctTileEntity) {
                return ((DuctTileEntity)te).getItemHandler().getFluid().getAttributes().getColor();
            }
            return -1;
        }, new Block[]{(Block)TinkerSmeltery.searedDuct.get()});
    }

    @SubscribeEvent
    static void itemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, index) -> {
            FluidTank tank = TankItem.getFluidTank(stack);
            if (!tank.isEmpty()) {
                FluidStack fluid = tank.getFluid();
                return fluid.getFluid().getAttributes().getColor(fluid);
            }
            return -1;
        }, (IItemProvider[])TinkerSmeltery.searedTank.values().toArray(new Block[0]));
    }
}

