/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Locale;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.TinkerFood;

public enum SlimeType implements IStringSerializable
{
    EARTH(118094, (ITag<Item>)TinkerTags.Items.EARTH_SLIMEBALL),
    SKY(117709, (ITag<Item>)TinkerTags.Items.SKY_SLIMEBALL),
    ICHOR(16750349, (ITag<Item>)TinkerTags.Items.ICHOR_SLIMEBALL),
    ENDER(11488502, (ITag<Item>)TinkerTags.Items.ENDER_SLIMEBALL),
    BLOOD(11862273, (ITag<Item>)TinkerTags.Items.BLOOD_SLIMEBALL);

    public static final SlimeType[] TINKER;
    public static final SlimeType[] TRUE_SLIME;
    private final int color;
    @Deprecated
    private final ITag<Item> slimeBallTag;

    public Food getSlimeFood(SlimeType type) {
        switch (type) {
            default: {
                return TinkerFood.BLUE_SLIME_BALL;
            }
            case ENDER: {
                return TinkerFood.PURPLE_SLIME_BALL;
            }
            case BLOOD: {
                return TinkerFood.BLOOD_SLIME_BALL;
            }
            case ICHOR: 
        }
        return TinkerFood.MAGMA_SLIME_BALL;
    }

    public Food getSlimeDropFood(SlimeType type) {
        switch (type) {
            default: {
                return TinkerFood.GREEN_SLIME_DROP;
            }
            case SKY: {
                return TinkerFood.BLUE_SLIME_DROP;
            }
            case ENDER: {
                return TinkerFood.PURPLE_SLIME_DROP;
            }
            case BLOOD: {
                return TinkerFood.BLOOD_SLIME_DROP;
            }
            case ICHOR: 
        }
        return TinkerFood.MAGMA_SLIME_DROP;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.US);
    }

    private SlimeType(int color, ITag<Item> slimeBallTag) {
        this.color = color;
        this.slimeBallTag = slimeBallTag;
    }

    public int getColor() {
        return this.color;
    }

    @Deprecated
    public ITag<Item> getSlimeBallTag() {
        return this.slimeBallTag;
    }

    static {
        TINKER = new SlimeType[]{SKY, ENDER, BLOOD, ICHOR};
        TRUE_SLIME = new SlimeType[]{EARTH, SKY, ENDER, ICHOR};
    }
}

