/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.EdibleItem;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.conditions.ConfigEnabledCondition;
import slimeknights.tconstruct.common.recipe.BlockOrEntityCondition;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.shared.TinkerFood;
import slimeknights.tconstruct.shared.block.ClearGlassPaneBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassPaneBlock;
import slimeknights.tconstruct.shared.block.GlowBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.shared.data.CommonRecipeProvider;
import slimeknights.tconstruct.shared.item.TinkerBookItem;

public final class TinkerCommons
extends TinkerModule {
    static final Logger log = Util.getLogger("tinker_commons");
    public static final Material GLOW = new Material.Builder(MaterialColor.field_151660_b).func_200508_c().func_200505_j().func_200502_b().func_200511_g().func_200509_f().func_200506_i();
    public static final RegistryObject<GlowBlock> glow = BLOCKS.registerNoItem("glow", () -> new GlowBlock(TinkerCommons.builder(GLOW, NO_TOOL, SoundType.field_185854_g).func_200943_b(0.0f).func_235838_a_(s -> 14).func_226896_b_()));
    public static final BuildingBlockObject mudBricks = BLOCKS.registerBuilding("mud_bricks", TinkerCommons.builder(Material.field_151578_c, ToolType.SHOVEL, SoundType.field_185849_b).func_235861_h_().func_200943_b(2.0f), GENERAL_BLOCK_ITEM);
    private static final AbstractBlock.Properties DRIED_CLAY = TinkerCommons.builder(Material.field_151576_e, ToolType.PICKAXE, SoundType.field_185851_d).func_235861_h_().func_200948_a(1.5f, 20.0f);
    public static final BuildingBlockObject driedClay = BLOCKS.registerBuilding("dried_clay", DRIED_CLAY, HIDDEN_BLOCK_ITEM);
    public static final BuildingBlockObject driedClayBricks = BLOCKS.registerBuilding("dried_clay_bricks", DRIED_CLAY, HIDDEN_BLOCK_ITEM);
    public static final ItemObject<GlassBlock> clearGlass = BLOCKS.register("clear_glass", () -> new GlassBlock(GENERIC_GLASS_BLOCK), GENERAL_BLOCK_ITEM);
    public static final ItemObject<ClearGlassPaneBlock> clearGlassPane = BLOCKS.register("clear_glass_pane", () -> new ClearGlassPaneBlock(GENERIC_GLASS_BLOCK), GENERAL_BLOCK_ITEM);
    public static final EnumObject<ClearStainedGlassBlock.GlassColor, ClearStainedGlassBlock> clearStainedGlass = BLOCKS.registerEnum(ClearStainedGlassBlock.GlassColor.values(), "clear_stained_glass", color -> new ClearStainedGlassBlock(GENERIC_GLASS_BLOCK, (ClearStainedGlassBlock.GlassColor)((Object)color)), GENERAL_BLOCK_ITEM);
    public static final EnumObject<ClearStainedGlassBlock.GlassColor, ClearStainedGlassPaneBlock> clearStainedGlassPane = BLOCKS.registerEnum(ClearStainedGlassBlock.GlassColor.values(), "clear_stained_glass_pane", color -> new ClearStainedGlassPaneBlock(GENERIC_GLASS_BLOCK, (ClearStainedGlassBlock.GlassColor)((Object)color)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<GlassBlock> soulGlass = BLOCKS.register("soul_glass", () -> new GlassBlock(GENERIC_GLASS_BLOCK), GENERAL_BLOCK_ITEM);
    public static final ItemObject<ClearGlassPaneBlock> soulGlassPane = BLOCKS.register("soul_glass_pane", () -> new ClearGlassPaneBlock(GENERIC_GLASS_BLOCK), GENERAL_BLOCK_ITEM);
    private static final AbstractBlock.Properties WOOD = TinkerCommons.builder(Material.field_151575_d, ToolType.AXE, SoundType.field_185848_a).func_235861_h_().func_200948_a(2.0f, 7.0f).func_235838_a_(s -> 7);
    public static final BuildingBlockObject lavawood = BLOCKS.registerBuilding("lavawood", WOOD, GENERAL_BLOCK_ITEM);
    public static final BuildingBlockObject blazewood = BLOCKS.registerBuilding("blazewood", WOOD, GENERAL_BLOCK_ITEM);
    public static final ItemObject<EdibleItem> bacon = ITEMS.register("bacon", () -> new EdibleItem(TinkerFood.BACON, TAB_GENERAL));
    private static final Item.Properties BOOK = new Item.Properties().func_200916_a(TAB_GENERAL).func_200917_a(1);
    public static final ItemObject<TinkerBookItem> materialsAndYou = ITEMS.register("materials_and_you", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.MATERIALS_AND_YOU));
    public static final ItemObject<TinkerBookItem> punySmelting = ITEMS.register("puny_smelting", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.PUNY_SMELTING));
    public static final ItemObject<TinkerBookItem> mightySmelting = ITEMS.register("mighty_smelting", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.MIGHTY_SMELTING));
    public static final ItemObject<TinkerBookItem> tinkersGadgetry = ITEMS.register("tinkers_gadgetry", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.TINKERS_GADGETRY));
    public static final ItemObject<Item> driedBrick = ITEMS.register("dried_brick", HIDDEN_PROPS);
    public static LootConditionType lootConfig;
    public static LootConditionType lootBlockOrEntity;
    public static final EnumObject<SlimeType, Item> slimeball;

    public TinkerCommons() {
        MinecraftForge.EVENT_BUS.addListener(RecipeCacheInvalidator::onReloadListenerReload);
    }

    @SubscribeEvent
    void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((IConditionSerializer)ConfigEnabledCondition.SERIALIZER);
        lootConfig = (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)ConfigEnabledCondition.ID, (Object)new LootConditionType((ILootSerializer)ConfigEnabledCondition.SERIALIZER));
        lootBlockOrEntity = (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)BlockOrEntityCondition.ID, (Object)new LootConditionType((ILootSerializer)BlockOrEntityCondition.SERIALIZER));
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.func_200390_a((IDataProvider)new CommonRecipeProvider(datagenerator));
        }
    }

    static {
        slimeball = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, (Supplier)Items.field_151123_aH.delegate).putAll(ITEMS.registerEnum(SlimeType.TINKER, "slime_ball", type -> new EdibleItem(type.getSlimeFood((SlimeType)((Object)type)), TAB_GENERAL))).build();
    }
}

