/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.IDisplayModifierRecipe;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientRenderer;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipeCategory
implements IRecipeCategory<IDisplayModifierRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = Util.getResource("textures/gui/jei/tinker_station.png");
    private static final String KEY_TITLE = Util.makeTranslationKey("jei", "modifiers.title");
    private static final List<ITextComponent> TEXT_FREE = Collections.singletonList(Util.makeTranslation("jei", "modifiers.free"));
    private static final List<ITextComponent> TEXT_SINGLE_UPGRADE = Collections.singletonList(Util.makeTranslation("jei", "modifiers.upgrade"));
    private static final List<ITextComponent> TEXT_INCREMENTAL = Collections.singletonList(Util.makeTranslation("jei", "modifiers.incremental"));
    private static final String KEY_UPGRADES = Util.makeTranslationKey("jei", "modifiers.upgrades");
    private static final List<ITextComponent> TEXT_SINGLE_ABILITY = Collections.singletonList(Util.makeTranslation("jei", "modifiers.ability"));
    private static final String KEY_ABILITIES = Util.makeTranslationKey("jei", "modifiers.abilities");
    private static final String KEY_MAX = Util.makeTranslationKey("jei", "modifiers.max");
    private final ModifierIngredientRenderer modifierRenderer = new ModifierIngredientRenderer(124);
    private final IDrawable background;
    private final IDrawable icon;
    private final String title = ForgeI18n.getPattern((String)KEY_TITLE);
    private final String maxPrefix = ForgeI18n.getPattern((String)KEY_MAX);
    private final IDrawable requirements;
    private final IDrawable incremental;
    private final IDrawable[] slotIcons;
    private final IDrawable slotUpgrade;
    private final IDrawable slotAbility;
    private final IDrawable slotFree;

    public ModifierRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 128, 77);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack(TinkerModifiers.creativeUpgradeItem));
        this.slotIcons = new IDrawable[6];
        for (int i = 0; i < 6; ++i) {
            this.slotIcons[i] = helper.createDrawable(BACKGROUND_LOC, 128 + i * 16, 0, 16, 16);
        }
        this.requirements = helper.createDrawable(BACKGROUND_LOC, 128, 17, 16, 16);
        this.incremental = helper.createDrawable(BACKGROUND_LOC, 128, 33, 16, 16);
        this.slotUpgrade = helper.createDrawable(BACKGROUND_LOC, 144, 17, 8, 8);
        this.slotAbility = helper.createDrawable(BACKGROUND_LOC, 152, 17, 8, 8);
        this.slotFree = helper.createDrawable(BACKGROUND_LOC, 160, 17, 8, 8);
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.modifiers;
    }

    public Class<? extends IDisplayModifierRecipe> getRecipeClass() {
        return IDisplayModifierRecipe.class;
    }

    public void setIngredients(IDisplayModifierRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getDisplayItems());
        ingredients.setOutput(JEIPlugin.MODIFIER_TYPE, (Object)recipe.getDisplayResult());
    }

    private void drawSlot(MatrixStack matrices, List<List<ItemStack>> inputs, int slot, int x, int y) {
        if (slot >= inputs.size() || inputs.get(slot).isEmpty()) {
            this.slotIcons[slot - 1].draw(matrices, x + 1, y + 1);
        }
    }

    public void draw(IDisplayModifierRecipe recipe, MatrixStack matrices, double mouseX, double mouseY) {
        IDrawable icon;
        List<List<ItemStack>> inputs = recipe.getDisplayItems();
        this.drawSlot(matrices, inputs, 2, 2, 32);
        this.drawSlot(matrices, inputs, 3, 24, 14);
        this.drawSlot(matrices, inputs, 4, 46, 32);
        this.drawSlot(matrices, inputs, 5, 42, 57);
        this.drawSlot(matrices, inputs, 6, 6, 57);
        if (recipe.hasRequirements()) {
            this.requirements.draw(matrices, 66, 58);
        }
        if (recipe.isIncremental()) {
            this.incremental.draw(matrices, 83, 59);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int max = recipe.getMaxLevel();
        if (max > 0) {
            fontRenderer.func_238421_b_(matrices, this.maxPrefix + max, 66.0f, 16.0f, Color.GRAY.getRGB());
        }
        int upgrades = recipe.getUpgradeSlots();
        int abilities = recipe.getAbilitySlots();
        String text = null;
        if (abilities > 0) {
            icon = this.slotAbility;
            text = Integer.toString(abilities);
        } else if (upgrades > 0) {
            icon = this.slotUpgrade;
            text = Integer.toString(upgrades);
        } else {
            icon = this.slotFree;
        }
        icon.draw(matrices, 114, 61);
        if (text != null) {
            int x = 112 - fontRenderer.func_78256_a(text);
            fontRenderer.func_238421_b_(matrices, text, (float)x, 62.0f, Color.GRAY.getRGB());
        }
    }

    public List<ITextComponent> getTooltipStrings(IDisplayModifierRecipe recipe, double mouseX, double mouseY) {
        int checkX = (int)mouseX;
        int checkY = (int)mouseY;
        if (recipe.hasRequirements() && GuiUtil.isHovered(checkX, checkY, 66, 58, 16, 16)) {
            return Collections.singletonList(new TranslationTextComponent(recipe.getRequirementsError()));
        }
        if (recipe.isIncremental() && GuiUtil.isHovered(checkX, checkY, 83, 59, 16, 16)) {
            return TEXT_INCREMENTAL;
        }
        if (GuiUtil.isHovered(checkX, checkY, 98, 61, 24, 8)) {
            int upgrades = recipe.getUpgradeSlots();
            int abilities = recipe.getAbilitySlots();
            if (abilities > 0) {
                return abilities == 1 ? TEXT_SINGLE_ABILITY : Collections.singletonList(new TranslationTextComponent(KEY_ABILITIES, new Object[]{abilities}));
            }
            if (upgrades > 0) {
                return upgrades == 1 ? TEXT_SINGLE_UPGRADE : Collections.singletonList(new TranslationTextComponent(KEY_UPGRADES, new Object[]{upgrades}));
            }
            return TEXT_FREE;
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayout layout, IDisplayModifierRecipe recipe, IIngredients ingredients) {
        List<List<ItemStack>> allItems;
        IGuiIngredientGroup modifiers = layout.getIngredientsGroup(JEIPlugin.MODIFIER_TYPE);
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 104, 33);
        items.init(1, true, 24, 37);
        items.init(2, true, 2, 32);
        items.init(3, true, 24, 14);
        items.init(4, true, 46, 32);
        items.init(5, true, 42, 57);
        items.init(6, true, 6, 57);
        items.set(ingredients);
        IFocus focus = layout.getFocus(VanillaTypes.ITEM);
        if (focus != null && ((ItemStack)focus.getValue()).func_77973_b().func_206844_a(TinkerTags.Items.MULTIPART_TOOL) && (allItems = recipe.getDisplayItems()).size() >= 2) {
            Item item = ((ItemStack)focus.getValue()).func_77973_b();
            allItems.get(0).stream().filter(stack -> stack.func_77973_b() == item).findFirst().ifPresent(stack -> items.set(0, stack));
            allItems.get(1).stream().filter(stack -> stack.func_77973_b() == item).findFirst().ifPresent(stack -> items.set(1, stack));
        }
        modifiers.init(7, false, (IIngredientRenderer)this.modifierRenderer, 2, 2, 124, 10, 0, 0);
        modifiers.set(ingredients);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }
}

