/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.util.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingCategory
implements IRecipeCategory<MeltingRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = Util.getResource("textures/gui/jei/melting.png");
    private static final String KEY_TITLE = Util.makeTranslationKey("jei", "melting.title");
    private static final String KEY_COOLING_TIME = Util.makeTranslationKey("jei", "melting.time");
    private static final String KEY_TEMPERATURE = Util.makeTranslationKey("jei", "temperature");
    private static final String KEY_MULTIPLIER = Util.makeTranslationKey("jei", "melting.multiplier");
    private static final ITextComponent TOOLTIP_ORE = new TranslationTextComponent(Util.makeTranslationKey("jei", "melting.ore"));
    private static final ITextComponent SOLID_TEMPERATURE = new TranslationTextComponent(KEY_TEMPERATURE, new Object[]{800}).func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent SOLID_MULTIPLIER = new TranslationTextComponent(KEY_MULTIPLIER, new Object[]{Float.valueOf(0.8f)}).func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent TOOLTIP_SMELTERY = Util.makeTranslation("jei", "melting.smeltery").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.UNDERLINE});
    private static final ITextComponent TOOLTIP_MELTER = Util.makeTranslation("jei", "melting.melter").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.UNDERLINE});
    private static final ITooltipCallback<ItemStack> ITEM_TOOLTIP = (index, isInput, stack, list) -> {
        if (index == 1) {
            list.add(1, SOLID_TEMPERATURE);
            list.add(2, SOLID_MULTIPLIER);
        }
    };
    private static final ITooltipCallback<FluidStack> FLUID_TOOLTIP = new MeltingFluidCallback(false);
    private static final ITooltipCallback<FluidStack> ORE_FLUID_TOOLTIP = new MeltingFluidCallback(true);
    private final String title;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic tankOverlay;
    private final IDrawableStatic plus;
    private final IDrawableStatic solidFuel;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public MeltingCategory(final IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 132, 40);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack(TinkerSmeltery.searedMelter));
        this.title = ForgeI18n.getPattern((String)KEY_TITLE);
        this.tankOverlay = helper.createDrawable(BACKGROUND_LOC, 132, 0, 32, 32);
        this.plus = helper.drawableBuilder(BACKGROUND_LOC, 132, 34, 6, 6).build();
        this.solidFuel = helper.drawableBuilder(BACKGROUND_LOC, 164, 0, 18, 20).build();
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer meltingTime) {
                return helper.drawableBuilder(BACKGROUND_LOC, 150, 41, 24, 17).buildAnimated(meltingTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.melting;
    }

    public Class<? extends MeltingRecipe> getRecipeClass() {
        return MeltingRecipe.class;
    }

    public void setIngredients(MeltingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutputLists(VanillaTypes.FLUID, recipe.getDisplayOutput());
    }

    public void draw(MeltingRecipe recipe, MatrixStack matrices, double mouseX, double mouseY) {
        int temperature;
        ((IDrawableAnimated)this.cachedArrows.getUnchecked((Object)(recipe.getTime() * 5))).draw(matrices, 56, 18);
        if (recipe.isOre()) {
            this.plus.draw(matrices, 87, 31);
        }
        if ((temperature = recipe.getTemperature()) <= 800) {
            this.solidFuel.draw(matrices, 1, 19);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String tempString = I18n.func_135052_a((String)KEY_TEMPERATURE, (Object[])new Object[]{temperature});
        int x = 56 - fontRenderer.func_78256_a(tempString) / 2;
        fontRenderer.func_238421_b_(matrices, tempString, (float)x, 3.0f, Color.GRAY.getRGB());
    }

    public List<ITextComponent> getTooltipStrings(MeltingRecipe recipe, double mouseXD, double mouseYD) {
        int mouseX = (int)mouseXD;
        int mouseY = (int)mouseYD;
        if (recipe.isOre() && GuiUtil.isHovered(mouseX, mouseY, 87, 31, 16, 16)) {
            return Collections.singletonList(TOOLTIP_ORE);
        }
        if (GuiUtil.isHovered(mouseX, mouseY, 56, 18, 24, 17)) {
            return Collections.singletonList(new TranslationTextComponent(KEY_COOLING_TIME, new Object[]{recipe.getTime() / 4}));
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayout layout, MeltingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 23, 17);
        items.set(ingredients);
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        fluids.init(0, false, 96, 4, 32, 32, 1296, false, (IDrawable)this.tankOverlay);
        fluids.set(ingredients);
        int fluidHeight = 32;
        if (recipe.getTemperature() <= 800) {
            fluidHeight = 15;
            items.init(1, true, 1, 21);
            items.set(1, (List)MeltingFuelHandler.SOLID_FUELS.get());
            items.addTooltipCallback(ITEM_TOOLTIP);
        }
        fluids.init(1, true, 4, 4, 12, fluidHeight, 1, false, null);
        fluids.set(1, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
        fluids.addTooltipCallback(recipe.isOre() ? ORE_FLUID_TOOLTIP : FLUID_TOOLTIP);
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public static class MeltingFluidCallback
    implements ITooltipCallback<FluidStack> {
        private final boolean isOre;

        public void onTooltip(int index, boolean input, FluidStack stack, List<ITextComponent> list) {
            ITextComponent name = list.get(0);
            ITextComponent modId = list.get(list.size() - 1);
            list.clear();
            list.add(name);
            if (index == 0) {
                if (this.isOre) {
                    list.add(TOOLTIP_SMELTERY);
                    boolean shift = FluidTooltipHandler.appendMaterialNoShift(stack.getFluid(), IMeltingInventory.applyOreBoost(stack.getAmount(), (Integer)Config.COMMON.smelteryNuggetsPerOre.get()), list);
                    list.add(StringTextComponent.field_240750_d_);
                    list.add(TOOLTIP_MELTER);
                    boolean bl = shift = FluidTooltipHandler.appendMaterialNoShift(stack.getFluid(), IMeltingInventory.applyOreBoost(stack.getAmount(), (Integer)Config.COMMON.melterNuggetsPerOre.get()), list) || shift;
                    if (shift) {
                        FluidTooltipHandler.appendShift(list);
                    }
                } else {
                    FluidTooltipHandler.appendMaterial(stack, list);
                }
            }
            if (index == 1) {
                MeltingFuelHandler.getTemperature(stack.getFluid()).ifPresent(temperature -> {
                    list.add((ITextComponent)new TranslationTextComponent(KEY_TEMPERATURE, new Object[]{temperature}).func_240699_a_(TextFormatting.GRAY));
                    list.add((ITextComponent)new TranslationTextComponent(KEY_MULTIPLIER, new Object[]{Float.valueOf((float)temperature / 1000.0f)}).func_240699_a_(TextFormatting.GRAY));
                });
            }
            list.add(modId);
        }

        public MeltingFluidCallback(boolean isOre) {
            this.isOre = isOre;
        }
    }
}

