/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.recipe.modifiers.BeheadingRecipe;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientHelper;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.small.BroadSwordTool;

public class BeheadingCategory
implements IRecipeCategory<BeheadingRecipe> {
    public static final ResourceLocation BACKGROUND_LOC = Util.getResource("textures/gui/jei/tinker_station.png");
    private static final String KEY_TITLE = Util.makeTranslationKey("jei", "beheading.title");
    private final EntityIngredientRenderer entityRenderer = new EntityIngredientRenderer(32);
    private final IDrawable background;
    private final IDrawable icon;
    private final String title = ForgeI18n.getPattern((String)KEY_TITLE);

    public BeheadingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 78, 100, 38);
        this.icon = helper.createDrawableIngredient((Object)((BroadSwordTool)TinkerTools.cleaver.get()).buildToolForRendering());
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.beheading;
    }

    public Class<? extends BeheadingRecipe> getRecipeClass() {
        return BeheadingRecipe.class;
    }

    public void setIngredients(BeheadingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(JEIPlugin.ENTITY_TYPE, recipe.getDisplayInputs());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout layout, BeheadingRecipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup entityTypes = layout.getIngredientsGroup(JEIPlugin.ENTITY_TYPE);
        entityTypes.init(0, true, (IIngredientRenderer)this.entityRenderer, 3, 3, 32, 32, 0, 0);
        entityTypes.set(ingredients);
        EntityIngredientHelper.setFocus(layout, (IGuiIngredientGroup<EntityType>)entityTypes, recipe.getInputs(), 0);
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(1, false, 75, 10);
        items.set(ingredients);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }
}

