/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MoldingRecipeCategory
implements IRecipeCategory<MoldingRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = Util.getResource("textures/gui/jei/casting.png");
    private static final String KEY_TITLE = Util.makeTranslationKey("jei", "molding.title");
    private static final ITextComponent TOOLTIP_PATTERN_CONSUMED = new TranslationTextComponent(Util.makeTranslationKey("jei", "molding.pattern_consumed"));
    private final IDrawable background;
    private final IDrawable icon;
    private final String title = ForgeI18n.getPattern((String)KEY_TITLE);
    private final IDrawable table;
    private final IDrawable basin;
    private final IDrawable downArrow;
    private final IDrawable upArrow;

    public MoldingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 55, 70, 57);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)TinkerSmeltery.blankCast.getSand()));
        this.table = helper.createDrawable(BACKGROUND_LOC, 117, 0, 16, 16);
        this.basin = helper.createDrawable(BACKGROUND_LOC, 117, 16, 16, 16);
        this.downArrow = helper.createDrawable(BACKGROUND_LOC, 70, 55, 6, 6);
        this.upArrow = helper.createDrawable(BACKGROUND_LOC, 76, 55, 6, 6);
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.molding;
    }

    public Class<? extends MoldingRecipe> getRecipeClass() {
        return MoldingRecipe.class;
    }

    public void draw(MoldingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IDrawable block = recipe.func_222127_g() == RecipeTypes.MOLDING_BASIN ? this.basin : this.table;
        block.draw(matrixStack, 3, 40);
        if (!recipe.getPattern().func_203189_d()) {
            block.draw(matrixStack, 51, 40);
            this.downArrow.draw(matrixStack, 8, 17);
        } else {
            this.upArrow.draw(matrixStack, 8, 17);
        }
    }

    public List<ITextComponent> getTooltipStrings(MoldingRecipe recipe, double mouseX, double mouseY) {
        if (recipe.isPatternConsumed() && !recipe.getPattern().func_203189_d() && GuiUtil.isHovered((int)mouseX, (int)mouseY, 50, 7, 18, 18)) {
            return Collections.singletonList(TOOLTIP_PATTERN_CONSUMED);
        }
        return Collections.emptyList();
    }

    public void setIngredients(MoldingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout layout, MoldingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 2, 23);
        guiItemStacks.init(1, false, 50, 23);
        if (!recipe.getPattern().func_203189_d()) {
            guiItemStacks.init(2, true, 2, 0);
            guiItemStacks.set(ingredients);
            if (!recipe.isPatternConsumed()) {
                guiItemStacks.init(3, true, 50, 7);
                guiItemStacks.set(3, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
            }
        } else {
            guiItemStacks.set(ingredients);
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }
}

