/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.util.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipeCategory
implements IRecipeCategory<AlloyRecipe>,
ITooltipCallback<FluidStack> {
    private static final ResourceLocation BACKGROUND_LOC = Util.getResource("textures/gui/jei/alloy.png");
    private static final String KEY_TITLE = Util.makeTranslationKey("jei", "alloy.title");
    private static final String KEY_TEMPERATURE = Util.makeTranslationKey("jei", "temperature");
    private final IDrawable background;
    private final IDrawable icon;
    private final String title = ForgeI18n.getPattern((String)KEY_TITLE);
    private final IDrawable arrow;
    private final IDrawable tank;

    public AlloyRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 172, 62);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack(TinkerSmeltery.smelteryController));
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 172, 0, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tank = helper.createDrawable(BACKGROUND_LOC, 172, 17, 16, 16);
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.alloy;
    }

    public Class<? extends AlloyRecipe> getRecipeClass() {
        return AlloyRecipe.class;
    }

    public void setIngredients(AlloyRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, recipe.getDisplayInputs());
        ingredients.setInputIngredients((List)recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutput());
    }

    public void draw(AlloyRecipe recipe, MatrixStack matrices, double mouseX, double mouseY) {
        this.arrow.draw(matrices, 90, 21);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String tempString = I18n.func_135052_a((String)KEY_TEMPERATURE, (Object[])new Object[]{recipe.getTemperature()});
        int x = 102 - fontRenderer.func_78256_a(tempString) / 2;
        fontRenderer.func_238421_b_(matrices, tempString, (float)x, 5.0f, Color.GRAY.getRGB());
    }

    public void setRecipe(IRecipeLayout layout, AlloyRecipe recipe, IIngredients ingredients) {
        List<List<FluidStack>> inputs = recipe.getDisplayInputs();
        int maxAmount = recipe.getOutput().getAmount();
        for (List<FluidStack> inputList : inputs) {
            for (FluidStack input : inputList) {
                if (input.getAmount() <= maxAmount) continue;
                maxAmount = input.getAmount();
            }
        }
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        fluids.addTooltipCallback((ITooltipCallback)this);
        float width = 48.0f / (float)inputs.size();
        for (int i = 0; i < inputs.size(); ++i) {
            int x = 19 + (int)((float)i * width);
            int w = (int)((float)(i + 1) * width - (float)i * width);
            fluids.init(i + 2, true, x, 11, w, 32, maxAmount, false, null);
        }
        fluids.init(0, false, 137, 11, 16, 32, maxAmount, false, null);
        fluids.set(ingredients);
        fluids.init(1, true, 94, 43, 16, 16, 1, false, this.tank);
        fluids.set(1, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
    }

    public void onTooltip(int index, boolean input, FluidStack stack, List<ITextComponent> list) {
        Fluid fluid = stack.getFluid();
        if (fluid != null) {
            ITextComponent name = list.get(0);
            ITextComponent modId = list.get(list.size() - 1);
            list.clear();
            list.add(name);
            if (index != 1) {
                FluidTooltipHandler.appendMaterial(stack, list);
            } else {
                MeltingFuelHandler.getTemperature(stack.getFluid()).ifPresent(temperature -> list.add((ITextComponent)new TranslationTextComponent(KEY_TEMPERATURE, new Object[]{temperature}).func_240699_a_(TextFormatting.GRAY)));
            }
            list.add(modId);
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }
}

