/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class TooltipBuilder {
    private static final String KEY_FREE_UPGRADES = Util.makeTranslationKey("tooltip", "tool.upgrades");
    private static final String KEY_FREE_ABILITIES = Util.makeTranslationKey("tooltip", "tool.abilities");
    private static final String KEY_ATTACK_SPEED = Util.makeTranslationKey("stat", "attack_speed");
    private static final Color UPGRADE_COLOR = Color.func_240743_a_((int)-3360185);
    private static final Color ABILITY_COLOR = Color.func_240743_a_((int)-4677377);
    private static final Color ATTACK_SPEED_COLOR = Color.func_240743_a_((int)-8042548);
    private final ToolStack tool;
    private final List<ITextComponent> tooltips;

    public TooltipBuilder(ToolStack tool) {
        this.tool = tool;
        this.tooltips = new ArrayList<ITextComponent>();
    }

    public TooltipBuilder add(ITextComponent textComponent) {
        this.tooltips.add(textComponent);
        return this;
    }

    public TooltipBuilder addMiningSpeed() {
        this.tooltips.add(HeadMaterialStats.formatMiningSpeed(this.tool.getStats().getMiningSpeed()));
        return this;
    }

    public TooltipBuilder addHarvestLevel() {
        this.tooltips.add(HeadMaterialStats.formatHarvestLevel(this.tool.getStats().getHarvestLevel()));
        return this;
    }

    public TooltipBuilder addDurability() {
        this.tooltips.add(HeadMaterialStats.formatDurability(this.tool.getCurrentDurability(), this.tool.getStats().getDurability(), false));
        return this;
    }

    public TooltipBuilder addAttackDamage() {
        float attack = ToolAttackUtil.getActualDamage(this.tool, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
        this.tooltips.add(HeadMaterialStats.formatAttack(attack));
        return this;
    }

    public TooltipBuilder addAttackSpeed() {
        this.tooltips.add(BaseMaterialStats.formatNumber(KEY_ATTACK_SPEED, ATTACK_SPEED_COLOR, this.tool.getStats().getAttackSpeed()));
        return this;
    }

    public TooltipBuilder addFreeUpgrades() {
        int modifiers = this.tool.getFreeUpgrades();
        if (modifiers > 0) {
            this.tooltips.add(BaseMaterialStats.formatNumber(KEY_FREE_UPGRADES, UPGRADE_COLOR, modifiers));
        }
        return this;
    }

    public TooltipBuilder addFreeAbilities() {
        int abilities = this.tool.getFreeAbilities();
        if (abilities > 0) {
            this.tooltips.add(BaseMaterialStats.formatNumber(KEY_FREE_ABILITIES, ABILITY_COLOR, abilities));
        }
        return this;
    }

    public TooltipBuilder addModifierInfo(boolean advanced) {
        for (ModifierEntry entry : this.tool.getModifierList()) {
            if (!entry.getModifier().shouldDisplay(advanced)) continue;
            this.tooltips.add(entry.getModifier().getDisplayName(this.tool, entry.getLevel()));
        }
        return this;
    }

    public TooltipBuilder addDrawSpeed() {
        this.tooltips.add((ITextComponent)new StringTextComponent("TODO: implement getting draw speed"));
        return this;
    }

    public TooltipBuilder addRange() {
        this.tooltips.add((ITextComponent)new StringTextComponent("TODO: implement getting range"));
        return this;
    }

    public TooltipBuilder(ToolStack tool, List<ITextComponent> tooltips) {
        this.tool = tool;
        this.tooltips = tooltips;
    }

    public List<ITextComponent> getTooltips() {
        return this.tooltips;
    }
}

