/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.BlockPos;

public final class TagUtil {
    public static int TAG_TYPE_STRING = StringNBT.func_229705_a_((String)"").func_74732_a();
    public static int TAG_TYPE_COMPOUND = new CompoundNBT().func_74732_a();

    @Deprecated
    public static CompoundNBT getTagSafe(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o()) {
            return new CompoundNBT();
        }
        return stack.func_77978_p();
    }

    @Deprecated
    public static CompoundNBT getTagSafe(CompoundNBT tag, String key) {
        if (tag == null) {
            return new CompoundNBT();
        }
        return tag.func_74775_l(key);
    }

    @Deprecated
    public static ListNBT getTagListSafe(CompoundNBT tag, String key, int type) {
        if (tag == null) {
            return new ListNBT();
        }
        return tag.func_150295_c(key, type);
    }

    public static CompoundNBT getBaseTag(ItemStack stack) {
        return TagUtil.getBaseTag(TagUtil.getTagSafe(stack));
    }

    public static CompoundNBT getBaseTag(CompoundNBT root) {
        return TagUtil.getTagSafe(root, "TinkerData");
    }

    public static void setBaseTag(ItemStack stack, CompoundNBT tag) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseTag(root, tag);
        stack.func_77982_d(root);
    }

    public static void setBaseTag(CompoundNBT root, CompoundNBT tag) {
        if (root != null) {
            root.func_218657_a("TinkerData", (INBT)tag);
        }
    }

    public static ListNBT getBaseModifiersTagList(ItemStack stack) {
        return TagUtil.getBaseModifiersTagList(TagUtil.getTagSafe(stack));
    }

    public static ListNBT getBaseModifiersTagList(CompoundNBT root) {
        return TagUtil.getTagListSafe(TagUtil.getBaseTag(root), "Modifiers", TAG_TYPE_STRING);
    }

    public static void setBaseModifiersTagList(ItemStack stack, ListNBT tagList) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseModifiersTagList(root, tagList);
        stack.func_77982_d(root);
    }

    public static void setBaseModifiersTagList(CompoundNBT root, ListNBT tagList) {
        CompoundNBT baseTag = TagUtil.getBaseTag(root);
        baseTag.func_218657_a("Modifiers", (INBT)tagList);
        TagUtil.setBaseTag(root, baseTag);
    }

    public static ListNBT getBaseMaterialsTagList(ItemStack stack) {
        return TagUtil.getBaseMaterialsTagList(TagUtil.getTagSafe(stack));
    }

    public static ListNBT getBaseMaterialsTagList(CompoundNBT root) {
        return TagUtil.getTagListSafe(TagUtil.getBaseTag(root), "Materials", TAG_TYPE_STRING);
    }

    public static void setBaseMaterialsTagList(ItemStack stack, ListNBT tagList) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setBaseMaterialsTagList(root, tagList);
        stack.func_77982_d(root);
    }

    public static void setBaseMaterialsTagList(CompoundNBT root, ListNBT tagList) {
        TagUtil.getBaseTag(root).func_218657_a("Materials", (INBT)tagList);
    }

    public static int getBaseModifiersUsed(CompoundNBT root) {
        return TagUtil.getBaseTag(root).func_74762_e("UsedModifiers");
    }

    public static void setBaseModifiersUsed(CompoundNBT root, int count) {
        TagUtil.getBaseTag(root).func_74768_a("UsedModifiers", count);
    }

    public static CompoundNBT getToolTag(ItemStack stack) {
        return TagUtil.getToolTag(TagUtil.getTagSafe(stack));
    }

    public static CompoundNBT getToolTag(CompoundNBT root) {
        return TagUtil.getTagSafe(root, "Stats");
    }

    public static void setToolTag(ItemStack stack, CompoundNBT tag) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setToolTag(root, tag);
        stack.func_77982_d(root);
    }

    public static void setToolTag(CompoundNBT root, CompoundNBT tag) {
        if (root != null) {
            root.func_218657_a("Stats", (INBT)tag);
        }
    }

    public static ListNBT getModifiersTagList(ItemStack stack) {
        return TagUtil.getModifiersTagList(TagUtil.getTagSafe(stack));
    }

    public static ListNBT getModifiersTagList(CompoundNBT root) {
        return TagUtil.getTagListSafe(root, "Modifiers", TAG_TYPE_COMPOUND);
    }

    public static void setModifiersTagList(ItemStack stack, ListNBT tagList) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setModifiersTagList(root, tagList);
        stack.func_77982_d(root);
    }

    public static void setModifiersTagList(CompoundNBT root, ListNBT tagList) {
        if (root != null) {
            root.func_218657_a("Modifiers", (INBT)tagList);
        }
    }

    public static ListNBT getTraitsTagList(ItemStack stack) {
        return TagUtil.getTraitsTagList(TagUtil.getTagSafe(stack));
    }

    public static ListNBT getTraitsTagList(CompoundNBT root) {
        return TagUtil.getTagListSafe(root, "Traits", TAG_TYPE_STRING);
    }

    public static void setTraitsTagList(ItemStack stack, ListNBT tagList) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setTraitsTagList(root, tagList);
        stack.func_77982_d(root);
    }

    public static void setTraitsTagList(CompoundNBT root, ListNBT tagList) {
        if (root != null) {
            root.func_218657_a("Traits", (INBT)tagList);
        }
    }

    public static CompoundNBT getExtraTag(ItemStack stack) {
        return TagUtil.getExtraTag(TagUtil.getTagSafe(stack));
    }

    public static CompoundNBT getExtraTag(CompoundNBT root) {
        return TagUtil.getTagSafe(root, "Special");
    }

    public static void setExtraTag(ItemStack stack, CompoundNBT tag) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setExtraTag(root, tag);
        stack.func_77982_d(root);
    }

    public static void setExtraTag(CompoundNBT root, CompoundNBT tag) {
        root.func_218657_a("Special", (INBT)tag);
    }

    public static void setEnchantEffect(ItemStack stack, boolean active) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setEnchantEffect(root, active);
        stack.func_77982_d(root);
    }

    public static void setEnchantEffect(CompoundNBT root, boolean active) {
        if (active) {
            root.func_74757_a("EnchantEffect", true);
        } else {
            root.func_82580_o("EnchantEffect");
        }
    }

    public static boolean hasEnchantEffect(ItemStack stack) {
        return TagUtil.hasEnchantEffect(TagUtil.getTagSafe(stack));
    }

    public static boolean hasEnchantEffect(CompoundNBT root) {
        return root.func_74767_n("EnchantEffect");
    }

    public static void setResetFlag(ItemStack stack, boolean active) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        root.func_74757_a("ResetFlag", active);
        stack.func_77982_d(root);
    }

    public static boolean getResetFlag(ItemStack stack) {
        return TagUtil.getTagSafe(stack).func_74767_n("ResetFlag");
    }

    public static void setNoRenameFlag(ItemStack stack, boolean active) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        TagUtil.setNoRenameFlag(root, active);
        stack.func_77982_d(root);
    }

    public static void setNoRenameFlag(CompoundNBT root, boolean active) {
        CompoundNBT displayTag = root.func_74775_l("display");
        if (displayTag.func_74764_b("Name")) {
            displayTag.func_74757_a("NoRename", active);
            root.func_218657_a("display", (INBT)displayTag);
        }
    }

    public static boolean getNoRenameFlag(ItemStack stack) {
        CompoundNBT root = TagUtil.getTagSafe(stack);
        CompoundNBT displayTag = root.func_74775_l("display");
        return displayTag.func_74767_n("NoRename");
    }

    public static CompoundNBT writePos(BlockPos pos) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        return tag;
    }

    @Nullable
    public static BlockPos readPos(CompoundNBT tag) {
        if (tag.func_150297_b("x", 99) && tag.func_150297_b("y", 99) && tag.func_150297_b("z", 99)) {
            return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        }
        return null;
    }

    @Nullable
    public static BlockPos readPos(CompoundNBT parent, String key) {
        if (parent.func_150297_b(key, 10)) {
            return TagUtil.readPos(parent.func_74775_l(key));
        }
        return null;
    }

    private TagUtil() {
    }
}

