/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.traits.json;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.traits.TraitId;

public class TraitMappingJson {
    private final ResourceLocation materialId;
    @SerializedName(value="default")
    private final List<ResourceLocation> defaultTraits;
    private final Map<ResourceLocation, List<ResourceLocation>> perStat;

    public TraitMappingJson(ResourceLocation materialId, List<ResourceLocation> defaultTraits, Map<ResourceLocation, List<ResourceLocation>> perStat) {
        this.materialId = materialId;
        this.defaultTraits = defaultTraits;
        this.perStat = perStat;
    }

    @Nullable
    public MaterialId getMaterialId() {
        return this.materialId != null ? new MaterialId(this.materialId) : null;
    }

    public List<TraitId> getDefaultTraits() {
        return this.transformTraitIds(this.defaultTraits);
    }

    public Map<MaterialStatsId, List<TraitId>> getPerStat() {
        if (this.perStat == null) {
            return Collections.emptyMap();
        }
        return this.perStat.entrySet().stream().collect(Collectors.toMap(entry -> new MaterialStatsId((ResourceLocation)entry.getKey()), entry -> this.transformTraitIds((List)entry.getValue())));
    }

    private List<TraitId> transformTraitIds(@Nullable List<ResourceLocation> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(TraitId::new).collect(Collectors.toList());
    }
}

