/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.traits;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.exception.TinkerJSONException;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.traits.TraitId;
import slimeknights.tconstruct.library.traits.json.TraitMappingJson;

public class MaterialTraitsManager
extends JsonReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialTraitsManager.class);
    @VisibleForTesting
    protected static final String FOLDER = "materials/traits";
    @VisibleForTesting
    protected static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private Map<MaterialId, List<TraitId>> materialDefaultTraits = ImmutableMap.of();
    private Map<MaterialId, Map<MaterialStatsId, List<TraitId>>> materialToTraitsPerStatsType = ImmutableMap.of();

    public MaterialTraitsManager() {
        super(GSON, FOLDER);
    }

    public List<TraitId> getDefaultTraits(MaterialId materialId) {
        return this.materialDefaultTraits.getOrDefault((Object)materialId, Collections.emptyList());
    }

    public List<TraitId> getTraitsForStats(MaterialId materialId, MaterialStatsId statId) {
        return this.materialToTraitsPerStatsType.getOrDefault((Object)materialId, Collections.emptyMap()).getOrDefault((Object)statId, Collections.emptyList());
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        List<TraitMappingJson> parsedSplashList = this.parseSplashlist(splashList);
        this.materialDefaultTraits = parsedSplashList.stream().collect(Collectors.toMap(TraitMappingJson::getMaterialId, TraitMappingJson::getDefaultTraits, this::concatLists));
        this.materialToTraitsPerStatsType = parsedSplashList.stream().collect(Collectors.toMap(TraitMappingJson::getMaterialId, TraitMappingJson::getPerStat, this::combineMaps));
        this.materialToTraitsPerStatsType.forEach((materialId, traitsMap) -> log.debug("Loaded traits for material '{}': \n\tDefault - {}{}", (Object)materialId, (Object)Arrays.toString(this.materialDefaultTraits.getOrDefault(materialId, Collections.emptyList()).toArray()), (Object)Util.toIndentedStringList(traitsMap.entrySet().stream().map(entry -> String.format("%s - %s", entry.getKey(), Arrays.toString(((List)entry.getValue()).toArray()))).collect(Collectors.toList()))));
    }

    private Map<MaterialStatsId, List<TraitId>> combineMaps(Map<MaterialStatsId, List<TraitId>> materialStatsIdListMap, Map<MaterialStatsId, List<TraitId>> materialStatsIdListMap2) {
        return Stream.concat(materialStatsIdListMap.keySet().stream(), materialStatsIdListMap2.keySet().stream()).distinct().collect(Collectors.toMap(materialStatsId -> materialStatsId, materialStatsId -> this.concatLists(materialStatsIdListMap.getOrDefault(materialStatsId, Collections.emptyList()), materialStatsIdListMap2.getOrDefault(materialStatsId, Collections.emptyList()))));
    }

    private List<TraitMappingJson> parseSplashlist(Map<ResourceLocation, JsonElement> splashList) {
        return splashList.entrySet().stream().map(this::parseJsonEntry).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> List<T> concatLists(List<T> list1, List<T> list2) {
        return Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
    }

    @Nullable
    private TraitMappingJson parseJsonEntry(Map.Entry<ResourceLocation, JsonElement> entry) {
        if (!entry.getValue().isJsonObject()) {
            return null;
        }
        try {
            TraitMappingJson traitMappingJson = (TraitMappingJson)GSON.fromJson(entry.getValue(), TraitMappingJson.class);
            if (traitMappingJson.getMaterialId() == null) {
                throw TinkerJSONException.materialTraitsJsonWithoutMaterial(entry.getKey());
            }
            return traitMappingJson;
        }
        catch (Exception e) {
            log.error("Could not deserialize material trait mapping from file {}. JSON: {}", (Object)entry.getKey(), (Object)entry.getValue(), (Object)e);
            return null;
        }
    }
}

