/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.modifier.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.ToolBaseStatDefinition;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class ToolStack
implements IModifierToolStack {
    private static final ValidatedResult VALIDATE_UPGRADES = ValidatedResult.failure(Util.makeTranslationKey("recipe", "modifier.validate_upgrades"), new Object[0]);
    private static final ValidatedResult VALIDATE_ABILITIES = ValidatedResult.failure(Util.makeTranslationKey("recipe", "modifier.validate_abilities"), new Object[0]);
    public static final ResourceLocation ORIGINAL_DURABILITY_KEY = Util.getResource("durability");
    protected static final String TAG_MATERIALS = "tic_materials";
    protected static final String TAG_STATS = "tic_stats";
    public static final String TAG_PERSISTENT_MOD_DATA = "tic_persistent_data";
    public static final String TAG_VOLATILE_MOD_DATA = "tic_volatile_data";
    protected static final String TAG_UPGRADES = "tic_upgrades";
    public static final String TAG_MODIFIERS = "tic_modifiers";
    public static final String TAG_BROKEN = "tic_broken";
    protected static final String TAG_DAMAGE = "Damage";
    public static final String TAG_UNBREAKABLE = "Unbreakable";
    private static final String TAG_ID = "id";
    private static final String TAG_LEVEL = "lvl";
    private final Item item;
    private final ToolDefinition definition;
    private final CompoundNBT nbt;
    private int damage = -1;
    @Nullable
    private Boolean broken;
    @Nullable
    private MaterialNBT materials;
    @Nullable
    private ModifierNBT upgrades;
    @Nullable
    private ModDataNBT persistentModData;
    @Nullable
    private ModifierNBT modifiers;
    @Nullable
    private StatsNBT stats;
    @Nullable
    private IModDataReadOnly volatileModData;

    private static ToolStack from(ItemStack stack, boolean copyNbt) {
        CompoundNBT nbt;
        Item item = stack.func_77973_b();
        ToolDefinition definition = ToolDefinition.EMPTY;
        if (item instanceof ToolCore) {
            definition = ((ToolCore)item).getToolDefinition();
        }
        if ((nbt = stack.func_77978_p()) == null) {
            nbt = new CompoundNBT();
            if (!copyNbt) {
                stack.func_77982_d(nbt);
            }
        } else if (copyNbt) {
            nbt = nbt.func_74737_b();
        }
        return ToolStack.from(item, definition, nbt);
    }

    public static ToolStack from(ItemStack stack) {
        return ToolStack.from(stack, false);
    }

    public static ToolStack copyFrom(ItemStack stack) {
        return ToolStack.from(stack, true);
    }

    public ToolStack copy() {
        ToolStack tool = ToolStack.from(this.item, this.definition, this.nbt.func_74737_b());
        tool.damage = this.damage;
        tool.broken = this.broken;
        tool.materials = this.materials;
        tool.upgrades = this.upgrades;
        tool.modifiers = this.modifiers;
        tool.stats = this.stats;
        return tool;
    }

    public void clearCache() {
        this.damage = -1;
        this.broken = null;
        this.materials = null;
        this.upgrades = null;
        this.modifiers = null;
        this.stats = null;
        this.volatileModData = null;
        this.persistentModData = null;
    }

    public static ToolStack createTool(Item item, ToolDefinition definition, List<IMaterial> materials) {
        ToolStack tool = ToolStack.from(item, definition, new CompoundNBT());
        tool.damage = 0;
        tool.broken = false;
        tool.upgrades = ModifierNBT.EMPTY;
        tool.setMaterials(materials);
        ToolBaseStatDefinition baseStats = definition.getBaseStatDefinition();
        ModDataNBT data = tool.getPersistentData();
        data.setUpgrades(baseStats.getDefaultUpgrades());
        data.setAbilities(baseStats.getDefaultAbilities());
        data.setTraits(baseStats.getDefaultTraits());
        return tool;
    }

    public ItemStack createStack() {
        ItemStack stack = new ItemStack((IItemProvider)this.item, 1);
        stack.func_77982_d(this.nbt);
        return stack;
    }

    public ItemStack updateStack(ItemStack stack) {
        if (stack.func_77973_b() != this.item) {
            throw new IllegalArgumentException("Wrong item in stack");
        }
        stack.func_77982_d(this.nbt.func_74737_b());
        return stack;
    }

    @Override
    public boolean isBroken() {
        if (this.broken == null) {
            this.broken = this.nbt.func_74767_n(TAG_BROKEN);
        }
        return this.broken;
    }

    @Override
    public boolean isUnbreakable() {
        return this.nbt.func_74767_n(TAG_UNBREAKABLE);
    }

    protected void setBrokenRaw(boolean broken) {
        this.broken = broken;
        this.nbt.func_74757_a(TAG_BROKEN, broken);
    }

    protected void breakTool() {
        this.setDamage(this.getStats().getDurability());
    }

    protected int getDamageRaw() {
        if (this.damage == -1) {
            this.damage = this.nbt.func_74762_e(TAG_DAMAGE);
        }
        return this.damage;
    }

    @Override
    public int getDamage() {
        if (this.isBroken()) {
            return this.getStats().getDurability();
        }
        return Math.min(this.getDamageRaw(), this.getStats().getDurability() - 1);
    }

    @Override
    public int getCurrentDurability() {
        if (this.isBroken()) {
            return 0;
        }
        return Math.max(0, this.getStats().getDurability() - this.getDamageRaw());
    }

    @Override
    public void setDamage(int damage) {
        int durability = this.getStats().getDurability();
        if (damage >= durability) {
            damage = Math.max(0, durability);
            this.setBrokenRaw(true);
        } else {
            this.setBrokenRaw(false);
        }
        this.damage = damage;
        this.nbt.func_74768_a(TAG_DAMAGE, damage);
    }

    @Override
    public StatsNBT getStats() {
        if (this.stats == null) {
            this.stats = StatsNBT.readFromNBT(this.nbt.func_74781_a(TAG_STATS));
        }
        return this.stats;
    }

    protected void setStats(StatsNBT stats) {
        this.stats = stats;
        this.nbt.func_218657_a(TAG_STATS, (INBT)stats.serializeToNBT());
        int newMax = stats.getDurability();
        if (this.getDamageRaw() >= newMax) {
            this.setDamage(newMax);
        }
    }

    @Override
    public MaterialNBT getMaterials() {
        if (this.materials == null) {
            this.materials = MaterialNBT.readFromNBT(this.nbt.func_74781_a(TAG_MATERIALS));
        }
        return this.materials;
    }

    protected void setMaterialsRaw(MaterialNBT materials) {
        this.materials = materials;
        this.nbt.func_218657_a(TAG_MATERIALS, (INBT)materials.serializeToNBT());
    }

    public void setMaterials(MaterialNBT materials) {
        this.setMaterialsRaw(materials);
        this.rebuildStats();
    }

    public void setMaterials(List<IMaterial> materials) {
        this.setMaterials(new MaterialNBT(materials));
    }

    public void replaceMaterial(int index, IMaterial replacement) {
        this.setMaterials(this.getMaterials().replaceMaterial(index, replacement));
    }

    public ModifierNBT getUpgrades() {
        if (this.upgrades == null) {
            this.upgrades = ModifierNBT.readFromNBT(this.nbt.func_74781_a(TAG_UPGRADES));
        }
        return this.upgrades;
    }

    public void addModifier(Modifier modifier, int level) {
        ModifierNBT newModifiers;
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.upgrades = newModifiers = this.getUpgrades().withModifier(modifier, level);
        this.nbt.func_218657_a(TAG_UPGRADES, (INBT)newModifiers.serializeToNBT());
        this.rebuildStats();
    }

    public void removeModifier(Modifier modifier, int level) {
        ModifierNBT newModifiers;
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.upgrades = newModifiers = this.getUpgrades().withoutModifier(modifier, level);
        this.nbt.func_218657_a(TAG_UPGRADES, (INBT)newModifiers.serializeToNBT());
        this.rebuildStats();
    }

    @Override
    public ModifierNBT getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = ModifierNBT.readFromNBT(this.nbt.func_74781_a(TAG_MODIFIERS));
        }
        return this.modifiers;
    }

    protected void setModifiers(ModifierNBT modifiers) {
        this.modifiers = modifiers;
        this.nbt.func_218657_a(TAG_MODIFIERS, (INBT)this.modifiers.serializeToNBT());
    }

    @Override
    public ModDataNBT getPersistentData() {
        if (this.persistentModData == null) {
            if (this.nbt.func_150297_b(TAG_PERSISTENT_MOD_DATA, 10)) {
                this.persistentModData = ModDataNBT.readFromNBT(this.nbt.func_74775_l(TAG_PERSISTENT_MOD_DATA));
            } else {
                CompoundNBT tag = new CompoundNBT();
                this.nbt.func_218657_a(TAG_PERSISTENT_MOD_DATA, (INBT)tag);
                this.persistentModData = ModDataNBT.readFromNBT(tag);
            }
        }
        return this.persistentModData;
    }

    @Override
    public IModDataReadOnly getVolatileData() {
        if (this.volatileModData == null) {
            this.volatileModData = this.nbt.func_150297_b(TAG_VOLATILE_MOD_DATA, 10) ? ModDataNBT.readFromNBT(this.nbt.func_74775_l(TAG_VOLATILE_MOD_DATA)) : IModDataReadOnly.EMPTY;
        }
        return this.volatileModData;
    }

    protected void setVolatileModData(ModDataNBT modData) {
        CompoundNBT data = modData.getData();
        if (data.isEmpty()) {
            this.volatileModData = IModDataReadOnly.EMPTY;
            this.nbt.func_82580_o(TAG_VOLATILE_MOD_DATA);
        } else {
            this.volatileModData = modData;
            this.nbt.func_218657_a(TAG_VOLATILE_MOD_DATA, (INBT)data);
        }
    }

    public ValidatedResult validate() {
        if (this.getFreeUpgrades() < 0) {
            return VALIDATE_UPGRADES;
        }
        if (this.getFreeAbilities() < 0) {
            return VALIDATE_ABILITIES;
        }
        List<ModifierEntry> mods = this.getModifierList();
        for (ModifierEntry entry : mods) {
            ValidatedResult result = entry.getModifier().validate(this, entry.getLevel());
            if (!result.hasError()) continue;
            return result;
        }
        return ModifierRecipeLookup.checkRequirements(this.getUpgrades().getModifiers(), mods);
    }

    public void rebuildStats() {
        List<IMaterial> materials = this.getMaterialsList();
        ModifierNBT.Builder modBuilder = ModifierNBT.builder();
        modBuilder.add(this.getUpgrades());
        modBuilder.add(this.getDefinition().getModifiers());
        for (IMaterial material : materials) {
            modBuilder.add(material.getTraits());
        }
        ModifierNBT allMods = modBuilder.build();
        this.setModifiers(allMods);
        StatsNBT stats = materials.isEmpty() ? StatsNBT.EMPTY : this.definition.buildStats(materials);
        ModifierStatsBuilder statBuilder = ModifierStatsBuilder.builder();
        this.definition.getBaseStatDefinition().buildStats(statBuilder);
        List<ModifierEntry> modifierList = allMods.getModifiers();
        if (modifierList.isEmpty()) {
            this.nbt.func_82580_o(TAG_VOLATILE_MOD_DATA);
            this.volatileModData = IModDataReadOnly.EMPTY;
        } else {
            ModDataNBT volatileData = new ModDataNBT();
            ModDataNBT persistentData = this.getPersistentData();
            ToolDefinition toolDefinition = this.getDefinition();
            for (ModifierEntry entry : modifierList) {
                entry.getModifier().addVolatileData(toolDefinition, stats, persistentData, entry.getLevel(), volatileData);
            }
            for (ModifierEntry entry : modifierList) {
                Modifier mod = entry.getModifier();
                int level = entry.getLevel();
                mod.addToolStats(toolDefinition, stats, persistentData, volatileData, level, statBuilder);
            }
            this.setVolatileModData(volatileData);
        }
        this.setStats(statBuilder.build(stats));
    }

    private ToolStack(Item item, ToolDefinition definition, CompoundNBT nbt) {
        this.item = item;
        this.definition = definition;
        this.nbt = nbt;
    }

    public static ToolStack from(Item item, ToolDefinition definition, CompoundNBT nbt) {
        return new ToolStack(item, definition, nbt);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public ToolDefinition getDefinition() {
        return this.definition;
    }

    protected CompoundNBT getNbt() {
        return this.nbt;
    }
}

