/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import slimeknights.tconstruct.library.utils.NBTUtil;

public class StatsNBT {
    static final StatsNBT EMPTY = new StatsNBT(1, 0, 1.0f, 1.0f, 1.0f, 5.0f);
    protected static final String TAG_DURABILITY = "durability";
    protected static final String TAG_ATTACK_DAMAGE = "attack";
    protected static final String TAG_ATTACK_SPEED = "attack_speed";
    protected static final String TAG_MINING_SPEED = "mining_speed";
    protected static final String TAG_HARVEST_LEVEL = "harvest_level";
    protected static final String TAG_REACH = "reach";
    private final int durability;
    private final int harvestLevel;
    private final float attackDamage;
    private final float miningSpeed;
    private final float attackSpeed;
    private final float reach;

    public static StatsNBT readFromNBT(@Nullable INBT inbt) {
        if (inbt == null || inbt.func_74732_a() != 10) {
            return EMPTY;
        }
        CompoundNBT nbt = (CompoundNBT)inbt;
        int durability = NBTUtil.getInt(nbt, TAG_DURABILITY, StatsNBT.EMPTY.durability);
        int harvestLevel = NBTUtil.getInt(nbt, TAG_HARVEST_LEVEL, StatsNBT.EMPTY.harvestLevel);
        float attack = NBTUtil.getFloat(nbt, TAG_ATTACK_DAMAGE, StatsNBT.EMPTY.attackDamage);
        float miningSpeed = NBTUtil.getFloat(nbt, TAG_MINING_SPEED, StatsNBT.EMPTY.miningSpeed);
        float attackSpeedMultiplier = NBTUtil.getFloat(nbt, TAG_ATTACK_SPEED, StatsNBT.EMPTY.attackSpeed);
        float reach = NBTUtil.getFloat(nbt, TAG_REACH, StatsNBT.EMPTY.reach);
        return new StatsNBT(durability, harvestLevel, attack, miningSpeed, attackSpeedMultiplier, reach);
    }

    public CompoundNBT serializeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(TAG_DURABILITY, this.durability);
        nbt.func_74768_a(TAG_HARVEST_LEVEL, this.harvestLevel);
        nbt.func_74776_a(TAG_ATTACK_DAMAGE, this.attackDamage);
        nbt.func_74776_a(TAG_MINING_SPEED, this.miningSpeed);
        nbt.func_74776_a(TAG_ATTACK_SPEED, this.attackSpeed);
        nbt.func_74776_a(TAG_REACH, this.reach);
        return nbt;
    }

    public static Builder builder() {
        return new Builder();
    }

    StatsNBT(int durability, int harvestLevel, float attackDamage, float miningSpeed, float attackSpeed, float reach) {
        this.durability = durability;
        this.harvestLevel = harvestLevel;
        this.attackDamage = attackDamage;
        this.miningSpeed = miningSpeed;
        this.attackSpeed = attackSpeed;
        this.reach = reach;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatsNBT)) {
            return false;
        }
        StatsNBT other = (StatsNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDurability() != other.getDurability()) {
            return false;
        }
        if (this.getHarvestLevel() != other.getHarvestLevel()) {
            return false;
        }
        if (Float.compare(this.getAttackDamage(), other.getAttackDamage()) != 0) {
            return false;
        }
        if (Float.compare(this.getMiningSpeed(), other.getMiningSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getAttackSpeed(), other.getAttackSpeed()) != 0) {
            return false;
        }
        return Float.compare(this.getReach(), other.getReach()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatsNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDurability();
        result = result * 59 + this.getHarvestLevel();
        result = result * 59 + Float.floatToIntBits(this.getAttackDamage());
        result = result * 59 + Float.floatToIntBits(this.getMiningSpeed());
        result = result * 59 + Float.floatToIntBits(this.getAttackSpeed());
        result = result * 59 + Float.floatToIntBits(this.getReach());
        return result;
    }

    public String toString() {
        return "StatsNBT(durability=" + this.getDurability() + ", harvestLevel=" + this.getHarvestLevel() + ", attackDamage=" + this.getAttackDamage() + ", miningSpeed=" + this.getMiningSpeed() + ", attackSpeed=" + this.getAttackSpeed() + ", reach=" + this.getReach() + ")";
    }

    public int getDurability() {
        return this.durability;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public float getReach() {
        return this.reach;
    }

    static /* synthetic */ int access$100(StatsNBT x0) {
        return x0.durability;
    }

    static /* synthetic */ int access$200(StatsNBT x0) {
        return x0.harvestLevel;
    }

    static /* synthetic */ float access$300(StatsNBT x0) {
        return x0.attackDamage;
    }

    static /* synthetic */ float access$400(StatsNBT x0) {
        return x0.miningSpeed;
    }

    static /* synthetic */ float access$500(StatsNBT x0) {
        return x0.attackSpeed;
    }

    static /* synthetic */ float access$600(StatsNBT x0) {
        return x0.reach;
    }

    public static class Builder {
        private int durability = StatsNBT.access$100(EMPTY);
        private int harvestLevel = StatsNBT.access$200(EMPTY);
        private float attackDamage = StatsNBT.access$300(EMPTY);
        private float miningSpeed = StatsNBT.access$400(EMPTY);
        private float attackSpeed = StatsNBT.access$500(EMPTY);
        private float reach = StatsNBT.access$600(EMPTY);

        public StatsNBT build() {
            return new StatsNBT(this.durability, this.harvestLevel, this.attackDamage, this.miningSpeed, this.attackSpeed, this.reach);
        }

        private Builder() {
        }

        public Builder durability(int durability) {
            this.durability = durability;
            return this;
        }

        public Builder harvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        public Builder attackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder miningSpeed(float miningSpeed) {
            this.miningSpeed = miningSpeed;
            return this;
        }

        public Builder attackSpeed(float attackSpeed) {
            this.attackSpeed = attackSpeed;
            return this;
        }

        public Builder reach(float reach) {
            this.reach = reach;
            return this;
        }
    }
}

