/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;

public class ModDataNBT
implements IModDataReadOnly {
    protected static final String TAG_UPGRADES = "upgrades";
    protected static final String TAG_ABILITIES = "abilities";
    protected static final String TAG_TRAITS = "traits";
    private final CompoundNBT data;
    private int upgrades;
    private int abilities;
    private int traits;

    public ModDataNBT() {
        this(new CompoundNBT(), 0, 0, 0);
    }

    public void setUpgrades(int value) {
        this.upgrades = value;
        this.data.func_74768_a(TAG_UPGRADES, value);
    }

    public void addUpgrades(int add) {
        if (add != 0) {
            this.setUpgrades(this.upgrades + add);
        }
    }

    public void setAbilities(int value) {
        this.abilities = value;
        this.data.func_74768_a(TAG_ABILITIES, value);
    }

    public void addAbilities(int add) {
        if (add != 0) {
            this.setAbilities(this.abilities + add);
        }
    }

    public void setTraits(int value) {
        this.traits = value;
        this.data.func_74768_a(TAG_TRAITS, value);
    }

    public void addTraits(int add) {
        if (add != 0) {
            this.setTraits(this.traits + add);
        }
    }

    @Override
    public <T> T get(ResourceLocation name, BiFunction<CompoundNBT, String, T> function) {
        return function.apply(this.data, name.toString());
    }

    @Override
    public boolean contains(ResourceLocation name, int type) {
        return this.data.func_150297_b(name.toString(), type);
    }

    public void put(ResourceLocation name, INBT nbt) {
        this.data.func_218657_a(name.toString(), nbt);
    }

    public void putInt(ResourceLocation name, int value) {
        this.data.func_74768_a(name.toString(), value);
    }

    public void putBoolean(ResourceLocation name, boolean value) {
        this.data.func_74757_a(name.toString(), value);
    }

    public void putFloat(ResourceLocation name, float value) {
        this.data.func_74776_a(name.toString(), value);
    }

    public void putString(ResourceLocation name, String value) {
        this.data.func_74778_a(name.toString(), value);
    }

    public void remove(ResourceLocation name) {
        this.data.func_82580_o(name.toString());
    }

    public static ModDataNBT readFromNBT(CompoundNBT data) {
        int upgrades = data.func_74762_e(TAG_UPGRADES);
        int abilities = data.func_74762_e(TAG_ABILITIES);
        int traits = data.func_74762_e(TAG_TRAITS);
        return new ModDataNBT(data, upgrades, abilities, traits);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModDataNBT)) {
            return false;
        }
        ModDataNBT other = (ModDataNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompoundNBT this$data = this.getData();
        CompoundNBT other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        if (this.getUpgrades() != other.getUpgrades()) {
            return false;
        }
        if (this.getAbilities() != other.getAbilities()) {
            return false;
        }
        return this.getTraits() == other.getTraits();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModDataNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompoundNBT $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + this.getUpgrades();
        result = result * 59 + this.getAbilities();
        result = result * 59 + this.getTraits();
        return result;
    }

    private ModDataNBT(CompoundNBT data, int upgrades, int abilities, int traits) {
        this.data = data;
        this.upgrades = upgrades;
        this.abilities = abilities;
        this.traits = traits;
    }

    protected CompoundNBT getData() {
        return this.data;
    }

    @Override
    public int getUpgrades() {
        return this.upgrades;
    }

    @Override
    public int getAbilities() {
        return this.abilities;
    }

    public int getTraits() {
        return this.traits;
    }
}

