/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;

public class MaterialNBT {
    static final MaterialNBT EMPTY = new MaterialNBT((List<IMaterial>)ImmutableList.of());
    private final List<IMaterial> materials;

    public MaterialNBT(List<IMaterial> materials) {
        this.materials = ImmutableList.copyOf(materials);
    }

    public IMaterial getMaterial(int index) {
        if (index >= this.materials.size() || index < 0) {
            return IMaterial.UNKNOWN;
        }
        return this.materials.get(index);
    }

    public MaterialNBT replaceMaterial(int index, IMaterial replacement) {
        int i;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Material index is out of bounds");
        }
        int size = this.materials.size();
        ArrayList<IMaterial> list = new ArrayList<IMaterial>(Math.max(size, index + 1));
        for (i = 0; i < size; ++i) {
            if (i == index) {
                list.add(replacement);
                continue;
            }
            list.add(this.materials.get(i));
        }
        if (index >= size) {
            for (i = size; i < index; ++i) {
                list.add(IMaterial.UNKNOWN);
            }
            list.add(replacement);
        }
        return new MaterialNBT(list);
    }

    public static MaterialNBT readFromNBT(@Nullable INBT nbt) {
        if (nbt == null || nbt.func_74732_a() != 9) {
            return EMPTY;
        }
        ListNBT listNBT = (ListNBT)nbt;
        if (listNBT.func_230528_d__() != 8) {
            return EMPTY;
        }
        List<IMaterial> materials = listNBT.stream().map(INBT::func_150285_a_).map(MaterialId::tryCreate).filter(Objects::nonNull).map(MaterialRegistry::getMaterial).collect(Collectors.toList());
        return new MaterialNBT(materials);
    }

    public ListNBT serializeToNBT() {
        return this.materials.stream().map(IMaterial::getIdentifier).map(ResourceLocation::toString).map(StringNBT::func_229705_a_).collect(Collectors.toCollection(ListNBT::new));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialNBT)) {
            return false;
        }
        MaterialNBT other = (MaterialNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IMaterial> this$materials = this.getMaterials();
        List<IMaterial> other$materials = other.getMaterials();
        return !(this$materials == null ? other$materials != null : !((Object)this$materials).equals(other$materials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IMaterial> $materials = this.getMaterials();
        result = result * 59 + ($materials == null ? 43 : ((Object)$materials).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialNBT(materials=" + this.getMaterials() + ")";
    }

    public List<IMaterial> getMaterials() {
        return this.materials;
    }
}

