/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.mantle.util.TranslationHelper;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.item.ToolCore;

public class ToolPartItem
extends MaterialItem
implements IToolPart {
    private static final ITextComponent MISSING_INFO = Util.makeTranslation("item", "part.missing_info");
    private static final String MISSING_MATERIAL_KEY = Util.makeTranslationKey("item", "part.missing_material");
    private static final String MISSING_STATS_KEY = Util.makeTranslationKey("item", "part.missing_stats");
    public final MaterialStatsId materialStatId;

    public ToolPartItem(Item.Properties properties, MaterialStatsId id) {
        super(properties);
        this.materialStatId = id;
    }

    @Override
    public boolean canUseMaterial(IMaterial material) {
        return MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), this.materialStatId).isPresent();
    }

    @Override
    public MaterialStatsId getStatType() {
        return this.materialStatId;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IMaterial material = this.getMaterial(stack);
        if (!this.checkMissingMaterialTooltip(stack, material, tooltip)) {
            for (ModifierEntry entry : material.getTraits()) {
                tooltip.add(entry.getModifier().getDisplayName(entry.getLevel()));
            }
        }
        if (((Boolean)Config.CLIENT.extraToolTips.get()).booleanValue()) {
            if (Util.isShiftKeyDown()) {
                this.addStatInfoTooltip(material, tooltip);
            } else {
                tooltip.add(StringTextComponent.field_240750_d_);
                tooltip.add(ToolCore.TOOLTIP_HOLD_SHIFT);
            }
        }
        ToolPartItem.addModTooltip(material, tooltip);
    }

    protected void addStatInfoTooltip(IMaterial material, List<ITextComponent> tooltip) {
        MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), this.materialStatId).ifPresent(stat -> {
            List<ITextComponent> text = stat.getLocalizedInfo();
            if (!text.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(""));
                tooltip.add((ITextComponent)stat.getLocalizedName().func_240701_a_(new TextFormatting[]{TextFormatting.WHITE, TextFormatting.UNDERLINE}));
                tooltip.addAll(stat.getLocalizedInfo());
            }
        });
    }

    protected boolean checkMissingMaterialTooltip(ItemStack stack, IMaterial material, List<ITextComponent> tooltip) {
        if (material == IMaterial.UNKNOWN) {
            Optional<MaterialId> materialId = this.getMaterialId(stack);
            if (materialId.isPresent()) {
                tooltip.add((ITextComponent)new TranslationTextComponent(MISSING_MATERIAL_KEY, new Object[]{materialId.get()}));
            } else {
                tooltip.add(MISSING_INFO);
            }
            return true;
        }
        if (!this.canUseMaterial(material)) {
            TranslationHelper.addEachLine((String)ForgeI18n.parseMessage((String)MISSING_STATS_KEY, (Object[])new Object[]{material.getTranslationKey(), this.materialStatId}), tooltip);
        }
        return false;
    }
}

