/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tinkering.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tinkering.IndestructibleEntityItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableHarvest;
import slimeknights.tconstruct.library.tools.item.IModifiableWeapon;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.library.utils.TooltipType;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public abstract class ToolCore
extends Item
implements ITinkerStationDisplay,
IModifiableWeapon,
IModifiableHarvest {
    protected static final UUID REACH_MODIFIER = UUID.fromString("9b26fa32-5774-4b4e-afc3-b4055ecb1f6a");
    public static final ResourceLocation INDESTRUCTIBLE_ENTITY = Util.getResource("indestructible");
    protected static final ITextComponent TOOLTIP_HOLD_SHIFT;
    private static final ITextComponent TOOLTIP_HOLD_CTRL;
    private final ToolDefinition toolDefinition;
    private ItemStack toolForRendering;

    protected ToolCore(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties);
        this.toolDefinition = toolDefinition;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return ToolStack.from(stack).getVolatileData().getBoolean(INDESTRUCTIBLE_ENTITY);
    }

    public Entity createEntity(World world, Entity original, ItemStack stack) {
        if (ToolStack.from(stack).getVolatileData().getBoolean(INDESTRUCTIBLE_ENTITY)) {
            IndestructibleEntityItem entity = new IndestructibleEntityItem(world, original.func_226277_ct_(), original.func_226278_cu_(), original.func_226281_cx_(), stack);
            entity.setPickupDelayFrom(original);
            return entity;
        }
        return null;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        int durability = tool.getStats().getDurability();
        return tool.isBroken() ? durability + 1 : durability;
    }

    public int getDamage(ItemStack stack) {
        return ToolStack.from(stack).getDamage();
    }

    public void setDamage(ItemStack stack, int damage) {
        ToolStack.from(stack).setDamage(damage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T damager, Consumer<T> onBroken) {
        if (ToolDamageUtil.damage(ToolStack.from(stack), amount, damager, stack)) {
            onBroken.accept(damager);
        }
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            Boolean show = entry.getModifier().showDurabilityBar(tool, entry.getLevel());
            if (show == null) continue;
            return show;
        }
        return tool.getDamage() > 0;
    }

    private double getDamagePercentage(ToolStack tool) {
        for (ModifierEntry entry : tool.getModifierList()) {
            double display = entry.getModifier().getDamagePercentage(tool, entry.getLevel());
            if (Double.isNaN(display)) continue;
            return display;
        }
        return (double)tool.getDamage() / (double)tool.getStats().getDurability();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 1.0;
        }
        return 0.95 * this.getDamagePercentage(tool);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            int rgb = entry.getModifier().getDurabilityRGB(tool, entry.getLevel());
            if (rgb == -1) continue;
            return rgb;
        }
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDamagePercentage(tool))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (ToolDamageUtil.isBroken(stack)) {
            return Collections.emptySet();
        }
        return super.getToolTypes(stack);
    }

    public int getHarvestLevel(ItemStack stack, ToolType toolClass, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (this.getToolTypes(stack).contains(toolClass)) {
            return ToolStack.from(stack).getStats().getHarvestLevel();
        }
        return -1;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            boolean isEffective = this.getToolHarvestLogic().isEffective(tool, stack, state);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().afterBlockBreak(tool, entry.getLevel(), worldIn, state, pos, entityLiving, isEffective);
            }
            ToolDamageUtil.damageAnimated(tool, this.getToolHarvestLogic().getDamage(tool, stack, worldIn, pos, state), entityLiving);
        }
        return true;
    }

    public final boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return this.getToolHarvestLogic().isEffective(ToolStack.from(stack), stack, state);
    }

    public final float func_150893_a(ItemStack stack, BlockState state) {
        return this.getToolHarvestLogic().getDestroySpeed(stack, state);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return ToolAttackUtil.attackEntity(stack, this, player, entity);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        float speed = ToolStack.from(stack).getStats().getAttackSpeed();
        int time = Math.round(20.0f / speed);
        if (time < target.field_70172_ad / 2) {
            target.field_70172_ad = (target.field_70172_ad + time) / 2;
            target.field_70737_aN = (target.field_70737_aN + time) / 2;
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    public float getDamageCutoff() {
        return this.getToolDefinition().getBaseStatDefinition().getDamageCutoff();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || nbt.func_74767_n("tic_display_tool")) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ToolStack tool = ToolStack.from(stack);
        if (slot == EquipmentSlotType.MAINHAND && !tool.isBroken()) {
            StatsNBT statsNBT = tool.getStats();
            builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "tconstruct.tool.attack_damage", (double)statsNBT.getAttackDamage(), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "tconstruct.tool.attack_speed", (double)statsNBT.getAttackSpeed() - 4.0, AttributeModifier.Operation.ADDITION));
            double reach = (double)statsNBT.getReach() - 5.0;
            if (reach != 0.0) {
                builder.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(REACH_MODIFIER, "tconstruct.tool.reach", reach, AttributeModifier.Operation.ADDITION));
            }
            BiConsumer<Attribute, AttributeModifier> attributeConsumer = (arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).put(arg_0, arg_1);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().addAttributes(tool, entry.getLevel(), attributeConsumer);
            }
        }
        return builder.build();
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return this.getToolHarvestLogic().handleBlockBreak(stack, pos, player);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ToolStack tool;
        List<ModifierEntry> modifiers;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof LivingEntity && !(modifiers = (tool = ToolStack.from(stack)).getModifierList()).isEmpty()) {
            LivingEntity living = (LivingEntity)entityIn;
            boolean isHeld = isSelected || living.func_184592_cb() == stack;
            for (ModifierEntry entry : modifiers) {
                entry.getModifier().onInventoryTick(tool, entry.getLevel(), worldIn, living, itemSlot, isSelected, isHeld, stack);
            }
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            ActionResultType result = entry.getModifier().onBlockUse(tool, entry.getLevel(), context);
            if (!result.func_226246_a_()) continue;
            return result;
        }
        return super.onItemUseFirst(stack, context);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            ActionResultType result = entry.getModifier().onEntityUse(tool, entry.getLevel(), playerIn, target, hand);
            if (!result.func_226246_a_()) continue;
            return result;
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        ToolStack tool = ToolStack.from(playerIn.func_184586_b(handIn));
        for (ModifierEntry entry : tool.getModifierList()) {
            ActionResultType result = entry.getModifier().onToolUse(tool, entry.getLevel(), worldIn, playerIn, handIn);
            if (!result.func_226246_a_()) continue;
            return new ActionResult(result, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            if (!entry.getModifier().onFinishUsing(tool, entry.getLevel(), worldIn, entityLiving)) continue;
            return stack;
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            boolean result = entry.getModifier().onStoppedUsing(tool, entry.getLevel(), worldIn, entityLiving, timeLeft);
            if (!result) continue;
            return;
        }
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public int func_77626_a(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            int result = entry.getModifier().getUseDuration(tool, entry.getLevel());
            if (result <= 0) continue;
            return result;
        }
        return super.func_77626_a(stack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            UseAction result = entry.getModifier().getUseAction(tool, entry.getLevel());
            if (result == UseAction.NONE) continue;
            return result;
        }
        return super.func_77661_b(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean isAdvanced;
        CompoundNBT tag = stack.func_77978_p();
        boolean bl = isAdvanced = flagIn == ITooltipFlag.TooltipFlags.ADVANCED;
        if (tag != null && tag.func_74767_n("tic_display_tool")) {
            ToolStack tool = ToolStack.from(stack);
            for (ModifierEntry entry : tool.getModifierList()) {
                if (!entry.getModifier().shouldDisplay(false)) continue;
                tooltip.add(entry.getModifier().getDisplayName(tool, entry.getLevel()));
            }
        } else if (Util.isShiftKeyDown()) {
            this.getTooltip(stack, tooltip, TooltipType.SHIFT, isAdvanced);
        } else if (Util.isCtrlKeyDown()) {
            this.getTooltip(stack, tooltip, TooltipType.CONTROL, isAdvanced);
        } else {
            this.getTooltip(stack, tooltip, TooltipType.NORMAL, isAdvanced);
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add(TOOLTIP_HOLD_SHIFT);
            tooltip.add(TOOLTIP_HOLD_CTRL);
        }
    }

    public void getTooltip(ItemStack stack, List<ITextComponent> tooltips, TooltipType tooltipType, boolean isAdvanced) {
        switch (tooltipType) {
            case NORMAL: {
                ToolStack tool = ToolStack.from(stack);
                tooltips.add(HeadMaterialStats.formatDurability(tool.getCurrentDurability(), tool.getStats().getDurability(), true));
                for (ModifierEntry entry : tool.getModifierList()) {
                    if (!entry.getModifier().shouldDisplay(false)) continue;
                    tooltips.add(entry.getModifier().getDisplayName(tool, entry.getLevel()));
                }
                break;
            }
            case SHIFT: {
                this.getStatInformation(ToolStack.from(stack), tooltips, isAdvanced, false);
                break;
            }
            case CONTROL: {
                ToolStack tool = ToolStack.from(stack);
                List<IMaterial> materials = tool.getMaterialsList();
                if (materials.isEmpty()) {
                    tooltips.add((ITextComponent)new StringTextComponent("No tool data. NBT missing."));
                    return;
                }
                List<IToolPart> components = this.getToolDefinition().getRequiredComponents();
                if (materials.size() < components.size()) {
                    return;
                }
                for (int i = 0; i < components.size(); ++i) {
                    IToolPart requirement = components.get(i);
                    IMaterial material = materials.get(i);
                    ItemStack partStack = requirement.withMaterial(material);
                    tooltips.add((ITextComponent)partStack.func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240718_a_(material.getColor())));
                    MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), requirement.getStatType()).ifPresent(stat -> tooltips.addAll(stat.getLocalizedInfo()));
                    tooltips.add(StringTextComponent.field_240750_d_);
                }
                break;
            }
        }
    }

    @Override
    public ITextComponent getLocalizedName() {
        return new TranslationTextComponent(this.func_77658_a());
    }

    @Override
    public List<ITextComponent> getInformation(ItemStack stack) {
        return this.getStatInformation(ToolStack.from(stack), new ArrayList<ITextComponent>(), false, true);
    }

    public List<ITextComponent> getStatInformation(ToolStack tool, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        builder.addDurability();
        builder.addAttackDamage();
        builder.addAttackSpeed();
        if (TinkerTags.Items.HARVEST.func_230235_a_((Object)tool.getItem())) {
            builder.addHarvestLevel();
            builder.addMiningSpeed();
        }
        builder.addFreeUpgrades();
        builder.addFreeAbilities();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getModifier().addInformation(tool, entry.getLevel(), tooltip, isAdvanced, detailed);
        }
        return builder.getTooltips();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            this.addDefaultSubItems((List<ItemStack>)items, new IMaterial[0]);
        }
    }

    protected void addDefaultSubItems(List<ItemStack> items, IMaterial ... fixedMaterials) {
        block3: {
            IMaterial material2;
            MaterialId materialId;
            if (!MaterialRegistry.initialized()) break block3;
            String showOnlyId = (String)Config.COMMON.showOnlyToolMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialId.tryCreate(showOnlyId)) != null && (material2 = MaterialRegistry.getMaterial(materialId)) != IMaterial.UNKNOWN && this.addSubItem(items, material2, fixedMaterials)) {
                added = true;
            }
            if (!added) {
                for (IMaterial material2 : MaterialRegistry.getInstance().getMaterials()) {
                    if (this.addSubItem(items, material2, fixedMaterials) && !showOnlyId.isEmpty()) break;
                }
            }
        }
    }

    protected boolean addSubItem(List<ItemStack> items, IMaterial material, IMaterial[] fixedMaterials) {
        List<IToolPart> required = this.getToolDefinition().getRequiredComponents();
        ArrayList<IMaterial> materials = new ArrayList<IMaterial>(required.size());
        for (int i = 0; i < required.size(); ++i) {
            if (fixedMaterials.length > i && fixedMaterials[i] != null && required.get(i).canUseMaterial(fixedMaterials[i])) {
                materials.add(fixedMaterials[i]);
                continue;
            }
            if (required.get(i).canUseMaterial(material)) {
                materials.add(material);
                continue;
            }
            return false;
        }
        items.add(ToolBuildHandler.buildItemFromMaterials(this, materials));
        return true;
    }

    public boolean hasValidMaterials(ItemStack stack) {
        List<IMaterial> materials = ToolStack.from(stack).getMaterialsList();
        if (materials.size() != this.getToolDefinition().getRequiredComponents().size()) {
            return false;
        }
        List<IToolPart> requirements = this.getToolDefinition().getRequiredComponents();
        for (int i = 0; i < materials.size(); ++i) {
            IMaterial material = materials.get(i);
            if (requirements.get(i).canUseMaterial(material)) continue;
            return false;
        }
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        List<IMaterial> materials = ToolStack.from(stack).getMaterialsList();
        List<IToolPart> components = this.getToolDefinition().getRequiredComponents();
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        if (materials.size() == components.size()) {
            for (int i = 0; i < components.size(); ++i) {
                if (!HeadMaterialStats.ID.equals((Object)components.get(i).getStatType()) || i >= materials.size()) continue;
                nameMaterials.add(materials.get(i));
            }
        }
        return ToolCore.getCombinedItemName(super.func_200295_i(stack), nameMaterials);
    }

    public static ITextComponent getCombinedItemName(ITextComponent itemName, Collection<IMaterial> materials) {
        block7: {
            block6: {
                if (materials.isEmpty()) break block6;
                if (!materials.stream().allMatch(IMaterial.UNKNOWN::equals)) break block7;
            }
            return itemName;
        }
        if (materials.size() == 1) {
            IMaterial material = materials.iterator().next();
            if (Util.canTranslate(material.getTranslationKey() + ".format")) {
                return new TranslationTextComponent(material.getTranslationKey() + ".format", new Object[]{itemName});
            }
            return new TranslationTextComponent(materials.iterator().next().getTranslationKey()).func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_(itemName);
        }
        StringTextComponent name = new StringTextComponent("");
        Iterator<IMaterial> iter = materials.iterator();
        IMaterial material = iter.next();
        name.func_230529_a_((ITextComponent)new TranslationTextComponent(material.getTranslationKey()));
        while (iter.hasNext()) {
            material = iter.next();
            name.func_240702_b_("-").func_230529_a_((ITextComponent)new TranslationTextComponent(material.getTranslationKey()));
        }
        name.func_240702_b_(" ").func_230529_a_(itemName);
        return name;
    }

    public ItemStack buildToolForRendering() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering(this, this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.COMMON;
    }

    public boolean func_179215_a(CompoundNBT nbt) {
        ToolStack tool = ToolStack.from(this, this.getToolDefinition(), nbt.func_74775_l("tag"));
        tool.rebuildStats();
        return true;
    }

    public static BlockRayTraceResult blockRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        return Item.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)fluidMode);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack == newStack) {
            return false;
        }
        if (slotChanged || oldStack.func_77973_b() != newStack.func_77973_b()) {
            return true;
        }
        ToolStack oldTool = ToolStack.from(oldStack);
        ToolStack newTool = ToolStack.from(newStack);
        if (!oldTool.getMaterialsList().equals(newTool.getMaterialsList())) {
            return true;
        }
        if (!oldTool.getModifierList().equals(newTool.getModifierList())) {
            return true;
        }
        Multimap attributesNew = newStack.func_111283_C(EquipmentSlotType.MAINHAND);
        Multimap attributesOld = oldStack.func_111283_C(EquipmentSlotType.MAINHAND);
        if (attributesNew.size() != attributesOld.size()) {
            return true;
        }
        for (Attribute attribute : attributesOld.keySet()) {
            if (!attributesNew.containsKey((Object)attribute)) {
                return true;
            }
            Iterator iter1 = attributesNew.get((Object)attribute).iterator();
            Iterator iter2 = attributesOld.get((Object)attribute).iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (((AttributeModifier)iter1.next()).equals(iter2.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }

    static {
        IFormattableTextComponent shift = Util.makeTranslation("key", "shift").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.ITALIC});
        TOOLTIP_HOLD_SHIFT = new TranslationTextComponent(Util.makeTranslationKey("tooltip", "hold_shift"), new Object[]{shift});
        IFormattableTextComponent ctrl = Util.makeTranslation("key", "ctrl").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC});
        TOOLTIP_HOLD_CTRL = new TranslationTextComponent(Util.makeTranslationKey("tooltip", "hold_ctrl"), new Object[]{ctrl});
    }
}

