/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper.aoe;

import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.RectangleAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class DepthAOEHarvestLogic
extends ToolHarvestLogic {
    private final int extraHeight;
    private final int extraDepth;

    @Override
    public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, ToolHarvestLogic.AOEMatchType matchType) {
        if (!this.canAOE(tool, stack, state, matchType)) {
            return Collections.emptyList();
        }
        int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
        return DepthAOEHarvestLogic.calculate(this, tool, stack, player, world, origin, this.extraHeight + expanded / 2, this.extraDepth + (expanded + 1) / 2 * 2, matchType);
    }

    public static Iterable<BlockPos> calculate(ToolHarvestLogic self, IModifierToolStack tool, ItemStack stack, PlayerEntity player, World world, BlockPos origin, int extraHeight, int extraDepth, ToolHarvestLogic.AOEMatchType matchType) {
        Direction heightDir;
        Direction depthDir;
        if (extraDepth == 0 && extraHeight == 0) {
            return Collections.emptyList();
        }
        Direction playerLook = player.func_174811_aO();
        float pitch = player.func_195050_f(1.0f);
        if (pitch < -60.0f) {
            depthDir = Direction.UP;
            heightDir = playerLook;
        } else if (pitch > 60.0f) {
            depthDir = Direction.DOWN;
            heightDir = playerLook;
        } else {
            heightDir = Direction.UP;
            depthDir = playerLook;
        }
        Predicate<BlockPos> posPredicate = DepthAOEHarvestLogic.getDefaultBlockPredicate(self, tool, stack, world, origin, matchType);
        return () -> new RectangleAOEHarvestLogic.RectangleIterator(origin, Direction.UP, 0, heightDir, extraHeight, depthDir, extraDepth, posPredicate);
    }

    public DepthAOEHarvestLogic(int extraHeight, int extraDepth) {
        this.extraHeight = extraHeight;
        this.extraDepth = extraDepth;
    }
}

