/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper.aoe;

import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.RectangleAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class CircleAOEHarvestLogic
extends ToolHarvestLogic {
    public static final CircleAOEHarvestLogic SMALL_2D = new CircleAOEHarvestLogic(1, false);
    protected final int diameter;
    protected final boolean is3D;

    @Override
    public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, ToolHarvestLogic.AOEMatchType matchType) {
        if (!this.canAOE(tool, stack, state, matchType)) {
            return Collections.emptyList();
        }
        int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
        return CircleAOEHarvestLogic.calculate(this, tool, stack, world, player, origin, sideHit, this.diameter + expanded, this.is3D, matchType);
    }

    public static Iterable<BlockPos> calculate(ToolHarvestLogic self, IModifierToolStack tool, ItemStack stack, World world, PlayerEntity player, BlockPos origin, Direction sideHit, int diameter, boolean is3D, ToolHarvestLogic.AOEMatchType matchType) {
        Direction widthDir;
        Direction heightDir;
        if (diameter == 1) {
            return Collections.emptyList();
        }
        Direction depthDir = sideHit.func_176734_d();
        if (sideHit.func_176740_k() == Direction.Axis.Y) {
            heightDir = player.func_174811_aO();
            widthDir = heightDir.func_176746_e();
        } else {
            widthDir = sideHit.func_176735_f();
            heightDir = Direction.UP;
        }
        Predicate<BlockPos> posPredicate = CircleAOEHarvestLogic.getDefaultBlockPredicate(self, tool, stack, world, origin, matchType);
        int radiusSq = diameter * diameter / 4;
        return () -> new CircleIterator(origin, widthDir, heightDir, depthDir, radiusSq, diameter / 2, is3D, posPredicate);
    }

    public CircleAOEHarvestLogic(int diameter, boolean is3D) {
        this.diameter = diameter;
        this.is3D = is3D;
    }

    private static class CircleIterator
    extends RectangleAOEHarvestLogic.RectangleIterator {
        private final int radiusSq;

        private CircleIterator(BlockPos origin, Direction widthDir, Direction heightDir, Direction depthDir, int radiusSq, int extra, boolean is3D, Predicate<BlockPos> posPredicate) {
            super(origin, widthDir, extra, heightDir, extra, depthDir, is3D ? extra : 0, posPredicate);
            this.radiusSq = radiusSq;
        }

        private int distanceSq() {
            int dx = this.origin.func_177958_n() - this.mutablePos.func_177958_n();
            int dy = this.origin.func_177956_o() - this.mutablePos.func_177956_o();
            int dz = this.origin.func_177952_p() - this.mutablePos.func_177952_p();
            return dx * dx + dy * dy + dz * dz;
        }

        @Override
        protected BlockPos computeNext() {
            this.mutablePos.func_181079_c(this.lastX, this.lastY, this.lastZ);
            while (this.incrementPosition()) {
                if (this.mutablePos.equals((Object)this.origin) || this.distanceSq() > this.radiusSq || !this.posPredicate.test(this.mutablePos)) continue;
                this.lastX = this.mutablePos.func_177958_n();
                this.lastY = this.mutablePos.func_177956_o();
                this.lastZ = this.mutablePos.func_177952_p();
                return this.mutablePos;
            }
            return (BlockPos)this.endOfData();
        }
    }
}

