/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.library.tools.helper.BlockSideHitListener;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolHarvestLogic {
    public static final ToolHarvestLogic DEFAULT = new ToolHarvestLogic();

    public int getDamage(ToolStack tool, ItemStack stack, World world, BlockPos pos, BlockState state) {
        if (state.func_185887_b((IBlockReader)world, pos) == 0.0f) {
            return 0;
        }
        return tool.getItem().func_206844_a(TinkerTags.Items.HARVEST) ? 1 : 2;
    }

    public boolean isEffectiveAgainst(IModifierToolStack tool, ItemStack stack, BlockState state) {
        return stack.getToolTypes().stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0));
    }

    public final boolean isEffective(IModifierToolStack tool, ItemStack stack, BlockState state) {
        if (tool.isBroken()) {
            return false;
        }
        if (state.func_235783_q_() && tool.getStats().getHarvestLevel() < state.getHarvestLevel()) {
            return false;
        }
        return this.isEffectiveAgainst(tool, stack, state);
    }

    public final boolean canAOE(IModifierToolStack tool, ItemStack stack, BlockState state, AOEMatchType matchType) {
        if (matchType == AOEMatchType.BREAKING) {
            return this.isEffective(tool, stack, state);
        }
        return !tool.isBroken();
    }

    public float getDestroySpeed(ItemStack stack, BlockState blockState) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 0.3f;
        }
        if (!this.isEffective(tool, stack, blockState)) {
            return 1.0f;
        }
        return tool.getStats().getMiningSpeed();
    }

    public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, AOEMatchType matchType) {
        return Collections.emptyList();
    }

    protected boolean removeBlock(PlayerEntity player, World world, BlockPos pos, boolean canHarvest) {
        BlockState state = world.func_180495_p(pos);
        boolean removed = state.removedByPlayer(world, pos, player, canHarvest, world.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)world, pos, state);
        }
        return removed;
    }

    protected boolean breakBlock(ToolStack tool, ItemStack stack, ServerPlayerEntity player, ServerWorld world, BlockPos pos, BlockState state) {
        GameType type = player.field_71134_c.func_73081_b();
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)type, (ServerPlayerEntity)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        if (player.func_223729_a((World)world, pos, type)) {
            return false;
        }
        if (player.func_184812_l_()) {
            this.removeBlock((PlayerEntity)player, (World)world, pos, false);
            return true;
        }
        boolean canHarvest = state.canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)player);
        int damage = this.getDamage(tool, stack, (World)world, pos, state);
        TileEntity te = canHarvest ? world.func_175625_s(pos) : null;
        boolean removed = this.removeBlock((PlayerEntity)player, (World)world, pos, canHarvest);
        if (removed && canHarvest) {
            state.func_177230_c().func_180657_a((World)world, (PlayerEntity)player, pos, state, te, stack);
        }
        if (removed && exp > 0) {
            state.func_177230_c().func_180637_b(world, pos, exp);
        }
        if (!tool.isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().afterBlockBreak(tool, entry.getLevel(), (World)world, state, pos, (LivingEntity)player, canHarvest);
            }
            ToolDamageUtil.damageAnimated(tool, damage, (LivingEntity)player);
        }
        return true;
    }

    public void breakExtraBlock(ToolStack tool, ItemStack stack, ServerPlayerEntity player, ServerWorld world, BlockPos pos) {
        if (tool.isBroken()) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos)) {
            return;
        }
        if (this.breakBlock(tool, stack, player, world, pos = pos.func_185334_h(), state)) {
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            TinkerNetwork.getInstance().sendVanillaPacket((Entity)player, (IPacket<?>)new SChangeBlockPacket((IBlockReader)world, pos));
        }
    }

    public boolean handleBlockBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (player.func_130014_f_().field_72995_K || !(player instanceof ServerPlayerEntity)) {
            return false;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        ServerWorld world = serverPlayer.func_71121_q();
        ToolStack tool = ToolStack.from(stack);
        BlockState state = world.func_180495_p(pos);
        if (tool.isBroken()) {
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            this.breakBlock(tool, ItemStack.field_190927_a, serverPlayer, world, pos, state);
            player.func_184611_a(Hand.MAIN_HAND, stack);
        } else {
            boolean addedEnchants = ModifierUtil.applyEnchantments(tool, stack, player);
            Iterable<BlockPos> extraBlocks = this.getAOEBlocks(tool, stack, player, state, (World)world, pos, BlockSideHitListener.getSideHit(player), AOEMatchType.BREAKING);
            if (this.breakBlock(tool, stack, serverPlayer, world, pos, state)) {
                for (BlockPos extraPos : extraBlocks) {
                    this.breakExtraBlock(tool, stack, serverPlayer, world, extraPos);
                }
            }
            if (addedEnchants) {
                ModifierUtil.clearEnchantments(stack);
            }
        }
        return true;
    }

    public ActionResultType transformBlocks(ItemUseContext context, ToolType toolType, SoundEvent sound, boolean requireGround) {
        boolean didTransform;
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        Hand hand = context.func_221531_n();
        ItemStack stack = context.func_195996_i();
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (requireGround) {
            if (context.func_196000_l() == Direction.DOWN) {
                return ActionResultType.PASS;
            }
            Material material = world.func_180495_p(pos.func_177984_a()).func_185904_a();
            if (!material.func_76222_j() && material != Material.field_151585_k) {
                return ActionResultType.PASS;
            }
        }
        BlockState original = world.func_180495_p(pos);
        BlockState transformed = original.getToolModifiedState(world, pos, player, stack, toolType);
        boolean isCampfire = false;
        boolean bl = didTransform = transformed != null;
        if (transformed == null) {
            if (toolType == ToolType.SHOVEL && original.func_177230_c() instanceof CampfireBlock && ((Boolean)original.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
                isCampfire = true;
                if (!world.func_201670_d()) {
                    world.func_217378_a(null, 1009, pos, 0);
                    CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)pos, (BlockState)original);
                }
                transformed = (BlockState)original.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
            } else {
                transformed = world.func_180495_p(pos);
            }
        }
        if (didTransform || isCampfire) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            world.func_180501_a(pos, transformed, 11);
            if (requireGround) {
                world.func_175655_b(pos.func_177984_a(), true);
            }
            if (!isCampfire) {
                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack) || isCampfire) {
                return ActionResultType.SUCCESS;
            }
        }
        int totalTransformed = 0;
        if (player != null) {
            for (BlockPos newPos : this.getAOEBlocks(tool, stack, player, original, world, pos, context.func_196000_l(), AOEMatchType.TRANSFORM)) {
                BlockState newState;
                Material material;
                if (pos.equals((Object)newPos)) continue;
                BlockPos above = newPos.func_177984_a();
                if (requireGround && !(material = world.func_180495_p(above).func_185904_a()).func_76222_j() && material != Material.field_151585_k || (newState = world.func_180495_p(newPos).getToolModifiedState(world, newPos, player, stack, toolType)) == null || transformed.func_177230_c() != newState.func_177230_c()) continue;
                if (world.func_201670_d()) {
                    return ActionResultType.SUCCESS;
                }
                world.func_180501_a(newPos, newState, 11);
                if (++totalTransformed < 40) {
                    world.func_184133_a(null, newPos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if (requireGround) {
                    world.func_175655_b(above, true);
                }
                if (!ToolDamageUtil.damageAnimated((IModifierToolStack)tool, 1, (LivingEntity)player, hand)) continue;
                break;
            }
            if (totalTransformed > 0) {
                player.func_184810_cG();
            }
        }
        return didTransform || totalTransformed > 0 ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public static Predicate<BlockPos> getDefaultBlockPredicate(ToolHarvestLogic self, IModifierToolStack tool, ItemStack stack, World world, BlockPos origin, AOEMatchType matchType) {
        if (matchType == AOEMatchType.BREAKING) {
            float refHardness = world.func_180495_p(origin).func_185887_b((IBlockReader)world, origin);
            return pos -> {
                BlockState state = world.func_180495_p(pos);
                if (state.isAir((IBlockReader)world, pos)) {
                    return false;
                }
                float hardness = state.func_185887_b((IBlockReader)world, pos);
                if (hardness == -1.0f) {
                    return false;
                }
                if (refHardness == 0.0f ? hardness == 0.0f : hardness / refHardness <= 3.0f) {
                    return self.isEffective(tool, stack, state);
                }
                return false;
            };
        }
        return pos -> !world.func_180495_p(pos).isAir((IBlockReader)world, pos);
    }

    public static enum AOEMatchType {
        BREAKING,
        TRANSFORM;

    }
}

