/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableWeapon;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolAttackUtil {
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;

    public static float getActualDamage(ToolStack stack, @Nullable LivingEntity player) {
        ModifiableAttributeInstance instance;
        float damage = (float)Attributes.field_233823_f_.func_111110_b();
        if (player != null && (instance = player.func_110148_a(Attributes.field_233823_f_)) != null) {
            damage = (float)instance.func_111126_e();
        }
        return ToolAttackUtil.calculateCutoffDamage(damage += stack.getStats().getAttackDamage(), stack.getDefinition().getBaseStatDefinition().getDamageCutoff());
    }

    public static float calculateCutoffDamage(float damageIn, float cutoffDamage) {
        float percent = 1.0f;
        float oldDamage = damageIn;
        damageIn = 0.0f;
        while (oldDamage > cutoffDamage) {
            damageIn += percent * cutoffDamage;
            if (percent > 0.001f) {
                percent *= 0.9f;
            } else {
                return damageIn += percent * cutoffDamage * (oldDamage / cutoffDamage - 1.0f);
            }
            oldDamage -= cutoffDamage;
        }
        return damageIn += percent * oldDamage;
    }

    public static boolean attackEntity(ItemStack stack, IModifiableWeapon weapon, PlayerEntity attacker, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(stack, weapon, (LivingEntity)attacker, targetEntity, null, true);
    }

    public static boolean attackEntity(ItemStack stack, IModifiableWeapon weapon, PlayerEntity attacker, Entity targetEntity, Entity projectileEntity) {
        return ToolAttackUtil.attackEntity(stack, weapon, (LivingEntity)attacker, targetEntity, projectileEntity, false);
    }

    public static boolean dealDefaultDamage(LivingEntity attacker, Entity target, float damage) {
        if (attacker instanceof PlayerEntity) {
            return target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), damage);
        }
        return target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), damage);
    }

    public static boolean attackEntity(ItemStack stack, IModifiableWeapon weapon, LivingEntity attackerLiving, Entity targetEntity, @Nullable Entity projectileEntity, boolean applyCoolDown) {
        return ToolAttackUtil.attackEntity(stack, weapon, ToolStack.from(stack), attackerLiving, targetEntity, projectileEntity, applyCoolDown, false);
    }

    public static boolean attackEntity(ItemStack stack, IModifiableWeapon weapon, ToolStack tool, LivingEntity attackerLiving, Entity targetEntity, @Nullable Entity projectileEntity, boolean applyCoolDown, boolean isExtraAttack) {
        boolean didHit;
        SoundEvent sound;
        Entity parent;
        if (tool.isBroken()) {
            return false;
        }
        if (!targetEntity.func_70075_an() || targetEntity.func_85031_j((Entity)attackerLiving)) {
            return true;
        }
        LivingEntity targetLiving = null;
        if (targetEntity instanceof LivingEntity) {
            targetLiving = (LivingEntity)targetEntity;
        } else if (targetEntity instanceof PartEntity && (parent = ((PartEntity)targetEntity).getParent()) instanceof LivingEntity) {
            targetLiving = (LivingEntity)parent;
        }
        PlayerEntity attackerPlayer = null;
        if (attackerLiving instanceof PlayerEntity) {
            attackerPlayer = (PlayerEntity)attackerLiving;
        }
        float damage = (float)attackerLiving.func_233637_b_(Attributes.field_233823_f_);
        float cooldown = 1.0f;
        if (applyCoolDown && attackerPlayer != null) {
            cooldown = attackerPlayer.func_184825_o(0.5f);
        }
        boolean fullyCharged = cooldown > 0.9f;
        boolean isCritical = !isExtraAttack && fullyCharged && attackerLiving.field_70143_R > 0.0f && !attackerLiving.func_233570_aj_() && !attackerLiving.func_70617_f_() && !attackerLiving.func_70090_H() && !attackerLiving.func_70644_a(Effects.field_76440_q) && !attackerLiving.func_184218_aH() && targetLiving != null && !attackerLiving.func_70051_ag();
        float baseDamage = damage;
        List<ModifierEntry> modifiers = tool.getModifierList();
        if (targetLiving != null) {
            for (ModifierEntry entry : modifiers) {
                damage = entry.getModifier().applyLivingDamage(tool, entry.getLevel(), attackerLiving, targetLiving, baseDamage, damage, isCritical, fullyCharged);
            }
        }
        if (damage <= 0.0f) {
            return !isExtraAttack;
        }
        float knockback = 0.0f;
        if (attackerLiving.func_70051_ag() && fullyCharged) {
            sound = SoundEvents.field_187721_dT;
            knockback = 0.5f;
        } else {
            sound = fullyCharged ? SoundEvents.field_187727_dV : SoundEvents.field_187733_dX;
        }
        if (fullyCharged) {
            knockback += tool.getDefinition().getBaseStatDefinition().getKnockbackBonus();
        }
        if (!isExtraAttack) {
            float criticalModifier;
            float f = criticalModifier = isCritical ? 1.5f : 1.0f;
            if (attackerPlayer != null) {
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)attackerPlayer, (Entity)targetEntity, (boolean)isCritical, (float)(isCritical ? 1.5f : 1.0f));
                boolean bl = isCritical = hitResult != null;
                if (isCritical) {
                    criticalModifier = hitResult.getDamageModifier();
                }
            }
            if (isCritical) {
                damage *= criticalModifier;
            }
        }
        boolean isMagic = damage > baseDamage;
        damage = ToolAttackUtil.calculateCutoffDamage(damage, weapon.getDamageCutoff());
        if (cooldown < 1.0f) {
            damage *= 0.2f + cooldown * cooldown * 0.8f;
        }
        Vector3d originalTargetMotion = targetEntity.func_213322_ci();
        float oldHealth = 0.0f;
        if (targetLiving != null) {
            oldHealth = targetLiving.func_110143_aJ();
        }
        float baseKnockback = knockback;
        if (targetLiving != null) {
            for (ModifierEntry modifierEntry : modifiers) {
                knockback = modifierEntry.getModifier().beforeLivingHit(tool, modifierEntry.getLevel(), attackerLiving, targetLiving, damage, baseKnockback, knockback, isCritical, fullyCharged);
            }
        }
        if (!(didHit = isExtraAttack ? ToolAttackUtil.dealDefaultDamage(attackerLiving, targetEntity, damage) : weapon.dealDamage(tool, attackerLiving, targetEntity, damage, isCritical, fullyCharged))) {
            if (!isExtraAttack) {
                attackerLiving.field_70170_p.func_184148_a(null, attackerLiving.func_226277_ct_(), attackerLiving.func_226278_cu_(), attackerLiving.func_226281_cx_(), SoundEvents.field_187724_dU, attackerLiving.func_184176_by(), 1.0f, 1.0f);
            }
            if (targetLiving != null) {
                for (ModifierEntry entry : modifiers) {
                    entry.getModifier().failedLivingHit(tool, entry.getLevel(), attackerLiving, targetLiving, isCritical, fullyCharged);
                }
            }
            return !isExtraAttack;
        }
        float f = damage;
        if (targetLiving != null) {
            f = oldHealth - targetLiving.func_110143_aJ();
        }
        if (knockback > 0.0f) {
            if (targetLiving != null) {
                targetLiving.func_233627_a_(knockback, (double)MathHelper.func_76126_a((float)(attackerLiving.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attackerLiving.field_70177_z * ((float)Math.PI / 180)))));
            } else {
                targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(attackerLiving.field_70177_z * ((float)Math.PI / 180))) * knockback), 0.1, (double)(MathHelper.func_76134_b((float)(attackerLiving.field_70177_z * ((float)Math.PI / 180))) * knockback));
            }
            attackerLiving.func_213317_d(attackerLiving.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            attackerLiving.func_70031_b(false);
        }
        if (targetEntity.field_70133_I && targetEntity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
            targetEntity.field_70133_I = false;
            targetEntity.func_213317_d(originalTargetMotion);
        }
        if (attackerPlayer != null) {
            if (isCritical) {
                sound = SoundEvents.field_187718_dS;
                attackerPlayer.func_71009_b(targetEntity);
            }
            if (isMagic) {
                attackerPlayer.func_71047_c(targetEntity);
            }
            if (sound != null) {
                attackerLiving.field_70170_p.func_184148_a(null, attackerLiving.func_226277_ct_(), attackerLiving.func_226278_cu_(), attackerLiving.func_226281_cx_(), sound, attackerLiving.func_184176_by(), 1.0f, 1.0f);
            }
        }
        if (attackerLiving.field_70170_p instanceof ServerWorld && f > 2.0f) {
            int particleCount = (int)(f * 0.5f);
            ((ServerWorld)attackerLiving.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226283_e_(0.5), targetEntity.func_226281_cx_(), particleCount, 0.1, 0.0, 0.1, 0.2);
        }
        attackerLiving.func_130011_c(targetEntity);
        if (targetLiving != null) {
            EnchantmentHelper.func_151384_a((LivingEntity)targetLiving, (Entity)attackerLiving);
        }
        int durabilityLost = 1;
        if (targetLiving != null) {
            for (ModifierEntry entry : modifiers) {
                durabilityLost += entry.getModifier().afterLivingHit(tool, entry.getLevel(), attackerLiving, targetLiving, f, isCritical, fullyCharged);
            }
        }
        if (attackerPlayer != null) {
            if (targetLiving != null) {
                if (!attackerLiving.field_70170_p.field_72995_K && !stack.func_190926_b()) {
                    stack.func_77961_a(targetLiving, attackerPlayer);
                }
                attackerPlayer.func_195067_a(Stats.field_188111_y, Math.round(f * 10.0f));
            }
            attackerPlayer.func_71020_j(0.1f);
        }
        if (!TinkerTags.Items.COMBAT.func_230235_a_((Object)tool.getItem())) {
            durabilityLost *= 2;
        }
        ToolDamageUtil.damageAnimated(tool, durabilityLost, attackerLiving);
        return true;
    }

    public static boolean extraEntityAttack(IModifiableWeapon weapon, ToolStack tool, LivingEntity attackerLiving, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(ItemStack.field_190927_a, weapon, tool, attackerLiving, targetEntity, null, false, true);
    }

    public static void spawnAttachParticle(IParticleData particleData, Entity entity, double height) {
        double xd = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        double zd = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        double yd = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        xd *= 1.0;
        yd *= 1.0;
        zd *= 1.0;
        if (entity.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)entity.field_70170_p).func_195598_a(particleData, entity.func_226277_ct_() + xd, entity.func_226278_cu_() + (double)entity.func_213302_cg() * height, entity.func_226281_cx_() + zd, 0, xd, yd, zd, 1.0);
        }
    }
}

