/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public final class ModifierUtil {
    private static final String TAG_ENCHANTMENTS = "Enchantments";
    private static final String TAG_HIDE_FLAGS = "HideFlags";

    public static boolean applyEnchantments(ToolStack tool, ItemStack stack, @Nullable PlayerEntity player) {
        boolean addedEnchants = false;
        if (player == null || !player.func_184812_l_()) {
            HashMap enchantments = new HashMap();
            BiConsumer<Enchantment, Integer> enchantmentConsumer = (ench, add) -> {
                if (ench != null && add != null) {
                    Integer level = (Integer)enchantments.get(ench);
                    if (level != null) {
                        add = add + level;
                    }
                    enchantments.put(ench, add);
                }
            };
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().applyEnchantments(tool, entry.getLevel(), enchantmentConsumer);
            }
            if (!enchantments.isEmpty()) {
                addedEnchants = true;
                EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
                stack.func_196082_o().func_74768_a(TAG_HIDE_FLAGS, ItemStack.TooltipDisplayFlags.ENCHANTMENTS.func_242397_a());
            }
        }
        return addedEnchants;
    }

    public static void clearEnchantments(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            nbt.func_82580_o(TAG_ENCHANTMENTS);
            nbt.func_82580_o(TAG_HIDE_FLAGS);
        }
    }

    private ModifierUtil() {
    }
}

