/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraftforge.common.util.Lazy;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolBaseStatDefinition;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.tools.ToolStatsBuilder;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public class ToolDefinition {
    private static final Set<MaterialStatsId> REPAIR_STATS = ImmutableSet.of((Object)((Object)HeadMaterialStats.ID));
    public static final ToolDefinition EMPTY = new ToolDefinition(new ToolBaseStatDefinition.Builder().build(), Collections::emptyList);
    private final ToolBaseStatDefinition baseStatDefinition;
    protected final Lazy<List<IToolPart>> requiredComponents;
    protected final Lazy<List<ModifierEntry>> modifiers;
    private int[] repairIndices;

    public ToolDefinition(ToolBaseStatDefinition baseStatDefinition, Supplier<List<IToolPart>> requiredComponents, Supplier<List<ModifierEntry>> modifiers) {
        this.baseStatDefinition = baseStatDefinition;
        this.requiredComponents = Lazy.of(requiredComponents);
        this.modifiers = Lazy.of(modifiers);
    }

    public ToolDefinition(ToolBaseStatDefinition baseStatDefinition, Supplier<List<IToolPart>> requiredComponents) {
        this(baseStatDefinition, requiredComponents, Collections::emptyList);
    }

    public ToolBaseStatDefinition getBaseStatDefinition() {
        return this.baseStatDefinition;
    }

    public List<IToolPart> getRequiredComponents() {
        return (List)this.requiredComponents.get();
    }

    public StatsNBT buildStats(List<IMaterial> materials) {
        return ToolStatsBuilder.from(materials, this).buildStats();
    }

    public List<ModifierEntry> getModifiers() {
        return (List)this.modifiers.get();
    }

    public int[] getRepairParts() {
        if (this.repairIndices == null) {
            List components = (List)this.requiredComponents.get();
            this.repairIndices = IntStream.range(0, components.size()).filter(i -> REPAIR_STATS.contains((Object)((IToolPart)components.get(i)).getStatType())).toArray();
        }
        return this.repairIndices;
    }
}

