/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.ToolCore;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public final class ToolBuildHandler {
    public static final String KEY_DISPLAY_TOOL = "tic_display_tool";
    private static final List<MaterialId> RENDER_MATERIALS = Arrays.asList(new MaterialId("tconstruct", "ui_render_head"), new MaterialId("tconstruct", "ui_render_handle"), new MaterialId("tconstruct", "ui_render_extra"), new MaterialId("tconstruct", "ui_render_large"), new MaterialId("tconstruct", "ui_render_extra_large"));

    public static ItemStack buildItemFromStacks(NonNullList<ItemStack> stacks, ToolCore tool) {
        if (!ToolBuildHandler.canToolBeBuilt(stacks, tool)) {
            return ItemStack.field_190927_a;
        }
        List<IMaterial> materials = stacks.stream().filter(stack -> !stack.func_190926_b()).map(IMaterialItem::getMaterialFromStack).collect(Collectors.toList());
        return ToolBuildHandler.buildItemFromMaterials(tool, materials);
    }

    public static ItemStack buildItemFromMaterials(ToolCore tool, List<IMaterial> materials) {
        return ToolStack.createTool(tool, tool.getToolDefinition(), materials).createStack();
    }

    public static MaterialId getRenderMaterial(int index) {
        return RENDER_MATERIALS.get(index % RENDER_MATERIALS.size());
    }

    public static ItemStack buildToolForRendering(Item item, ToolDefinition definition) {
        List<IToolPart> requirements = definition.getRequiredComponents();
        int size = requirements.size();
        ArrayList<MaterialId> toolMaterials = new ArrayList<MaterialId>(size);
        for (int i = 0; i < requirements.size(); ++i) {
            toolMaterials.add(i, ToolBuildHandler.getRenderMaterial(i));
        }
        ItemStack stack = new MaterialIdNBT(toolMaterials).updateStack(new ItemStack((IItemProvider)item));
        stack.func_196082_o().func_74757_a(KEY_DISPLAY_TOOL, true);
        return stack;
    }

    public static boolean canToolBeBuilt(NonNullList<ItemStack> stacks, ToolCore tool) {
        List<IToolPart> requiredComponents = tool.getToolDefinition().getRequiredComponents();
        return stacks.size() == requiredComponents.size() && ToolBuildHandler.canBeBuiltFromParts(stacks, requiredComponents);
    }

    private static boolean canBeBuiltFromParts(NonNullList<ItemStack> stacks, List<IToolPart> requiredComponents) {
        return Streams.zip(requiredComponents.stream(), (Stream)stacks.stream(), (part, stack) -> part.func_199767_j() == stack.func_77973_b() && part.getMaterial((ItemStack)stack) != IMaterial.UNKNOWN).allMatch(Boolean::booleanValue);
    }

    private ToolBuildHandler() {
    }
}

