/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.tools.ModifierStatsBuilder;

public final class ToolBaseStatDefinition {
    private final float durabilityModifier;
    private final int primaryHeadWeight;
    private final int defaultUpgrades;
    private final int defaultAbilities;
    private final int defaultTraits;
    private final float reachBonus;
    private final float miningSpeedModifier;
    private final float damageBonus;
    private final float damageModifier;
    private final float damageCutoff;
    private final float attackSpeed;
    private final float knockbackBonus;

    public void buildStats(ModifierStatsBuilder builder) {
        builder.multiplyDurability(this.durabilityModifier);
        builder.addReach(this.reachBonus);
        builder.multiplyMiningSpeed(this.miningSpeedModifier);
        builder.addAttackDamage(this.damageBonus);
        builder.multiplyAttackDamage(this.damageModifier);
        builder.multiplyAttackSpeed(this.attackSpeed);
    }

    public float getDurabilityModifier() {
        return this.durabilityModifier;
    }

    public int getPrimaryHeadWeight() {
        return this.primaryHeadWeight;
    }

    public int getDefaultUpgrades() {
        return this.defaultUpgrades;
    }

    public int getDefaultAbilities() {
        return this.defaultAbilities;
    }

    public int getDefaultTraits() {
        return this.defaultTraits;
    }

    public float getReachBonus() {
        return this.reachBonus;
    }

    public float getMiningSpeedModifier() {
        return this.miningSpeedModifier;
    }

    public float getDamageBonus() {
        return this.damageBonus;
    }

    public float getDamageModifier() {
        return this.damageModifier;
    }

    public float getDamageCutoff() {
        return this.damageCutoff;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public float getKnockbackBonus() {
        return this.knockbackBonus;
    }

    protected ToolBaseStatDefinition(float durabilityModifier, int primaryHeadWeight, int defaultUpgrades, int defaultAbilities, int defaultTraits, float reachBonus, float miningSpeedModifier, float damageBonus, float damageModifier, float damageCutoff, float attackSpeed, float knockbackBonus) {
        this.durabilityModifier = durabilityModifier;
        this.primaryHeadWeight = primaryHeadWeight;
        this.defaultUpgrades = defaultUpgrades;
        this.defaultAbilities = defaultAbilities;
        this.defaultTraits = defaultTraits;
        this.reachBonus = reachBonus;
        this.miningSpeedModifier = miningSpeedModifier;
        this.damageBonus = damageBonus;
        this.damageModifier = damageModifier;
        this.damageCutoff = damageCutoff;
        this.attackSpeed = attackSpeed;
        this.knockbackBonus = knockbackBonus;
    }

    public static class Builder {
        private float durabilityModifier = 1.0f;
        private float reachBonus = 0.0f;
        private int primaryHeadWeight = 1;
        private int defaultUpgrades = 3;
        private int defaultAbilities = 1;
        private int defaultTraits = 0;
        private float miningSpeedModifier = 1.0f;
        private float damageBonus = 0.0f;
        private float damageModifier = 1.0f;
        private float damageCutoff = 15.0f;
        private float attackSpeed = 1.0f;
        private float knockbackBonus = 0.0f;

        public ToolBaseStatDefinition build() {
            if ((double)this.damageModifier < 0.001) {
                throw new TinkerAPIException("Trying to define a tool without damage modifier set. Damage modifier has to be defined per tool and should be greater than 0.001");
            }
            return new ToolBaseStatDefinition(this.durabilityModifier, this.primaryHeadWeight, this.defaultUpgrades, this.defaultAbilities, this.defaultTraits, this.reachBonus, this.miningSpeedModifier, this.damageBonus, this.damageModifier, this.damageCutoff, this.attackSpeed, this.knockbackBonus);
        }

        public Builder setDurabilityModifier(float durabilityModifier) {
            this.durabilityModifier = durabilityModifier;
            return this;
        }

        public Builder setReachBonus(float reachBonus) {
            this.reachBonus = reachBonus;
            return this;
        }

        public Builder setPrimaryHeadWeight(int primaryHeadWeight) {
            this.primaryHeadWeight = primaryHeadWeight;
            return this;
        }

        public Builder setDefaultUpgrades(int defaultUpgrades) {
            this.defaultUpgrades = defaultUpgrades;
            return this;
        }

        public Builder setDefaultAbilities(int defaultAbilities) {
            this.defaultAbilities = defaultAbilities;
            return this;
        }

        public Builder setDefaultTraits(int defaultTraits) {
            this.defaultTraits = defaultTraits;
            return this;
        }

        public Builder setMiningSpeedModifier(float miningSpeedModifier) {
            this.miningSpeedModifier = miningSpeedModifier;
            return this;
        }

        public Builder setDamageBonus(float damageBonus) {
            this.damageBonus = damageBonus;
            return this;
        }

        public Builder setDamageModifier(float damageModifier) {
            this.damageModifier = damageModifier;
            return this;
        }

        public Builder setDamageCutoff(float damageCutoff) {
            this.damageCutoff = damageCutoff;
            return this;
        }

        public Builder setAttackSpeed(float attackSpeed) {
            this.attackSpeed = attackSpeed;
            return this;
        }

        public Builder setKnockbackBonus(float knockbackBonus) {
            this.knockbackBonus = knockbackBonus;
            return this;
        }
    }
}

