/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class ModifierStatsBuilder {
    private boolean dirty = false;
    private int harvestLevel = 0;
    private int addDurability = 0;
    private float multiplyDurability = 1.0f;
    private float addAttackDamage = 0.0f;
    private float multiplyAttackDamage = 1.0f;
    private float addAttackSpeed = 0.0f;
    private float multiplyAttackSpeed = 1.0f;
    private float addMiningSpeed = 0.0f;
    private float multiplyMiningSpeed = 1.0f;
    private float addReach = 0.0f;
    private float multiplyReach = 1.0f;

    public ModifierStatsBuilder setHarvestLevel(int level) {
        if (level > this.harvestLevel) {
            this.harvestLevel = level;
            this.dirty = true;
        }
        return this;
    }

    public ModifierStatsBuilder addDurability(int amount) {
        this.addDurability += amount;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder multiplyDurability(float factor) {
        this.multiplyDurability *= factor;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder addAttackDamage(float amount) {
        this.addAttackDamage += amount;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder multiplyAttackDamage(float factor) {
        this.multiplyAttackDamage *= factor;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder addAttackSpeed(float amount) {
        this.addAttackSpeed += amount;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder multiplyAttackSpeed(float factor) {
        this.multiplyAttackSpeed *= factor;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder addMiningSpeed(float amount) {
        this.addMiningSpeed += amount;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder multiplyMiningSpeed(float factor) {
        this.multiplyMiningSpeed *= factor;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder addReach(float amount) {
        this.addReach += amount;
        this.dirty = true;
        return this;
    }

    public ModifierStatsBuilder multiplyReach(float factor) {
        this.multiplyReach *= factor;
        this.dirty = true;
        return this;
    }

    public StatsNBT build(StatsNBT base) {
        if (!this.dirty) {
            return base;
        }
        return StatsNBT.builder().durability(Math.max((int)((float)(base.getDurability() + this.addDurability) * this.multiplyDurability), 1)).harvestLevel(Math.max(base.getHarvestLevel(), this.harvestLevel)).attackDamage((base.getAttackDamage() + this.addAttackDamage) * this.multiplyAttackDamage).miningSpeed((base.getMiningSpeed() + this.addMiningSpeed) * this.multiplyMiningSpeed).attackSpeed((base.getAttackSpeed() + this.addAttackSpeed) * this.multiplyAttackSpeed).reach((base.getReach() + this.addReach) * this.multiplyReach).build();
    }

    private ModifierStatsBuilder() {
    }

    public static ModifierStatsBuilder builder() {
        return new ModifierStatsBuilder();
    }
}

