/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tinkering;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterial;
import slimeknights.tconstruct.library.materials.MaterialId;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;

public class MaterialItem
extends Item
implements IMaterialItem {
    public MaterialItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public Optional<MaterialId> getMaterialId(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p()).map(compoundNBT -> compoundNBT.func_74779_i("Material")).filter(string -> !string.isEmpty()).map(MaterialId::tryCreate);
    }

    @Override
    public ItemStack withMaterialForDisplay(MaterialId materialId) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        stack.func_196082_o().func_74778_a("Material", materialId.toString());
        return stack;
    }

    @Override
    public ItemStack withMaterial(IMaterial material) {
        if (this.canUseMaterial(material)) {
            return this.withMaterialForDisplay(material.getIdentifier());
        }
        return new ItemStack((IItemProvider)this);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && MaterialRegistry.initialized()) {
            IMaterial material2;
            MaterialId materialId;
            String showOnlyId = (String)Config.COMMON.showOnlyPartMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialId.tryCreate(showOnlyId)) != null && (material2 = MaterialRegistry.getMaterial(materialId)) != IMaterial.UNKNOWN && this.canUseMaterial(material2)) {
                items.add((Object)this.withMaterial(MaterialRegistry.getMaterial(materialId)));
                added = true;
            }
            if (!added) {
                for (IMaterial material2 : MaterialRegistry.getInstance().getMaterials()) {
                    if (!this.canUseMaterial(material2)) continue;
                    items.add((Object)this.withMaterial(material2));
                    if (showOnlyId.isEmpty()) continue;
                    break;
                }
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IMaterial material = this.getMaterial(stack);
        if (material == IMaterial.UNKNOWN) {
            return super.func_200295_i(stack);
        }
        String key = this.func_77667_c(stack);
        MaterialId loc = material.getIdentifier();
        String fullKey = String.format("%s.%s.%s", key, loc.func_110624_b(), loc.func_110623_a());
        if (Util.canTranslate(fullKey)) {
            return new TranslationTextComponent(fullKey);
        }
        String materialKey = material.getTranslationKey();
        String materialPrefix = materialKey + ".format";
        if (Util.canTranslate(materialPrefix)) {
            return new TranslationTextComponent(materialPrefix, new Object[]{new TranslationTextComponent(key)});
        }
        return new TranslationTextComponent(materialKey).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(key));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        MaterialItem.addModTooltip(this.getMaterial(stack), tooltip);
    }

    protected static void addModTooltip(IMaterial material, List<ITextComponent> tooltip) {
        if (MaterialRegistry.getInstance().getMaterial(material.getIdentifier()) != IMaterial.UNKNOWN) {
            for (ModInfo modInfo : ModList.get().getMods()) {
                if (!modInfo.getModId().equalsIgnoreCase(material.getIdentifier().func_110624_b())) continue;
                tooltip.add((ITextComponent)new StringTextComponent(""));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.part.material_added_by", new Object[]{modInfo.getDisplayName()}));
                break;
            }
        }
    }
}

